/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.css;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMClientRect;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNSElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMViewCSS;

public class BoxModelPaintListener
implements PaintListener {
    private boolean set = false;
    private String x_val;
    private String y_val;
    private String width;
    private String height;
    private String margintop;
    private String marginbottom;
    private String marginright;
    private String marginleft;
    private String paddingtop;
    private String paddingbottom;
    private String paddingright;
    private String paddingleft;
    private String bordertopwidth;
    private String bordertopstyle;
    private String bordertopcolor;
    private String borderbottomwidth;
    private String borderbottomstyle;
    private String borderbottomcolor;
    private String borderleftwidth;
    private String borderleftstyle;
    private String borderleftcolor;
    private String borderrightwidth;
    private String borderrightstyle;
    private String borderrightcolor;
    private Canvas canvas;
    private Color black = Display.getCurrent().getSystemColor(2);
    private Color white = Display.getCurrent().getSystemColor(1);
    private Color blue = Display.getCurrent().getSystemColor(9);
    private Map colors = new HashMap();
    private static final int TOP = 0;
    private static final int RIGHT = 1;
    private static final int BOTTOM = 2;
    private static final int LEFT = 3;

    public void setCanvas(Canvas canvas) {
        this.canvas = canvas;
    }

    public void paintControl(PaintEvent e) {
        if (this.set) {
            GC gc = e.gc;
            gc.setLineWidth(3);
            int x = this.canvas.getSize().x / 2 - 50;
            int y = this.canvas.getSize().y / 2 - 25;
            int width = 100;
            int height = 50;
            gc.setBackground(this.white);
            gc.drawRectangle(x, y, width, height);
            String dimensions = String.valueOf(this.width) + " x " + this.height;
            int topoffset = gc.getFontMetrics().getAverageCharWidth() * dimensions.length();
            gc.drawString("Dimensions", x + gc.getLineWidth() + 2, y + gc.getLineWidth() + 2);
            gc.drawString(dimensions, x + width / 2 - topoffset / 2, y + height / 2 - gc.getFontMetrics().getHeight() / 2);
            gc.setForeground(this.blue);
            topoffset = gc.getFontMetrics().getAverageCharWidth() * this.paddingtop.length();
            int leftoffset = gc.getFontMetrics().getAverageCharWidth() * this.paddingleft.length();
            int rightoffset = gc.getFontMetrics().getAverageCharWidth() * this.paddingright.length();
            int bottomoffset = gc.getFontMetrics().getAverageCharWidth() * this.paddingbottom.length();
            int margin = Math.max(leftoffset, rightoffset) + 4;
            gc.drawString(this.paddingtop, x + width / 2 - topoffset / 2, y - gc.getFontMetrics().getHeight() - 4);
            gc.drawString(this.paddingleft, x - margin - gc.getLineWidth(), y + height / 2 - gc.getFontMetrics().getHeight() / 2);
            gc.drawString(this.paddingright, x + width + gc.getLineWidth(), y + height / 2 - gc.getFontMetrics().getHeight() / 2);
            gc.drawString(this.paddingbottom, x + width / 2 - bottomoffset / 2, y + height + gc.getLineWidth());
            gc.setForeground(this.black);
            x = x - margin - gc.getLineWidth() - 10;
            y = y - gc.getFontMetrics().getHeight() - gc.getLineWidth() - 5;
            width = width + margin * 2 + 2 * gc.getLineWidth() + 20;
            height = height + 2 * gc.getFontMetrics().getHeight() + 2 * gc.getLineWidth() + 10;
            gc.setLineDash(new int[]{5});
            gc.drawRectangle(x, y, width, height);
            gc.drawString("Padding", x + gc.getLineWidth() + 2, y + gc.getLineWidth() + 2);
            gc.setLineDash(null);
            topoffset = gc.getFontMetrics().getAverageCharWidth() * this.bordertopwidth.length();
            leftoffset = gc.getFontMetrics().getAverageCharWidth() * this.borderleftwidth.length();
            rightoffset = gc.getFontMetrics().getAverageCharWidth() * this.borderrightwidth.length();
            bottomoffset = gc.getFontMetrics().getAverageCharWidth() * this.borderbottomwidth.length();
            margin = Math.max(leftoffset, rightoffset) + 4;
            gc.setForeground(this.blue);
            gc.drawString(this.bordertopwidth, x + width / 2 - topoffset / 2, y - gc.getFontMetrics().getHeight() - 4);
            gc.drawString(this.borderleftwidth, x - margin - gc.getLineWidth(), y + height / 2 - gc.getFontMetrics().getHeight() / 2);
            gc.drawString(this.borderrightwidth, x + width + gc.getLineWidth(), y + height / 2 - gc.getFontMetrics().getHeight() / 2);
            gc.drawString(this.borderbottomwidth, x + width / 2 - bottomoffset / 2, y + height + gc.getLineWidth());
            gc.setForeground(this.black);
            x = x - margin - gc.getLineWidth() - 10;
            y = y - gc.getFontMetrics().getHeight() - gc.getLineWidth() - 5;
            width = width + margin * 2 + 2 * gc.getLineWidth() + 20;
            height = height + 2 * gc.getFontMetrics().getHeight() + 2 * gc.getLineWidth() + 10;
            gc.drawString("Border", x + gc.getLineWidth() + 2, y + gc.getLineWidth() + 2);
            String value = this.bordertopcolor.substring(this.bordertopcolor.indexOf(40) + 1);
            int red = Integer.parseInt(value.substring(0, value.indexOf(44)).trim());
            value = value.substring(value.indexOf(44) + 1);
            int green = Integer.parseInt(value.substring(0, value.indexOf(44)).trim());
            value = value.substring(value.indexOf(44) + 1);
            int blue = Integer.parseInt(value.substring(0, value.indexOf(41)).trim());
            RGB topcolor = new RGB(red, green, blue);
            gc.setForeground(this.getColor(topcolor));
            gc.drawLine(x, y, x + width, y);
            value = this.borderleftcolor.substring(this.borderleftcolor.indexOf(40) + 1);
            red = Integer.parseInt(value.substring(0, value.indexOf(44)).trim());
            value = value.substring(value.indexOf(44) + 1);
            green = Integer.parseInt(value.substring(0, value.indexOf(44)).trim());
            value = value.substring(value.indexOf(44) + 1);
            blue = Integer.parseInt(value.substring(0, value.indexOf(41)).trim());
            RGB leftcolor = new RGB(red, green, blue);
            gc.setForeground(this.getColor(leftcolor));
            gc.drawLine(x, y, x, y + height);
            value = this.borderrightcolor.substring(this.borderrightcolor.indexOf(40) + 1);
            red = Integer.parseInt(value.substring(0, value.indexOf(44)).trim());
            value = value.substring(value.indexOf(44) + 1);
            green = Integer.parseInt(value.substring(0, value.indexOf(44)).trim());
            value = value.substring(value.indexOf(44) + 1);
            blue = Integer.parseInt(value.substring(0, value.indexOf(41)).trim());
            RGB rightcolor = new RGB(red, green, blue);
            gc.setForeground(this.getColor(rightcolor));
            gc.drawLine(x + width, y, x + width, y + height);
            value = this.borderbottomcolor.substring(this.borderbottomcolor.indexOf(40) + 1);
            red = Integer.parseInt(value.substring(0, value.indexOf(44)).trim());
            value = value.substring(value.indexOf(44) + 1);
            green = Integer.parseInt(value.substring(0, value.indexOf(44)).trim());
            value = value.substring(value.indexOf(44) + 1);
            blue = Integer.parseInt(value.substring(0, value.indexOf(41)).trim());
            RGB bottomcolor = new RGB(red, green, blue);
            gc.setForeground(this.getColor(bottomcolor));
            gc.drawLine(x, y + height, x + width, y + height);
            topoffset = gc.getFontMetrics().getAverageCharWidth() * this.margintop.length();
            leftoffset = gc.getFontMetrics().getAverageCharWidth() * this.marginleft.length();
            rightoffset = gc.getFontMetrics().getAverageCharWidth() * this.marginright.length();
            bottomoffset = gc.getFontMetrics().getAverageCharWidth() * this.marginbottom.length();
            margin = Math.max(leftoffset, rightoffset) + 4;
            gc.setForeground(this.blue);
            gc.drawString(this.margintop, x + width / 2 - topoffset / 2, y - gc.getFontMetrics().getHeight() - 4);
            gc.drawString(this.marginleft, x - margin - gc.getLineWidth(), y + height / 2 - gc.getFontMetrics().getHeight() / 2);
            gc.drawString(this.marginright, x + width + gc.getLineWidth(), y + height / 2 - gc.getFontMetrics().getHeight() / 2);
            gc.drawString(this.marginbottom, x + width / 2 - bottomoffset / 2, y + height + gc.getLineWidth());
            gc.setForeground(this.black);
            x = x - margin - gc.getLineWidth() - 10;
            y = y - gc.getFontMetrics().getHeight() - gc.getLineWidth() - 5;
            width = width + margin * 2 + 2 * gc.getLineWidth() + 20;
            height = height + 2 * gc.getFontMetrics().getHeight() + 2 * gc.getLineWidth() + 10;
            gc.setLineDash(new int[]{3});
            gc.drawString("Margin", x + gc.getLineWidth() + 2, y + gc.getLineWidth() + 2);
            gc.drawRectangle(x, y, width, height);
        }
    }

    public void setNode(nsIDOMNode currentNode) {
        this.set = true;
        nsIDOMElement element = (nsIDOMElement)currentNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        nsIDOMNSElement nselement = (nsIDOMNSElement)element.queryInterface("{c9da11bc-32d4-425e-a91f-7e0939c39251}");
        nsIDOMClientRect elementBox = nselement.getBoundingClientRect();
        nsIDOMDocumentView documentView = (nsIDOMDocumentView)element.getOwnerDocument().queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
        nsIDOMViewCSS cssView = (nsIDOMViewCSS)documentView.getDefaultView().queryInterface("{0b9341f3-95d4-4fa4-adcd-e119e0db2889}");
        nsIDOMCSSStyleDeclaration computedStyle = cssView.getComputedStyle(element, "");
        this.x_val = String.valueOf(elementBox.getTop());
        this.y_val = String.valueOf(elementBox.getLeft());
        this.width = String.valueOf(elementBox.getWidth());
        this.height = String.valueOf(elementBox.getHeight());
        this.margintop = computedStyle.getPropertyCSSValue("margin-top").getCssText();
        this.marginbottom = computedStyle.getPropertyCSSValue("margin-bottom").getCssText();
        this.marginright = computedStyle.getPropertyCSSValue("margin-right").getCssText();
        this.marginleft = computedStyle.getPropertyCSSValue("margin-left").getCssText();
        this.paddingtop = computedStyle.getPropertyCSSValue("padding-top").getCssText();
        this.paddingbottom = computedStyle.getPropertyCSSValue("padding-bottom").getCssText();
        this.paddingright = computedStyle.getPropertyCSSValue("padding-right").getCssText();
        this.paddingleft = computedStyle.getPropertyCSSValue("padding-left").getCssText();
        this.bordertopwidth = computedStyle.getPropertyCSSValue("border-top-width").getCssText();
        this.bordertopstyle = computedStyle.getPropertyCSSValue("border-top-style").getCssText();
        this.bordertopcolor = computedStyle.getPropertyCSSValue("border-top-color").getCssText();
        this.borderbottomwidth = computedStyle.getPropertyCSSValue("border-bottom-width").getCssText();
        this.borderbottomstyle = computedStyle.getPropertyCSSValue("border-bottom-style").getCssText();
        this.borderbottomcolor = computedStyle.getPropertyCSSValue("border-bottom-color").getCssText();
        this.borderleftwidth = computedStyle.getPropertyCSSValue("border-left-width").getCssText();
        this.borderleftstyle = computedStyle.getPropertyCSSValue("border-left-style").getCssText();
        this.borderleftcolor = computedStyle.getPropertyCSSValue("border-left-color").getCssText();
        this.borderrightwidth = computedStyle.getPropertyCSSValue("border-right-width").getCssText();
        this.borderrightstyle = computedStyle.getPropertyCSSValue("border-right-style").getCssText();
        this.borderrightcolor = computedStyle.getPropertyCSSValue("border-right-color").getCssText();
    }

    public void dispose() {
        for (Color color : this.colors.values()) {
            if (color.isDisposed()) continue;
            color.dispose();
        }
        this.colors.clear();
    }

    private Color getColor(RGB color) {
        Color theColor = (Color)this.colors.get(color);
        if (theColor == null) {
            theColor = new Color((Device)Display.getCurrent(), color);
            this.colors.put(color, theColor);
        }
        return theColor;
    }
}

