/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.css;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.atf.mozilla.ide.common.IDOMNodeSelection;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.core.util.SourceLocatorUtil;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentEvent;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentListener;
import org.eclipse.atf.mozilla.ide.events.DOMMutationListener;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.views.IBrowserView;
import org.eclipse.atf.mozilla.ide.ui.common.SelectionProviderHandler;
import org.eclipse.atf.mozilla.ide.ui.common.configs.CSSViewerConfiguration;
import org.eclipse.atf.mozilla.ide.ui.css.BoxModelContentProvider;
import org.eclipse.atf.mozilla.ide.ui.css.BoxModelPaintListener;
import org.eclipse.atf.mozilla.ide.ui.css.CSSLabelProvider;
import org.eclipse.atf.mozilla.ide.ui.css.CSSProperty;
import org.eclipse.atf.mozilla.ide.ui.css.CSSPropertyEditingSupport;
import org.eclipse.atf.mozilla.ide.ui.css.CSSPropertyLocator;
import org.eclipse.atf.mozilla.ide.ui.css.ComputedStylesContentProvider;
import org.eclipse.atf.mozilla.ide.ui.css.ICSSPage;
import org.eclipse.atf.mozilla.ide.ui.css.StyleRulesContentProvider;
import org.eclipse.atf.mozilla.ide.ui.util.SourceDisplayUtil;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.text.source.VerticalRuler;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.Page;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMDocumentTraversal;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMTreeWalker;

public class CSSPage
extends Page
implements ICSSPage,
ISelectionListener,
IBrowserView,
SelectionListener,
ISelectionChangedListener {
    protected CSSPropertyLocator cpl = new CSSPropertyLocator();
    protected SashForm ruleDisplay;
    protected Tree ruleTree;
    protected TreeViewer ruleViewer;
    private StyleRulesContentProvider ruleViewerContentProvider;
    protected ColorSelector selector;
    protected IWebBrowser documentContainer;
    protected nsIDOMNode currentlySelectedNode = null;
    protected SashForm diffs;
    protected SourceViewer originalViewer;
    protected Document originalDoc;
    protected SourceViewer modifiedViewer;
    protected Document modifiedDoc;
    protected SelectionProviderHandler provider = new SelectionProviderHandler();
    protected SashForm compDisplay;
    protected Tree compTree;
    protected TreeViewer compViewer;
    protected SashForm boxDisplay;
    protected Tree boxTree;
    protected TreeViewer boxViewer;
    protected SashForm diffDisplay;
    protected boolean canHighlight = false;
    protected boolean shouldIndex = false;
    protected CTabFolder tabFolder;
    protected CTabItem rulesTab;
    protected CTabItem computedTab;
    protected CTabItem boxTab;
    protected CTabItem diffTab;
    protected SashForm comp;
    protected Composite top;
    protected boolean refreshRules = true;
    protected boolean refreshBox = true;
    protected boolean refreshComputed = true;
    protected boolean refreshDiff = true;
    protected Button leftBox;
    protected Button rightBox;
    protected Button upBox;
    protected Button downBox;
    protected Action addAction = null;
    protected Action toggleHighlight = null;
    protected Action openAction = null;
    protected Button showGlobal;
    protected Button showSelected;
    protected Canvas canvas;
    protected Menu menu;
    protected MenuItem openFile;
    protected MenuItem addProperty;
    protected MenuItem toggleHighlighting;
    protected SourceLocatorUtil locatorUtil;
    protected SourceDisplayUtil sourceDisplayUtil;
    protected BoxModelPaintListener boxModelPaintListener;
    private DOMDocumentListener domDocumentListener = new DOMDocumentListener(){

        public void documentUnloaded(DOMDocumentEvent event) {
            CSSPage.this.clearTree();
        }
    };
    private DOMMutationListener domMutationListener = new DOMMutationListener(){

        public void attributeAdded(nsIDOMElement ownerElement, String attributeName) {
            CSSPage.this.checkStyle(ownerElement, attributeName);
        }

        public void attributeModified(nsIDOMElement ownerElement, String attributeName, String newValue, String previousValue) {
            CSSPage.this.checkStyle(ownerElement, attributeName);
        }

        public void attributeRemoved(nsIDOMElement ownerElement, String attributeName) {
            CSSPage.this.checkStyle(ownerElement, attributeName);
        }
    };
    protected Color defaultBGColor = new Color((Device)Display.getCurrent(), new RGB(255, 255, 255));

    public void createControl(Composite parent) {
        this.cpl = new CSSPropertyLocator();
        this.locatorUtil = SourceLocatorUtil.getInstance();
        this.sourceDisplayUtil = new SourceDisplayUtil();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.top = new Composite(parent, 0);
        this.top.setLayout((Layout)layout);
        this.top.setLayoutData((Object)new GridData(4, 4, true, true));
        this.comp = new SashForm(this.top, 512);
        this.comp.setLayout((Layout)layout);
        this.comp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.tabFolder = new CTabFolder((Composite)this.comp, 128);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (CSSPage.this.currentlySelectedNode != null) {
                    if (e.item.equals(CSSPage.this.diffTab)) {
                        CSSPage.this.showDiffTab();
                    } else if (e.item.equals(CSSPage.this.computedTab)) {
                        CSSPage.this.showComputedTab();
                    } else if (e.item.equals(CSSPage.this.boxTab)) {
                        CSSPage.this.showBoxTab();
                    } else if (e.item.equals(CSSPage.this.rulesTab)) {
                        CSSPage.this.showRulesTab();
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.rulesTab = new CTabItem(this.tabFolder, 0);
        this.rulesTab.setText("Style Rules");
        this.computedTab = new CTabItem(this.tabFolder, 0);
        this.computedTab.setText("Computed Styles");
        this.boxTab = new CTabItem(this.tabFolder, 0);
        this.boxTab.setText("Box Model");
        this.diffTab = new CTabItem(this.tabFolder, 0);
        this.diffTab.setText("Diffs");
        this.ruleDisplay = new SashForm((Composite)this.tabFolder, 2048);
        this.createBoxModelTab();
        this.createComputedStylesTab();
        this.createStyleRulesTab();
        this.createDiffsTab();
        this.diffTab.setControl((Control)this.diffDisplay);
        this.computedTab.setControl((Control)this.compDisplay);
        this.boxTab.setControl((Control)this.boxDisplay);
        this.rulesTab.setControl((Control)this.ruleDisplay);
        this.tabFolder.setSelection(this.rulesTab);
        this.createActions();
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.addAction);
        toolBarManager.add((IAction)this.openAction);
        toolBarManager.add((IAction)this.toggleHighlight);
        this.provider.addSelectionChangedListener(this);
        this.getSite().setSelectionProvider((ISelectionProvider)this.provider);
    }

    private void createBoxModelTab() {
        this.boxDisplay = new SashForm((Composite)this.tabFolder, 2048);
        this.boxTree = new Tree((Composite)this.boxDisplay, 65540);
        this.boxTree.setHeaderVisible(true);
        this.boxTree.setEnabled(true);
        this.boxTree.setLinesVisible(true);
        this.boxViewer = new TreeViewer(this.boxTree);
        this.boxViewer.setContentProvider((IContentProvider)new BoxModelContentProvider());
        this.boxViewer.setLabelProvider((IBaseLabelProvider)new CSSLabelProvider((Device)this.boxTree.getDisplay()));
        this.boxViewer.setAutoExpandLevel(2);
        this.boxViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        Composite boxComp = new Composite((Composite)this.boxDisplay, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        boxComp.setLayout((Layout)layout);
        boxComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite navComp = new Composite(boxComp, 2048);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 10;
        layout.horizontalSpacing = 0;
        navComp.setLayout((Layout)layout);
        navComp.setLayoutData((Object)new GridData(4, 4, false, false));
        navComp.setBackground(this.defaultBGColor);
        Label navLabel = new Label(navComp, 0x1000000);
        navLabel.setText("Navigation Controls:");
        navLabel.setBackground(this.defaultBGColor);
        Composite boxButtons = new Composite(navComp, 0);
        boxButtons.setBackground(this.defaultBGColor);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        boxButtons.setLayout((Layout)layout);
        boxButtons.setLayoutData((Object)new GridData(2, 2, false, false));
        this.upBox = new Button(boxButtons, 4);
        this.upBox.setAlignment(128);
        this.upBox.setToolTipText("Show parent box model");
        this.upBox.setEnabled(false);
        this.upBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                nsIDOMDocumentTraversal docTraversal = (nsIDOMDocumentTraversal)CSSPage.this.currentlySelectedNode.getOwnerDocument().queryInterface("{13f236c0-47f8-11d5-b6a3-009027446e84}");
                nsIDOMTreeWalker treeWalker = docTraversal.createTreeWalker((nsIDOMNode)CSSPage.this.currentlySelectedNode.getOwnerDocument().getDocumentElement(), 1L, null, true);
                treeWalker.setCurrentNode(CSSPage.this.currentlySelectedNode);
                final nsIDOMNode n = treeWalker.parentNode();
                if (n != null) {
                    IDOMNodeSelection selection = new IDOMNodeSelection(){

                        public boolean isEmpty() {
                            return n == null;
                        }

                        public nsIDOMNode getSelectedNode() {
                            return n;
                        }
                    };
                    CSSPage.this.provider.fireSelection((ISelection)selection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        GridData boxButtonsGData = new GridData();
        boxButtonsGData.horizontalAlignment = 2;
        boxButtonsGData.horizontalSpan = 3;
        this.upBox.setLayoutData((Object)boxButtonsGData);
        this.leftBox = new Button(boxButtons, 4);
        this.leftBox.setAlignment(16384);
        this.leftBox.setToolTipText("Show previous sibling box model");
        this.leftBox.setEnabled(false);
        this.leftBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                nsIDOMDocumentTraversal docTraversal = (nsIDOMDocumentTraversal)CSSPage.this.currentlySelectedNode.getOwnerDocument().queryInterface("{13f236c0-47f8-11d5-b6a3-009027446e84}");
                nsIDOMTreeWalker treeWalker = docTraversal.createTreeWalker((nsIDOMNode)CSSPage.this.currentlySelectedNode.getOwnerDocument().getDocumentElement(), 1L, null, true);
                treeWalker.setCurrentNode(CSSPage.this.currentlySelectedNode);
                final nsIDOMNode n = treeWalker.previousSibling();
                if (n != null) {
                    IDOMNodeSelection selection = new IDOMNodeSelection(){

                        public boolean isEmpty() {
                            return n == null;
                        }

                        public nsIDOMNode getSelectedNode() {
                            return n;
                        }
                    };
                    CSSPage.this.provider.fireSelection((ISelection)selection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        boxButtonsGData = new GridData();
        boxButtonsGData.horizontalAlignment = 1;
        boxButtonsGData.horizontalSpan = 1;
        this.rightBox = new Button(boxButtons, 4);
        this.rightBox.setAlignment(131072);
        this.rightBox.setToolTipText("Show next sibling box model");
        this.rightBox.setEnabled(false);
        this.rightBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                nsIDOMDocumentTraversal docTraversal = (nsIDOMDocumentTraversal)CSSPage.this.currentlySelectedNode.getOwnerDocument().queryInterface("{13f236c0-47f8-11d5-b6a3-009027446e84}");
                nsIDOMTreeWalker treeWalker = docTraversal.createTreeWalker((nsIDOMNode)CSSPage.this.currentlySelectedNode.getOwnerDocument().getDocumentElement(), 1L, null, true);
                treeWalker.setCurrentNode(CSSPage.this.currentlySelectedNode);
                final nsIDOMNode n = treeWalker.nextSibling();
                if (n != null) {
                    IDOMNodeSelection selection = new IDOMNodeSelection(){

                        public boolean isEmpty() {
                            return n == null;
                        }

                        public nsIDOMNode getSelectedNode() {
                            return n;
                        }
                    };
                    CSSPage.this.provider.fireSelection((ISelection)selection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        boxButtonsGData = new GridData();
        boxButtonsGData.horizontalAlignment = 3;
        boxButtonsGData.horizontalSpan = 2;
        this.rightBox.setLayoutData((Object)boxButtonsGData);
        this.downBox = new Button(boxButtons, 4);
        this.downBox.setAlignment(1024);
        this.downBox.setToolTipText("Show first child box model");
        this.downBox.setEnabled(false);
        this.downBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                nsIDOMDocumentTraversal docTraversal = (nsIDOMDocumentTraversal)CSSPage.this.currentlySelectedNode.getOwnerDocument().queryInterface("{13f236c0-47f8-11d5-b6a3-009027446e84}");
                nsIDOMTreeWalker treeWalker = docTraversal.createTreeWalker((nsIDOMNode)CSSPage.this.currentlySelectedNode.getOwnerDocument().getDocumentElement(), 1L, null, true);
                treeWalker.setCurrentNode(CSSPage.this.currentlySelectedNode);
                final nsIDOMNode n = treeWalker.firstChild();
                if (n != null) {
                    IDOMNodeSelection selection = new IDOMNodeSelection(){

                        public boolean isEmpty() {
                            return n == null;
                        }

                        public nsIDOMNode getSelectedNode() {
                            return n;
                        }
                    };
                    CSSPage.this.provider.fireSelection((ISelection)selection);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        boxButtonsGData = new GridData();
        boxButtonsGData.horizontalAlignment = 2;
        boxButtonsGData.horizontalSpan = 3;
        this.downBox.setLayoutData((Object)boxButtonsGData);
        this.canvas = new Canvas(boxComp, 0x20000800);
        this.canvas.setBackground(this.defaultBGColor);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        this.canvas.setLayout((Layout)layout);
        this.canvas.setLayoutData((Object)new GridData(4, 4, true, true));
        this.boxModelPaintListener = new BoxModelPaintListener();
        this.canvas.addPaintListener((PaintListener)this.boxModelPaintListener);
        this.canvas.redraw();
        this.boxModelPaintListener.setCanvas(this.canvas);
        TreeColumn column = new TreeColumn(this.boxTree, 16384);
        column.setText(CSSLabelProvider.COLUMNS[0]);
        column.setWidth(150);
        column.setResizable(true);
        column = new TreeColumn(this.boxTree, 16384);
        column.setText(CSSLabelProvider.COLUMNS[1]);
        column.setWidth(150);
        column.setResizable(true);
        column.addSelectionListener((SelectionListener)this);
        column = new TreeColumn(this.boxTree, 16384);
        column.setText(CSSLabelProvider.COLUMNS[2]);
        column.setWidth(150);
        column.setResizable(true);
    }

    private void createComputedStylesTab() {
        this.compDisplay = new SashForm((Composite)this.tabFolder, 2048);
        this.compTree = new Tree((Composite)this.compDisplay, 65540);
        this.compTree.setHeaderVisible(true);
        this.compTree.setEnabled(true);
        this.compTree.setLinesVisible(true);
        this.compViewer = new TreeViewer(this.compTree);
        this.compViewer.setContentProvider((IContentProvider)new ComputedStylesContentProvider());
        this.compViewer.setLabelProvider((IBaseLabelProvider)new CSSLabelProvider((Device)this.compTree.getDisplay()));
        this.compViewer.setAutoExpandLevel(2);
        this.compViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        TreeColumn column = new TreeColumn(this.compTree, 16384);
        column.setText(CSSLabelProvider.COLUMNS[0]);
        column.setWidth(150);
        column.setResizable(true);
        column = new TreeColumn(this.compTree, 16384);
        column.setText(CSSLabelProvider.COLUMNS[1]);
        column.setWidth(150);
        column.setResizable(true);
        column.addSelectionListener((SelectionListener)this);
        column = new TreeColumn(this.compTree, 16384);
        column.setText(CSSLabelProvider.COLUMNS[2]);
        column.setWidth(125);
        column.setResizable(true);
        column = new TreeColumn(this.compTree, 16384);
        column.setText(CSSLabelProvider.COLUMNS[3]);
        column.setWidth(275);
        column.setResizable(true);
        column = new TreeColumn(this.compTree, 16384);
        column.setText(CSSLabelProvider.COLUMNS[4]);
        column.setWidth(75);
        column.setResizable(true);
        this.selector = new ColorSelector((Composite)this.tabFolder);
    }

    private void createStyleRulesTab() {
        this.ruleTree = new Tree((Composite)this.ruleDisplay, 65540);
        this.ruleTree.setHeaderVisible(true);
        this.ruleTree.setEnabled(true);
        this.ruleTree.setLinesVisible(true);
        TreeColumn tc = new TreeColumn(this.ruleTree, 16384);
        tc.setText(CSSLabelProvider.COLUMNS[0]);
        tc.setWidth(150);
        tc.setResizable(true);
        tc = new TreeColumn(this.ruleTree, 16384);
        tc.setText(CSSLabelProvider.COLUMNS[1]);
        tc.setWidth(150);
        tc.setResizable(true);
        tc.addSelectionListener((SelectionListener)this);
        TreeColumn valueColumn = new TreeColumn(this.ruleTree, 16384);
        valueColumn.setText(CSSLabelProvider.COLUMNS[2]);
        valueColumn.setWidth(125);
        valueColumn.setResizable(true);
        tc = new TreeColumn(this.ruleTree, 16384);
        tc.setText(CSSLabelProvider.COLUMNS[3]);
        tc.setWidth(275);
        tc.setResizable(true);
        tc = new TreeColumn(this.ruleTree, 16384);
        tc.setText(CSSLabelProvider.COLUMNS[4]);
        tc.setWidth(75);
        tc.setResizable(true);
        this.ruleViewer = new TreeViewer(this.ruleTree);
        this.ruleViewerContentProvider = new StyleRulesContentProvider();
        this.ruleViewer.setContentProvider((IContentProvider)this.ruleViewerContentProvider);
        CSSLabelProvider labelProvider = new CSSLabelProvider((Device)this.ruleViewer.getControl().getDisplay());
        this.ruleViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.ruleViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.ruleViewer.setAutoExpandLevel(2);
        TreeViewerColumn tvc = new TreeViewerColumn(this.ruleViewer, valueColumn);
        tvc.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((CSSProperty)element).getValue();
            }
        });
        tvc.setEditingSupport((EditingSupport)new CSSPropertyEditingSupport(this.ruleViewer, this.ruleViewerContentProvider));
        String[] stringArray = new String[5];
        stringArray[2] = "value";
        this.ruleViewer.setColumnProperties(stringArray);
        this.menu = new Menu(this.ruleViewer.getControl());
        this.menu.setEnabled(true);
        this.openFile = new MenuItem(this.menu, 8);
        this.openFile.setText("Open CSS file");
        this.openFile.setEnabled(false);
        this.openFile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CSSPage.this.openInFile();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.openFile.setImage(MozIDEUIPlugin.getDefault().getImage("OPENFILE_ID"));
        this.addProperty = new MenuItem(this.menu, 8);
        this.addProperty.setText("Add property");
        this.addProperty.setEnabled(false);
        this.addProperty.setImage(MozIDEUIPlugin.getDefault().getImage("ADDPROPERTY_ID"));
        this.addProperty.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSSPage.this.addProperty();
            }
        });
        this.toggleHighlighting = new MenuItem(this.menu, 8);
        this.toggleHighlighting.setText("Toggle highlighting");
        this.toggleHighlighting.setEnabled(false);
        this.toggleHighlighting.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CSSPage.this.toggleHighlight();
                CSSPage.this.toggleHighlight.setChecked(!CSSPage.this.toggleHighlight.isChecked());
            }
        });
        this.toggleHighlighting.setImage(MozIDEUIPlugin.getDefault().getImage("HIGHLIGHT_ID"));
        this.ruleViewer.getControl().setMenu(this.menu);
    }

    private void createDiffsTab() {
        this.diffDisplay = new SashForm((Composite)this.tabFolder, 2048);
        this.diffDisplay.setLayout((Layout)new GridLayout(1, true));
        this.diffDisplay.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite diffComp = new Composite((Composite)this.diffDisplay, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        diffComp.setLayout((Layout)layout);
        diffComp.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite radios = new Composite(diffComp, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        radios.setLayout((Layout)layout);
        radios.setLayoutData((Object)new GridData(4, 4, false, false));
        this.showSelected = new Button(radios, 16);
        this.showSelected.setText("Show selection CSS diff");
        this.showSelected.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CSSPage.this.showSelectedDiff();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showSelected.setSelection(true);
        this.showGlobal = new Button(radios, 16);
        this.showGlobal.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CSSPage.this.showGlobalDiff();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.showGlobal.setText("Show global CSS diff");
        this.diffs = new SashForm(diffComp, 256);
        this.diffs.setLayoutData((Object)new GridData(4, 4, true, true));
        this.originalDoc = new Document();
        this.originalViewer = new SourceViewer((Composite)this.diffs, (IVerticalRuler)new VerticalRuler(1), 2816);
        this.originalViewer.configure((SourceViewerConfiguration)new CSSViewerConfiguration());
        this.originalViewer.setEditable(false);
        this.originalViewer.setDocument((IDocument)this.originalDoc);
        this.modifiedDoc = new Document();
        this.modifiedViewer = new SourceViewer((Composite)this.diffs, (IVerticalRuler)new VerticalRuler(1), 2816);
        this.modifiedViewer.configure((SourceViewerConfiguration)new CSSViewerConfiguration());
        this.modifiedViewer.setEditable(false);
        this.modifiedViewer.setDocument((IDocument)this.modifiedDoc);
        this.diffs.setVisible(true);
    }

    private void showRulesTab() {
        nsIDOMDocument oldDoc;
        nsIDOMDocument document = this.documentContainer.getDocument();
        if (document.equals(oldDoc = this.cpl.getDocument())) {
            this.shouldIndex = false;
        }
        this.cpl.setNode(this.currentlySelectedNode);
        this.cpl.setDocumentContainer(this.documentContainer);
        if (this.shouldIndex) {
            this.canHighlight = false;
            this.cpl.load(new IJobChangeListener(){

                public void sleeping(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void running(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    CSSPage.this.canHighlight = true;
                }

                public void awake(IJobChangeEvent event) {
                }

                public void aboutToRun(IJobChangeEvent event) {
                }
            });
            this.shouldIndex = false;
        }
        this.ruleViewer.setInput((Object)this.currentlySelectedNode);
        if (this.ruleTree.getItemCount() > 0) {
            this.ruleTree.showItem(this.ruleTree.getItem(0));
            this.ruleTree.showColumn(this.ruleTree.getColumn(0));
        }
        this.ruleDisplay.setMaximizedControl((Control)this.ruleTree);
    }

    private void showBoxTab() {
        this.boxViewer.setInput((Object)this.currentlySelectedNode);
        this.boxModelPaintListener.setNode(this.currentlySelectedNode);
        this.canvas.redraw();
        this.canvas.setVisible(true);
        nsIDOMDocumentTraversal docTraversal = (nsIDOMDocumentTraversal)this.currentlySelectedNode.getOwnerDocument().queryInterface("{13f236c0-47f8-11d5-b6a3-009027446e84}");
        nsIDOMTreeWalker treeWalker = docTraversal.createTreeWalker((nsIDOMNode)this.currentlySelectedNode.getOwnerDocument().getDocumentElement(), 1L, null, true);
        treeWalker.setCurrentNode(this.currentlySelectedNode);
        this.upBox.setEnabled(treeWalker.parentNode() != null);
        treeWalker.setCurrentNode(this.currentlySelectedNode);
        this.rightBox.setEnabled(treeWalker.nextSibling() != null);
        treeWalker.setCurrentNode(this.currentlySelectedNode);
        this.leftBox.setEnabled(treeWalker.previousSibling() != null);
        treeWalker.setCurrentNode(this.currentlySelectedNode);
        this.downBox.setEnabled(treeWalker.firstChild() != null);
        this.toggleAction(false);
    }

    private void showDiffTab() {
        this.ruleViewer.setInput((Object)this.currentlySelectedNode);
        if (this.showGlobal.getSelection()) {
            this.showGlobalDiff();
        } else {
            this.showSelectedDiff();
        }
        this.toggleAction(false);
    }

    private void toggleAction(boolean state) {
        this.toggleHighlight.setEnabled(state);
        this.openAction.setEnabled(state);
        this.addAction.setEnabled(state);
    }

    private void showComputedTab() {
        this.compViewer.setInput((Object)this.currentlySelectedNode);
        if (this.compTree.getItemCount() > 0) {
            this.compTree.showItem(this.compTree.getItem(0));
            this.compTree.showColumn(this.compTree.getColumn(0));
        }
        this.toggleAction(false);
    }

    private void openInFile() {
        try {
            CSSProperty property = (CSSProperty)((TreeSelection)this.ruleViewer.getSelection()).getFirstElement();
            IStorage source = this.locatorUtil.getSourceElement(new URL(property.getURL()));
            if (source != null) {
                this.sourceDisplayUtil.openInEditor(this.sourceDisplayUtil.getEditorInput(source), Integer.parseInt(property.getLineNumber()));
            }
        }
        catch (MalformedURLException e) {
            MozIDEUIPlugin.log(e);
        }
        catch (PartInitException e) {
            MozIDEUIPlugin.log(e);
        }
    }

    private void toggleHighlight() {
        this.cpl.match((CSSProperty)((TreeSelection)this.ruleViewer.getSelection()).getFirstElement());
    }

    private void createActions() {
        this.toggleHighlight = new Action("", 2){

            public void run() {
                CSSPage.this.toggleHighlight();
            }
        };
        this.toggleHighlight.setToolTipText("Toggle highlighting");
        this.toggleHighlight.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("HIGHLIGHT_ID"));
        this.toggleHighlight.setEnabled(false);
        this.addAction = new Action(){

            public void run() {
                CSSPage.this.addProperty();
            }
        };
        this.addAction.setToolTipText("Add property");
        this.addAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("ADDPROPERTY_ID"));
        this.addAction.setEnabled(false);
        this.openAction = new Action(){

            public void run() {
                CSSPage.this.openInFile();
            }
        };
        this.openAction.setToolTipText("Open CSS file");
        this.openAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("OPENFILE_ID"));
        this.openAction.setEnabled(false);
    }

    private void showGlobalDiff() {
        ((StyleRulesContentProvider)this.ruleViewer.getContentProvider()).generateGlobalDiff();
        this.showDiff();
    }

    private void showSelectedDiff() {
        ((StyleRulesContentProvider)this.ruleViewer.getContentProvider()).generateSelectionDiff();
        this.showDiff();
    }

    private void showDiff() {
        this.originalDoc.set(((StyleRulesContentProvider)this.ruleViewer.getContentProvider()).getOriginal());
        this.originalViewer.setDocument((IDocument)this.originalDoc);
        this.modifiedDoc.set(((StyleRulesContentProvider)this.ruleViewer.getContentProvider()).getModified());
        this.modifiedViewer.setDocument((IDocument)this.modifiedDoc);
    }

    public Control getControl() {
        return this.top;
    }

    public void setFocus() {
    }

    public void setWebBrowser(IWebBrowser documentContainer) {
        Assert.isTrue((this.documentContainer == null ? 1 : 0) != 0, (String)"CSSPage already initialized, cannot call setDOMDocumentContainer() more than once.");
        this.documentContainer = documentContainer;
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().addEventListener(documentContainer, (IApplicationEventListener)this.domDocumentListener);
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().addEventListener(documentContainer, (IApplicationEventListener)this.domMutationListener);
    }

    public void dispose() {
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().removeEventListener(this.documentContainer, (IApplicationEventListener)this.domDocumentListener);
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().removeEventListener(this.documentContainer, (IApplicationEventListener)this.domMutationListener);
        this.defaultBGColor.dispose();
        this.boxModelPaintListener.dispose();
        this.cpl.disable();
        this.cpl.dispose();
        super.dispose();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IDOMNodeSelection) {
            this.cpl.disable();
            if (selection.isEmpty()) {
                this.clearTree();
            } else if (this.currentlySelectedNode == null) {
                this.displayStyle(((IDOMNodeSelection)selection).getSelectedNode());
            } else if (!((IDOMNodeSelection)selection).getSelectedNode().equals(this.currentlySelectedNode)) {
                this.displayStyle(((IDOMNodeSelection)selection).getSelectedNode());
            }
        }
    }

    private void displayStyle(nsIDOMNode selectedNode) {
        if (selectedNode != null) {
            this.currentlySelectedNode = selectedNode;
            this.shouldIndex = true;
            if (selectedNode.getNodeType() == 1) {
                if (this.tabFolder.getSelection().equals(this.rulesTab)) {
                    this.showRulesTab();
                } else if (this.tabFolder.getSelection().equals(this.boxTab)) {
                    this.showBoxTab();
                } else if (this.tabFolder.getSelection().equals(this.computedTab)) {
                    this.showComputedTab();
                } else if (this.tabFolder.getSelection().equals(this.diffTab)) {
                    this.showDiffTab();
                }
            } else {
                this.clearTree();
            }
        }
    }

    private void clearCanvas() {
        this.canvas.setVisible(false);
        this.upBox.setEnabled(false);
        this.rightBox.setEnabled(false);
        this.leftBox.setEnabled(false);
        this.downBox.setEnabled(false);
    }

    public void clearTree() {
        this.clearCanvas();
        this.ruleTree.clearAll(true);
        this.ruleViewer.setInput(null);
        this.compTree.clearAll(true);
        this.compViewer.setInput(null);
        this.boxTree.clearAll(true);
        this.boxViewer.setInput(null);
        this.currentlySelectedNode = null;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        Object selection = ((TreeSelection)this.ruleViewer.getSelection()).getFirstElement();
        if (selection != null && selection instanceof CSSProperty) {
            CSSProperty property = (CSSProperty)selection;
            if (e.getSource().equals("delete")) {
                ((StyleRulesContentProvider)this.ruleViewer.getContentProvider()).deleteProperty(property);
            }
        }
    }

    private void addProperty() {
        InputDialog nameDialog;
        Object selection = ((TreeSelection)this.ruleViewer.getSelection()).getFirstElement();
        CSSProperty property = null;
        if (selection != null && selection instanceof CSSProperty) {
            property = (CSSProperty)selection;
        }
        if ((nameDialog = new InputDialog(this.getControl().getShell(), "Add Property", "Type property name and value separated by colon", "name: value", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.indexOf(58) == -1) {
                    return "Use \"name : value\" format.";
                }
                int colon = newText.indexOf(58);
                String name = newText.substring(0, colon).trim();
                if (name.length() == 0 || !CSSPage.this.ruleViewerContentProvider.isPropertyName(name)) {
                    return "Unknown property name \"" + name + "\"";
                }
                String value = newText.substring(colon + 1).trim();
                if (value.length() == 0) {
                    return "Value cannot be empty";
                }
                return null;
            }
        })).open() != 0) {
            return;
        }
        String val = nameDialog.getValue();
        int colon = val.indexOf(58);
        String name = val.substring(0, colon).trim();
        String value = val.substring(colon + 1);
        CSSProperty newProperty = new CSSProperty(name, value, property.getURL(), property.getLineNumber(), property.getRule());
        newProperty.setNewRule(true);
        newProperty.setInline(property.isInline());
        this.ruleViewerContentProvider.updateProperty(newProperty);
        this.ruleViewer.refresh();
        this.showRulesTab();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!event.getSelection().isEmpty() && event.getSource().equals(this.ruleViewer)) {
            CSSProperty property = (CSSProperty)((TreeSelection)this.ruleViewer.getSelection()).getFirstElement();
            if (!CSSPage.isInternal(property.getURL())) {
                if (property.isRule()) {
                    this.addProperty.setEnabled(true);
                    this.toggleHighlight.setChecked(false);
                    this.addAction.setEnabled(true);
                }
                this.openFile.setEnabled(!property.isInline());
                this.openAction.setEnabled(!property.isInline());
            } else {
                this.openFile.setEnabled(false);
                this.openAction.setEnabled(false);
                this.addAction.setEnabled(false);
                this.addProperty.setEnabled(false);
            }
            this.toggleHighlighting.setEnabled(this.canHighlight || property.isInline());
            this.toggleHighlight.setEnabled(this.canHighlight || property.isInline());
            this.toggleHighlight.setChecked(false);
            this.cpl.disable();
            this.ruleDisplay.setMaximizedControl((Control)this.ruleTree);
        } else {
            this.addAction.setEnabled(false);
            this.addProperty.setEnabled(false);
            this.openAction.setEnabled(false);
            this.openFile.setEnabled(false);
            this.toggleHighlight.setEnabled(false);
            this.toggleHighlight.setChecked(false);
            this.toggleHighlighting.setEnabled(false);
            this.cpl.disable();
        }
        if (!event.getSelection().isEmpty() && event.getSource().equals(this.compViewer)) {
            this.cpl.disable();
        }
        if (!event.getSelection().isEmpty() && event.getSelection() instanceof IDOMNodeSelection) {
            this.displayStyle(((IDOMNodeSelection)event.getSelection()).getSelectedNode());
        }
    }

    private static boolean isInternal(String url) {
        return url.startsWith("resource") || url.startsWith("about:");
    }

    private void checkStyle(nsIDOMElement element, String name) {
        if (this.currentlySelectedNode != null && element.equals(this.currentlySelectedNode) && name.equals("style")) {
            this.displayStyle((nsIDOMNode)element);
        }
    }
}

