/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.css;

import java.util.Arrays;
import org.eclipse.atf.mozilla.ide.ui.css.CSSConstants;
import org.eclipse.swt.graphics.RGB;

public class CSSProperty
implements Comparable {
    private String name;
    private String value;
    private String lineNumber;
    private String url;
    private boolean isColor;
    private String rule;
    private RGB rgbValue;
    private boolean present;
    private boolean computed;
    private boolean newRule;
    private boolean inline;
    private String originalName;
    private String originalValue;
    private boolean isProperty;

    public CSSProperty(String name, String value, String url, String lineNumber, String rule) {
        this.name = name;
        this.value = value;
        this.url = url;
        this.lineNumber = lineNumber;
        this.rule = rule;
        this.originalName = name;
        this.originalValue = value;
        this.isColor = name.indexOf("color") != -1;
        this.present = false;
        this.computed = false;
        this.newRule = false;
        this.isProperty = false;
    }

    public boolean isNewRule() {
        return this.newRule;
    }

    public void setNewRule(boolean newRule) {
        this.newRule = newRule;
    }

    public void setComputed(boolean computed) {
        this.computed = computed;
    }

    public boolean isComputed() {
        return this.computed;
    }

    public String getRule() {
        return this.rule;
    }

    public RGB getRGBValue() {
        if (!this.isColor()) {
            return null;
        }
        if (this.rgbValue == null) {
            this.rgbValue = CSSProperty.parseRGB(this.value);
        }
        return this.rgbValue;
    }

    public static RGB parseRGB(String rgb) {
        char[] trimmed = new char[rgb.length()];
        int trimmedLen = 0;
        int i = 0;
        while (i < rgb.length()) {
            char c = rgb.charAt(i);
            if (c != ' ' && c != '\t' && c != '\n') {
                trimmed[trimmedLen++] = c;
            }
            ++i;
        }
        rgb = new String(trimmed, 0, trimmedLen);
        if (rgb.startsWith("rgb")) {
            int commaAfterRed = rgb.indexOf(44);
            int commaAfterGreen = rgb.indexOf(44, commaAfterRed + 1);
            String color = rgb.substring(4, commaAfterRed);
            int red = color.charAt(0) == '%' ? Integer.parseInt(color.substring(1)) * 255 / 100 : Integer.parseInt(color);
            color = rgb.substring(commaAfterRed + 1, commaAfterGreen);
            int green = color.charAt(0) == '%' ? Integer.parseInt(color.substring(1)) * 255 / 100 : Integer.parseInt(color);
            color = rgb.substring(commaAfterGreen + 1, rgb.length() - 1);
            int blue = color.charAt(0) == '%' ? Integer.parseInt(color.substring(1)) * 255 / 100 : Integer.parseInt(color);
            return new RGB(red, green, blue);
        }
        if (rgb.startsWith("#")) {
            int green;
            int red;
            if (rgb.length() == 7) {
                red = Integer.parseInt(rgb.substring(1, 3), 16);
                green = Integer.parseInt(rgb.substring(3, 5), 16);
                int blue = Integer.parseInt(rgb.substring(5, 7), 16);
                return new RGB(red, green, blue);
            }
            if (rgb.length() == 4) {
                red = Integer.parseInt(String.valueOf(rgb.substring(1, 2)) + rgb.substring(1, 2), 16);
                green = Integer.parseInt(String.valueOf(rgb.substring(2, 3)) + rgb.substring(2, 3), 16);
                int blue = Integer.parseInt(String.valueOf(rgb.substring(3, 4)) + rgb.substring(3, 4), 16);
                return new RGB(red, green, blue);
            }
        } else {
            i = Arrays.asList(CSSConstants.COLORS).indexOf(rgb);
            if (i != -1) {
                return CSSConstants.COLOR_VALUES[i];
            }
        }
        return null;
    }

    public void setRGBValue(RGB value) {
        if (!this.isColor()) {
            throw new IllegalArgumentException();
        }
        this.rgbValue = new RGB(value.red, value.green, value.blue);
        this.value = "rgb(" + value.red + "," + value.green + "," + value.blue + ")";
    }

    public void setValue(String value) {
        this.value = value;
        if (this.rgbValue != null) {
            this.rgbValue = null;
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setLineNumber(String number) {
        this.lineNumber = number;
    }

    public boolean isColor() {
        return this.isColor;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getLineNumber() {
        return this.lineNumber;
    }

    public String getURL() {
        return this.url == null ? "" : this.url;
    }

    public String getHash() {
        return String.valueOf(this.getRule()) + ":" + this.getURL() + ":" + this.getLineNumber();
    }

    public boolean isPresent() {
        return this.present;
    }

    public void setPresent(boolean present) {
        this.present = present;
    }

    public int compareTo(Object o) {
        return this.getHash().compareTo(((CSSProperty)o).getHash());
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public void setProperty(boolean isProperty) {
        this.isProperty = isProperty;
    }

    public boolean isProperty() {
        return this.isProperty;
    }

    public boolean isRule() {
        return !this.isProperty;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean isInline) {
        this.inline = isInline;
    }
}

