/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.domwatcher;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.common.IDOMNodeSelection;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentEvent;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentListener;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.views.IBrowserView;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.CComboViewer;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.DOMEventContentProvider;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.DOMEventLabelProvider;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.IDOMEventWatcherListener;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.IDOMWatcherPage;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.Watcher;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.model.IDOMEvent;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.settings.DOMWatcherSettings;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.settings.IDOMEventSetting;
import org.eclipse.atf.mozilla.ide.ui.util.DOMNodeUtils;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.part.Page;
import org.mozilla.interfaces.nsIDOMNode;

public class DOMWatcherPage
extends Page
implements IDOMWatcherPage,
IBrowserView,
ISelectionListener,
IDOMEventWatcherListener {
    private IWebBrowser documentContainer = null;
    protected Map nodesToWatchers = new HashMap();
    private DOMDocumentListener domDocumentListener = new DOMDocumentListener(){

        public void documentUnloaded(DOMDocumentEvent event) {
            for (Watcher w : DOMWatcherPage.this.nodesToWatchers.values()) {
                w.disconnect();
                if (DOMWatcherPage.this.watchedNodesViewer.getControl().isDisposed()) continue;
                DOMWatcherPage.this.watchedNodesViewer.refresh(w);
            }
            DOMWatcherPage.this.selectedNode = null;
            if (!DOMWatcherPage.this.eventViewer.getControl().isDisposed()) {
                DOMWatcherPage.this.updateUI();
            }
        }
    };
    protected nsIDOMNode selectedNode = null;
    protected Action startWatchAction = null;
    protected Action stopWatchAction = null;
    protected Action clearEventsAction = null;
    protected Action openSettingsActions = null;
    protected Composite contentArea = null;
    protected CComboViewer watchedNodesViewer = null;
    protected TableViewer eventViewer = null;
    protected Color white = new Color((Device)Display.getCurrent(), new RGB(255, 255, 255));

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        GridData gridData = new GridData(4, 4, true, true);
        this.contentArea = new Composite(parent, 0);
        this.contentArea.setLayoutData((Object)gridData);
        this.contentArea.setLayout((Layout)layout);
        Label watchedNodeLabel = new Label(this.contentArea, 0);
        watchedNodeLabel.setText("Node:");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        watchedNodeLabel.setLayoutData((Object)gridData);
        CCombo combo = new CCombo(this.contentArea, 0);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        combo.setLayoutData((Object)gridData);
        this.watchedNodesViewer = new CComboViewer(combo);
        this.watchedNodesViewer.getCCombo().setEditable(false);
        this.watchedNodesViewer.getCCombo().setBackground(this.white);
        this.watchedNodesViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return DOMWatcherPage.this.nodesToWatchers.values().toArray();
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.watchedNodesViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Watcher watcher = (Watcher)element;
                return watcher.toString();
            }
        });
        this.watchedNodesViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (sel.isEmpty()) {
                    return;
                }
                Watcher w = (Watcher)sel.getFirstElement();
                nsIDOMNode node = w.getWatchedNode();
                if (!node.equals(DOMWatcherPage.this.selectedNode)) {
                    if (DOMWatcherPage.this.selectedNode != null && DOMWatcherPage.this.nodesToWatchers.containsKey(DOMWatcherPage.this.selectedNode)) {
                        Watcher currentWatcher = (Watcher)DOMWatcherPage.this.nodesToWatchers.get(DOMWatcherPage.this.selectedNode);
                        currentWatcher.removeListener(DOMWatcherPage.this);
                    }
                    DOMWatcherPage.this.selectedNode = node;
                    DOMWatcherPage.this.updateUI();
                }
            }
        });
        this.watchedNodesViewer.setInput(this);
        this.eventViewer = new TableViewer(this.contentArea, 66308);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.eventViewer.getControl().setLayoutData((Object)gridData);
        this.styleTable(this.eventViewer.getTable());
        this.createColumns(this.eventViewer.getTable());
        this.eventViewer.setLabelProvider((IBaseLabelProvider)new DOMEventLabelProvider());
        this.eventViewer.setContentProvider((IContentProvider)new DOMEventContentProvider());
        this.createActions();
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.startWatchAction);
        toolBarManager.add((IAction)this.stopWatchAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.clearEventsAction);
        IMenuManager menuManager = this.getSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.openSettingsActions);
        this.updateUI();
    }

    protected void styleTable(Table table) {
        table.setLinesVisible(true);
        table.setFont(table.getParent().getFont());
    }

    protected void createColumns(Table table) {
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setText("Type");
        tc.setMoveable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        tc = new TableColumn(table, 0, 1);
        tc.setText("TimeStamp");
        tc.setMoveable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, true));
        tc = new TableColumn(table, 0, 2);
        tc.setText("Details");
        tc.setMoveable(true);
    }

    protected void createActions() {
        this.startWatchAction = new Action("Start", 1){

            public void run() {
                DOMWatcherPage.this.startWatch();
            }
        };
        this.startWatchAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("E_STARTWATCHER_ID"));
        this.startWatchAction.setDisabledImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("D_STARTWATCHER_ID"));
        this.startWatchAction.setToolTipText("Start watching events for this node.");
        this.stopWatchAction = new Action("Stop", 1){

            public void run() {
                DOMWatcherPage.this.stopWatch();
            }
        };
        this.stopWatchAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("E_STOPWATCHER_ID"));
        this.stopWatchAction.setDisabledImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("D_STOPWATCHER_ID"));
        this.stopWatchAction.setToolTipText("Stop watching events for this node.");
        this.clearEventsAction = new Action("Clear", 1){

            public void run() {
                DOMWatcherPage.this.clear();
            }
        };
        this.clearEventsAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("CLEAR_IMG_ID"));
        this.clearEventsAction.setToolTipText("Clear event list.");
        this.openSettingsActions = new Action("Settings...", 1){

            public void run() {
                ListSelectionDialog dialog = new ListSelectionDialog(DOMWatcherPage.this.getSite().getShell(), (Object)DOMWatcherSettings.getInstance(), new IStructuredContentProvider(){

                    public Object[] getElements(Object inputElement) {
                        DOMWatcherSettings settings = (DOMWatcherSettings)inputElement;
                        return settings.getSettings();
                    }

                    public void dispose() {
                    }

                    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                    }
                }, (ILabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        IDOMEventSetting setting = (IDOMEventSetting)element;
                        return setting.getEventType();
                    }
                }, "Select event types to watch.");
                ArrayList<IDOMEventSetting> shouldWatchSettings = new ArrayList<IDOMEventSetting>();
                IDOMEventSetting[] allSettings = DOMWatcherSettings.getInstance().getSettings();
                int i = 0;
                while (i < allSettings.length) {
                    if (allSettings[i].shouldWatch()) {
                        shouldWatchSettings.add(allSettings[i]);
                    }
                    ++i;
                }
                dialog.setInitialElementSelections(shouldWatchSettings);
                dialog.setTitle("Supported DOM Event types");
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    Object[] selectedSettings = dialog.getResult();
                    int i2 = 0;
                    while (i2 < selectedSettings.length) {
                        ((IDOMEventSetting)selectedSettings[i2]).setShouldWatch(true);
                        if (shouldWatchSettings.contains(selectedSettings[i2])) {
                            shouldWatchSettings.remove(selectedSettings[i2]);
                        } else {
                            ((IDOMEventSetting)selectedSettings[i2]).setShouldWatch(true);
                        }
                        ++i2;
                    }
                    for (IDOMEventSetting settingToUncheck : shouldWatchSettings) {
                        settingToUncheck.setShouldWatch(false);
                    }
                }
            }
        };
        this.openSettingsActions.setToolTipText("Select event types to watch.");
    }

    protected void updateUI() {
        if (this.selectedNode == null) {
            this.startWatchAction.setEnabled(false);
            this.stopWatchAction.setEnabled(false);
            this.eventViewer.setInput(null);
            this.watchedNodesViewer.setSelection((ISelection)StructuredSelection.EMPTY);
            this.watchedNodesViewer.getCCombo().setText("");
        } else if (this.nodesToWatchers.containsKey(this.selectedNode)) {
            Watcher w = (Watcher)this.nodesToWatchers.get(this.selectedNode);
            if (!w.isDisconnected()) {
                w.addListener(this);
            }
            this.startWatchAction.setEnabled(!w.isDisconnected() && !w.isWatching());
            this.stopWatchAction.setEnabled(!w.isDisconnected() && w.isWatching());
            this.eventViewer.setInput((Object)w);
            this.watchedNodesViewer.setSelection((ISelection)new StructuredSelection(new Object[]{w}), true);
        } else {
            this.startWatchAction.setEnabled(true);
            this.stopWatchAction.setEnabled(false);
            this.eventViewer.setInput(null);
            this.watchedNodesViewer.getCCombo().setText(DOMNodeUtils.nodeToString(this.selectedNode));
        }
    }

    public void dispose() {
        this.white.dispose();
        super.dispose();
    }

    protected void startWatch() {
        if (this.nodesToWatchers.containsKey(this.selectedNode)) {
            Watcher w = (Watcher)this.nodesToWatchers.get(this.selectedNode);
            w.start();
            this.startWatchAction.setEnabled(false);
            this.stopWatchAction.setEnabled(true);
        } else {
            Watcher w = new Watcher(this.selectedNode);
            this.nodesToWatchers.put(this.selectedNode, w);
            this.watchedNodesViewer.add(w);
            this.watchedNodesViewer.setSelection((ISelection)new StructuredSelection(new Object[]{w}), true);
            w.addListener(this);
            this.eventViewer.setInput((Object)w);
            w.start();
            this.startWatchAction.setEnabled(false);
            this.stopWatchAction.setEnabled(true);
        }
    }

    protected void stopWatch() {
        Watcher w = (Watcher)this.nodesToWatchers.get(this.selectedNode);
        w.stop();
        this.startWatchAction.setEnabled(true);
        this.stopWatchAction.setEnabled(false);
    }

    protected void clear() {
        if (this.nodesToWatchers.containsKey(this.selectedNode)) {
            Watcher w = (Watcher)this.nodesToWatchers.get(this.selectedNode);
            w.clear();
            this.eventViewer.refresh();
        }
    }

    public Control getControl() {
        return this.contentArea;
    }

    public void setFocus() {
    }

    public void newEvent(IDOMEvent event) {
        if (!this.eventViewer.getControl().isDisposed()) {
            this.eventViewer.add((Object)event);
            this.eventViewer.reveal((Object)event);
        }
    }

    public void setWebBrowser(IWebBrowser documentContainer) {
        if (this.documentContainer != null) {
            throw new AssertionFailedException("DOMWatcherPage already initialized, cannot call setDOMDocumentContainer() more than once.");
        }
        this.documentContainer = documentContainer;
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().addEventListener(documentContainer, (IApplicationEventListener)this.domDocumentListener);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IDOMNodeSelection) {
            if (this.selectedNode != null && this.nodesToWatchers.containsKey(this.selectedNode)) {
                Watcher w = (Watcher)this.nodesToWatchers.get(this.selectedNode);
                w.removeListener(this);
            }
            this.selectedNode = ((IDOMNodeSelection)selection).getSelectedNode();
            this.updateUI();
        }
    }
}

