/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.domwatcher.settings;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.model.IDOMEventDetailProvider;
import org.eclipse.atf.mozilla.ide.ui.domwatcher.settings.IDOMEventSetting;
import org.eclipse.jface.preference.IPreferenceStore;
import org.mozilla.interfaces.nsIDOMEvent;

public class PreferencePersistedDOMEventSetting
implements IDOMEventSetting {
    protected static final String DOMWATCHER_SETTING_PREFIX = "DOMWATCHER_SETTING.";
    protected String eventType;
    protected IDOMEventDetailProvider detailProvider = new IDOMEventDetailProvider(){

        public String getDetail(nsIDOMEvent event) {
            return "";
        }
    };

    public PreferencePersistedDOMEventSetting(String eventType) {
        this(eventType, null, true);
    }

    public PreferencePersistedDOMEventSetting(String eventType, IDOMEventDetailProvider detailProvider) {
        this(eventType, detailProvider, true);
    }

    public PreferencePersistedDOMEventSetting(String eventType, IDOMEventDetailProvider detailProvider, boolean shouldWatch) {
        this.eventType = eventType;
        if (detailProvider != null) {
            this.detailProvider = detailProvider;
        }
        IPreferenceStore store = MozIDEUIPlugin.getDefault().getPreferenceStore();
        store.setDefault(DOMWATCHER_SETTING_PREFIX + eventType, shouldWatch);
    }

    public IDOMEventDetailProvider getDetailProvider() {
        return this.detailProvider;
    }

    public String getEventType() {
        return this.eventType;
    }

    public boolean shouldWatch() {
        IPreferenceStore store = MozIDEUIPlugin.getDefault().getPreferenceStore();
        return store.getBoolean(DOMWATCHER_SETTING_PREFIX + this.eventType);
    }

    public void setShouldWatch(boolean shouldWatch) {
        IPreferenceStore store = MozIDEUIPlugin.getDefault().getPreferenceStore();
        store.setValue(DOMWATCHER_SETTING_PREFIX + this.eventType, shouldWatch);
    }
}

