/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.inspector.properties;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.inspector.properties.IDOMInspectorProperty;
import org.mozilla.interfaces.nsIDOMClientRect;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNSElement;
import org.mozilla.interfaces.nsIDOMNode;

public class BoxModelProperty
implements IDOMInspectorProperty {
    public static String X_PROP = "x";
    public static String Y_PROP = "y";
    public static String WIDTH_PROP = "width";
    public static String HEIGHT_PROP = "height";
    protected String displayName = "";
    protected String propertyName = "";

    public BoxModelProperty(String propertyName, String displayName) {
        this.propertyName = propertyName;
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getValue(nsIDOMNode node) {
        try {
            nsIDOMElement element = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            nsIDOMNSElement nselement = (nsIDOMNSElement)element.queryInterface("{c9da11bc-32d4-425e-a91f-7e0939c39251}");
            nsIDOMClientRect elementBox = nselement.getBoundingClientRect();
            if (X_PROP.equals(this.propertyName)) {
                return String.valueOf(elementBox.getTop());
            }
            if (Y_PROP.equals(this.propertyName)) {
                return String.valueOf(elementBox.getLeft());
            }
            if (WIDTH_PROP.equals(this.propertyName)) {
                return String.valueOf(elementBox.getWidth());
            }
            if (HEIGHT_PROP.equals(this.propertyName)) {
                return String.valueOf(elementBox.getHeight());
            }
            return "INVALID PROPERTY NAME!";
        }
        catch (Exception e) {
            MozIDEUIPlugin.log(e);
            return "ERROR!";
        }
    }
}

