/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.inspector.properties;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.inspector.properties.IDOMInspectorProperty;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMViewCSS;

public class ComputedStyleProperty
implements IDOMInspectorProperty {
    public String displayName = "";
    public String styleName = "";

    public ComputedStyleProperty(String styleName, String displayName) {
        this.styleName = styleName;
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getValue(nsIDOMNode node) {
        try {
            nsIDOMElement element = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocumentView documentView = (nsIDOMDocumentView)element.getOwnerDocument().queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
            nsIDOMViewCSS cssView = (nsIDOMViewCSS)documentView.getDefaultView().queryInterface("{0b9341f3-95d4-4fa4-adcd-e119e0db2889}");
            nsIDOMCSSStyleDeclaration computedStyle = cssView.getComputedStyle(element, "");
            return computedStyle.getPropertyCSSValue(this.styleName).getCssText();
        }
        catch (Exception e) {
            MozIDEUIPlugin.log((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.ui", "Failed getting computed style <" + this.styleName + "> with error<" + e.getMessage() + ">!", (Throwable)e));
            return "ERROR!";
        }
    }
}

