/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.jseval;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentEvent;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentListener;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.views.IBrowserView;
import org.eclipse.atf.mozilla.ide.ui.inspector.DOMLabelProvider;
import org.eclipse.atf.mozilla.ide.ui.jseval.Evaluator;
import org.eclipse.atf.mozilla.ide.ui.jseval.IJSEvalPage;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.EvalExpression;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.IJSValue;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSBoolean;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSError;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSNumber;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSObject;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSObjectProperty;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSString;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.NodeExpression;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.part.Page;
import org.mozilla.interfaces.nsIDOMNode;

public class JSEvalPage
extends Page
implements IJSEvalPage,
IBrowserView {
    private IWebBrowser webBrowser = null;
    protected Evaluator evaluator = new Evaluator();
    protected List expressionList = new ArrayList();
    protected Composite contentArea = null;
    protected Text evalExprText = null;
    protected TreeViewer expressionViewer = null;
    private DOMDocumentListener domDocumentListener = new DOMDocumentListener(){

        public void documentLoaded(DOMDocumentEvent event) {
            if (event.isTop()) {
                JSEvalPage.this.evaluator.init(event.getTargetDocument());
                JSEvalPage.this.evalExprText.setEnabled(true);
            }
        }

        public void documentUnloaded(DOMDocumentEvent event) {
            if (JSEvalPage.this.getControl().isDisposed()) {
                return;
            }
            JSEvalPage.this.clearAction.run();
        }
    };
    protected Action clearAction = null;
    protected Color white = new Color((Device)Display.getCurrent(), new RGB(255, 255, 255));
    protected Color blue = new Color((Device)Display.getCurrent(), new RGB(0, 0, 255));
    protected Color red = new Color((Device)Display.getCurrent(), new RGB(255, 0, 0));
    protected static final int NAME_COL_IDX = 0;
    protected static final int VALUE_COL_IDX = 1;

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        GridData gridData = new GridData(4, 4, true, true);
        this.contentArea = new Composite(parent, 0);
        this.contentArea.setLayoutData((Object)gridData);
        this.contentArea.setLayout((Layout)layout);
        Label watchedNodeLabel = new Label(this.contentArea, 0);
        watchedNodeLabel.setText("Expression:");
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.horizontalAlignment = 1;
        gridData.verticalAlignment = 2;
        watchedNodeLabel.setLayoutData((Object)gridData);
        this.evalExprText = new Text(this.contentArea, 2052);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.grabExcessHorizontalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.evalExprText.setLayoutData((Object)gridData);
        this.evalExprText.setText("");
        this.evalExprText.setEnabled(false);
        this.evalExprText.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
                if (e.character == '\r') {
                    JSEvalPage.this.evalExprText.setEnabled(false);
                    String expressionString = JSEvalPage.this.evalExprText.getText();
                    IJSValue result = JSEvalPage.this.evaluator.evaluate(expressionString);
                    JSEvalPage.this.evalExprText.setEnabled(true);
                    JSEvalPage.this.evalExprText.setText("");
                    EvalExpression evalExpr = new EvalExpression(expressionString, result);
                    JSEvalPage.this.expressionList.add(0, evalExpr);
                    JSEvalPage.this.expressionViewer.insert((Object)JSEvalPage.this.expressionList, (Object)evalExpr, 0);
                    JSEvalPage.this.expressionViewer.reveal((Object)evalExpr);
                    JSEvalPage.this.evalExprText.setFocus();
                }
            }
        });
        this.expressionViewer = new TreeViewer(this.contentArea, 68356);
        this.expressionViewer.getTree().setFont(this.contentArea.getFont());
        this.expressionViewer.getTree().setLinesVisible(true);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        this.expressionViewer.getControl().setLayoutData((Object)gridData);
        TreeColumn column = new TreeColumn(this.expressionViewer.getTree(), 16384);
        column.setResizable(false);
        column = new TreeColumn(this.expressionViewer.getTree(), 16384);
        column.setResizable(false);
        this.expressionViewer.getTree().setHeaderVisible(false);
        final Tree tree = this.expressionViewer.getTree();
        this.expressionViewer.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = JSEvalPage.this.contentArea.getClientArea();
                TreeColumn column1 = tree.getColumn(0);
                TreeColumn column2 = tree.getColumn(1);
                Point preferredSize = tree.computeSize(-1, -1);
                int width = area.width - 2 * tree.getBorderWidth();
                if (preferredSize.y > area.height + tree.getHeaderHeight()) {
                    Point vBarSize = tree.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = tree.getSize();
                if (oldSize.x > area.width) {
                    column1.setWidth(width / 3);
                    column2.setWidth(width - column1.getWidth());
                    tree.setSize(area.width, area.height);
                } else {
                    tree.setSize(area.width, area.height);
                    column1.setWidth(width / 3);
                    column2.setWidth(width - column1.getWidth());
                }
            }
        });
        this.expressionViewer.setContentProvider((IContentProvider)new EvalViewerContentProvider());
        this.expressionViewer.setLabelProvider((IBaseLabelProvider)new EvalViewerLabelProvider());
        this.expressionViewer.setSorter((ViewerSorter)new EvalViewerSorter());
        this.expressionViewer.setInput((Object)this.expressionList);
        this.createAction();
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.clearAction);
        if (this.webBrowser.getDocument() != null) {
            this.evaluator.init(this.webBrowser.getDocument());
            this.evalExprText.setEnabled(true);
        }
    }

    protected void evaluate(JSObject jsObject) {
        StringBuffer evalExpression = new StringBuffer();
        evalExpression.append(jsObject.getParentProperty().name);
        JSObject parent = jsObject.getParentProperty().parentObject;
        while (parent != null) {
            if (parent.getParentProperty() == null) break;
            evalExpression.insert(0, '.');
            evalExpression.insert(0, parent.getParentProperty().name);
            parent = parent.getParentProperty().parentObject;
        }
        this.evalExprText.setEnabled(false);
        this.expressionViewer.getTree().setEnabled(false);
        EvalExpression rootExpression = parent.getExpression();
        IJSValue result = null;
        if (rootExpression instanceof NodeExpression) {
            nsIDOMNode context = ((NodeExpression)rootExpression).getContext();
            MozIDEUIPlugin.debug("<NODE>." + evalExpression.toString());
            result = this.evaluator.evaluate(context, evalExpression.toString());
        } else {
            evalExpression.insert(0, '.');
            evalExpression.insert(0, rootExpression.getExpression());
            MozIDEUIPlugin.debug(evalExpression.toString());
            result = this.evaluator.evaluate(evalExpression.toString());
        }
        this.evalExprText.setEnabled(true);
        this.expressionViewer.getTree().setEnabled(true);
        this.expressionViewer.getTree().setFocus();
        JSObject evaledObject = (JSObject)result;
        jsObject.setProperties(evaledObject.getProperties());
        jsObject.evaluated = true;
    }

    public boolean isReady() {
        if (this.evaluator != null) {
            return this.evaluator.isReady();
        }
        return false;
    }

    protected void createAction() {
        this.clearAction = new Action("Clear", 1){

            public void run() {
                JSEvalPage.this.expressionList.clear();
                JSEvalPage.this.expressionViewer.refresh();
            }
        };
        this.clearAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("CLEAR_IMG_ID"));
        this.clearAction.setToolTipText("Clear");
    }

    public void dispose() {
        this.white.dispose();
        this.blue.dispose();
        this.red.dispose();
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().removeEventListener(this.webBrowser, (IApplicationEventListener)this.domDocumentListener);
        super.dispose();
    }

    public Control getControl() {
        return this.contentArea;
    }

    public void setFocus() {
    }

    public void setWebBrowser(IWebBrowser documentContainer) {
        if (this.webBrowser != null) {
            throw new AssertionFailedException("DOMWatcherPage already initialized, cannot call setDOMDocumentContainer() more than once.");
        }
        this.webBrowser = documentContainer;
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().addEventListener(this.webBrowser, (IApplicationEventListener)this.domDocumentListener);
    }

    public void evalElement(nsIDOMNode node) {
        IJSValue result = this.evaluator.evaluate(node, "");
        NodeExpression evalExpr = new NodeExpression(node, "", result);
        this.expressionList.add(0, evalExpr);
        this.expressionViewer.insert((Object)this.expressionList, (Object)evalExpr, 0);
        this.expressionViewer.reveal((Object)evalExpr);
    }

    protected void evalElement(nsIDOMNode node, String expression) {
    }

    protected class EvalViewerContentProvider
    implements ITreeContentProvider {
        protected EvalViewerContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement == JSEvalPage.this.expressionList) {
                return JSEvalPage.this.expressionList.toArray();
            }
            if (parentElement instanceof EvalExpression) {
                return this.getChildren(((EvalExpression)parentElement).getResult());
            }
            if (parentElement instanceof JSObject) {
                JSObject jsObj = (JSObject)parentElement;
                if (jsObj.evaluated) {
                    JSObjectProperty[] props = jsObj.getProperties();
                    ArrayList<IJSValue> childTypes = new ArrayList<IJSValue>(props.length);
                    int i = 0;
                    while (i < props.length) {
                        childTypes.add(props[i].value);
                        ++i;
                    }
                    return childTypes.toArray();
                }
                JSEvalPage.this.evaluate(jsObj);
                return this.getChildren(jsObj);
            }
            if (parentElement instanceof JSObjectProperty) {
                JSObjectProperty prop = (JSObjectProperty)parentElement;
                return this.getChildren(prop.value);
            }
            return null;
        }

        public Object getParent(Object element) {
            IJSValue jsValue;
            if (element instanceof IJSValue && (jsValue = (IJSValue)element).getParentProperty() != null) {
                JSObject parentObject = jsValue.getParentProperty().parentObject;
                if (parentObject.getExpression() != null) {
                    return parentObject.getExpression();
                }
                return parentObject;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element == JSEvalPage.this.expressionList) {
                return JSEvalPage.this.expressionList.size() > 0;
            }
            if (element instanceof EvalExpression) {
                return this.hasChildren(((EvalExpression)element).getResult());
            }
            if (element instanceof JSObject) {
                JSObject jsObj = (JSObject)element;
                if (jsObj.evaluated) {
                    return jsObj.getProperties().length > 0;
                }
                return true;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    protected class EvalViewerLabelProvider
    implements ITableLabelProvider,
    ITableColorProvider,
    ILabelProvider {
        private DOMLabelProvider domLabelProvider = new DOMLabelProvider();

        protected EvalViewerLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            String ret = "";
            if (element instanceof NodeExpression && columnIndex == 0) {
                NodeExpression nExpr = (NodeExpression)element;
                ret = String.valueOf(ret) + ">>> " + this.domLabelProvider.getText(nExpr.getContext());
            } else if (element instanceof EvalExpression && columnIndex == 0) {
                ret = String.valueOf(ret) + ">>> " + ((EvalExpression)element).getExpression();
            } else if (element instanceof EvalExpression && columnIndex == 1) {
                ret = String.valueOf(ret) + this.getColumnText(((EvalExpression)element).getResult(), 1);
            } else if (element instanceof IJSValue) {
                IJSValue jsValue = (IJSValue)element;
                if (columnIndex == 0) {
                    if (jsValue.getParentProperty() != null) {
                        ret = String.valueOf(ret) + jsValue.getParentProperty().name;
                    }
                } else if (columnIndex == 1) {
                    String typeId = jsValue.getType();
                    if (typeId == "number") {
                        String val = ((JSNumber)jsValue).value;
                        ret = String.valueOf(ret) + (val != null ? val : "");
                    } else if (typeId == "string") {
                        String val = ((JSString)jsValue).value;
                        ret = String.valueOf(ret) + (val != null ? "\"" + val + "\"" : "null");
                    } else if (typeId == "function") {
                        ret = String.valueOf(ret) + "function()";
                    } else if (typeId == "object") {
                        ret = String.valueOf(ret) + "object{}";
                    } else if (typeId == "null") {
                        ret = String.valueOf(ret) + "null";
                    } else if (typeId == "boolean") {
                        ret = String.valueOf(ret) + ((JSBoolean)jsValue).value;
                    } else if (typeId == "undefined") {
                        ret = String.valueOf(ret) + "undefined";
                    } else if (typeId == "error") {
                        ret = String.valueOf(ret) + ((JSError)jsValue).message;
                    }
                }
            }
            return ret;
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            Color c = null;
            if (element instanceof EvalExpression) {
                IJSValue result;
                String type;
                if (columnIndex == 0) {
                    c = JSEvalPage.this.blue;
                } else if (columnIndex == 1 && (type = (result = ((EvalExpression)element).getResult()).getType()) == "error") {
                    c = JSEvalPage.this.red;
                }
            }
            return c;
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            return this.getColumnText(element, 0);
        }
    }

    protected class EvalViewerSorter
    extends ViewerSorter {
        protected EvalViewerSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof EvalExpression && e2 instanceof EvalExpression) {
                return JSEvalPage.this.expressionList.indexOf(e1) - JSEvalPage.this.expressionList.indexOf(e2);
            }
            return super.compare(viewer, e1, e2);
        }
    }
}

