/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.jseval.model;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.BaseJSValue;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.IJSValue;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSBoolean;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSError;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSFunction;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSNull;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSNumber;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSObject;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSObjectProperty;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSString;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSUndefined;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JSTypeFactory {
    private IJSValue jsType = null;
    protected static JSTypeFactory instance = null;
    protected JSEvalParserHandler handler = new JSEvalParserHandler();

    public static JSTypeFactory getInstance() {
        if (instance == null) {
            instance = new JSTypeFactory();
        }
        return instance;
    }

    private JSTypeFactory() {
    }

    public IJSValue create(String xml) {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(xml.getBytes("UTF-8")), (DefaultHandler)this.handler);
            return this.jsType;
        }
        catch (ParserConfigurationException e) {
            MozIDEUIPlugin.log(e);
        }
        catch (SAXException e) {
            MozIDEUIPlugin.log(e);
        }
        catch (FactoryConfigurationError e) {
            MozIDEUIPlugin.log(e);
        }
        catch (IOException e) {
            MozIDEUIPlugin.log(e);
        }
        return null;
    }

    class JSEvalParserHandler
    extends DefaultHandler {
        private JSObjectProperty currentProp = null;
        private boolean isString = false;
        private boolean isError = false;
        private boolean isNumber = false;
        private boolean isBoolean = false;

        JSEvalParserHandler() {
        }

        public void startDocument() throws SAXException {
            JSTypeFactory.this.jsType = null;
            this.currentProp = null;
            this.isString = false;
            this.isError = false;
            this.isNumber = false;
            this.isBoolean = false;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("number")) {
                if (this.currentProp == null) {
                    JSTypeFactory.this.jsType = new JSNumber();
                } else {
                    this.currentProp.value = new JSNumber();
                    ((BaseJSValue)this.currentProp.value).setParentProperty(this.currentProp);
                }
                this.isNumber = true;
            } else if (qName.equalsIgnoreCase("boolean")) {
                if (this.currentProp == null) {
                    JSTypeFactory.this.jsType = new JSBoolean();
                } else {
                    this.currentProp.value = new JSBoolean();
                    ((BaseJSValue)this.currentProp.value).setParentProperty(this.currentProp);
                }
                this.isBoolean = true;
            } else if (qName.equalsIgnoreCase("string")) {
                if (this.currentProp == null) {
                    JSTypeFactory.this.jsType = new JSString();
                } else {
                    this.currentProp.value = new JSString();
                    ((BaseJSValue)this.currentProp.value).setParentProperty(this.currentProp);
                }
                this.isString = true;
            } else if (qName.equalsIgnoreCase("null")) {
                if (this.currentProp == null) {
                    JSTypeFactory.this.jsType = new JSNull();
                } else {
                    this.currentProp.value = new JSNull();
                    ((BaseJSValue)this.currentProp.value).setParentProperty(this.currentProp);
                }
            } else if (qName.equalsIgnoreCase("undefined")) {
                if (this.currentProp == null) {
                    JSTypeFactory.this.jsType = new JSUndefined();
                } else {
                    this.currentProp.value = new JSUndefined();
                    ((BaseJSValue)this.currentProp.value).setParentProperty(this.currentProp);
                }
            } else if (qName.equalsIgnoreCase("function")) {
                if (this.currentProp == null) {
                    JSTypeFactory.this.jsType = new JSFunction();
                    ((JSFunction)((JSTypeFactory)JSTypeFactory.this).jsType).evaluated = true;
                } else {
                    this.currentProp.value = new JSFunction();
                    ((BaseJSValue)this.currentProp.value).setParentProperty(this.currentProp);
                }
            } else if (qName.equalsIgnoreCase("object")) {
                if (this.currentProp == null) {
                    JSTypeFactory.this.jsType = new JSObject();
                    ((JSObject)((JSTypeFactory)JSTypeFactory.this).jsType).evaluated = true;
                } else {
                    this.currentProp.value = new JSObject();
                    ((BaseJSValue)this.currentProp.value).setParentProperty(this.currentProp);
                }
            } else if (qName.equalsIgnoreCase("error")) {
                if (this.currentProp == null) {
                    JSTypeFactory.this.jsType = new JSError();
                } else {
                    this.currentProp.value = new JSError();
                    ((BaseJSValue)this.currentProp.value).setParentProperty(this.currentProp);
                }
                this.isError = true;
            } else if (qName.equalsIgnoreCase("property")) {
                this.currentProp = new JSObjectProperty();
                this.currentProp.name = attributes.getValue("name");
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("number")) {
                this.isNumber = false;
            } else if (qName.equalsIgnoreCase("boolean")) {
                this.isBoolean = false;
            } else if (qName.equalsIgnoreCase("string")) {
                this.isString = false;
            } else if (!(qName.equalsIgnoreCase("null") || qName.equalsIgnoreCase("undefined") || qName.equalsIgnoreCase("function") || qName.equalsIgnoreCase("object"))) {
                if (qName.equalsIgnoreCase("error")) {
                    this.isError = false;
                } else if (qName.equalsIgnoreCase("property")) {
                    if (JSTypeFactory.this.jsType instanceof JSObject && this.currentProp != null) {
                        ((JSObject)JSTypeFactory.this.jsType).addProperty(this.currentProp);
                    }
                    this.currentProp = null;
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.isString) {
                String str = new String(ch, start, length);
                try {
                    str = URLDecoder.decode(str, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    MozIDEUIPlugin.log(e);
                }
                System.out.println(str);
                if (this.currentProp == null) {
                    ((JSString)((JSTypeFactory)JSTypeFactory.this).jsType).value = ((JSString)((JSTypeFactory)JSTypeFactory.this).jsType).value == null ? str : String.valueOf(((JSString)((JSTypeFactory)JSTypeFactory.this).jsType).value) + str;
                } else {
                    ((JSString)this.currentProp.value).value = ((JSString)this.currentProp.value).value == null ? str : String.valueOf(((JSString)this.currentProp.value).value) + str;
                }
            } else if (this.isError) {
                if (this.currentProp == null) {
                    ((JSError)((JSTypeFactory)JSTypeFactory.this).jsType).message = new String(ch, start, length);
                } else {
                    ((JSError)this.currentProp.value).message = new String(ch, start, length);
                }
            } else if (this.isNumber) {
                if (this.currentProp == null) {
                    ((JSNumber)((JSTypeFactory)JSTypeFactory.this).jsType).value = new String(ch, start, length);
                } else {
                    ((JSNumber)this.currentProp.value).value = new String(ch, start, length);
                }
            } else if (this.isBoolean) {
                if (this.currentProp == null) {
                    ((JSBoolean)((JSTypeFactory)JSTypeFactory.this).jsType).value = new String(ch, start, length);
                } else {
                    ((JSBoolean)this.currentProp.value).value = new String(ch, start, length);
                }
            }
        }
    }
}

