/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.events.IApplicationEvent;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.BrowserCreatedEvent;
import org.eclipse.atf.mozilla.ide.ui.browser.BrowserDisposedEvent;
import org.eclipse.atf.mozilla.ide.ui.netmon.EventRecorder;

public class CallListsManager
implements IApplicationEventListener {
    private Map<IWebBrowser, EventRecorder> callLists = new HashMap<IWebBrowser, EventRecorder>();

    public EventRecorder getCallList(IWebBrowser browser) {
        return this.callLists.get(browser);
    }

    private void browserCreated(IWebBrowser webBrowser) {
        EventRecorder callList = new EventRecorder();
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().addEventListener(webBrowser, (IApplicationEventListener)callList);
        this.callLists.put(webBrowser, callList);
    }

    private void browserDisposed(IWebBrowser webBrowser) {
        EventRecorder callList = this.callLists.remove(webBrowser);
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().removeEventListener(webBrowser, (IApplicationEventListener)callList);
    }

    public void onEvent(IApplicationEvent event) {
        if (event instanceof BrowserCreatedEvent) {
            this.browserCreated(event.getBrowser());
        } else if (event instanceof BrowserDisposedEvent) {
            this.browserDisposed(event.getBrowser());
        }
    }
}

