/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon;

import java.util.Date;
import org.eclipse.atf.mozilla.ide.network.IHTTPRequest;
import org.eclipse.atf.mozilla.ide.network.IHTTPResponse;
import org.eclipse.atf.mozilla.ide.network.INetworkCall;
import org.eclipse.atf.mozilla.ide.network.IRequest;
import org.eclipse.atf.mozilla.ide.network.IResponse;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class NetworkCallLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image getImage(INetworkCall call) {
        if (call.getState().equals("ACTIVE")) {
            return MozIDEUIPlugin.getDefault().getImage("waiting");
        }
        if (call.getState().equals("ERROR")) {
            return MozIDEUIPlugin.getDefault().getImage("error");
        }
        if (call.getState().equals("WARNING")) {
            return MozIDEUIPlugin.getDefault().getImage("warning");
        }
        if (call.getState().equals("SUCCESS")) {
            return MozIDEUIPlugin.getDefault().getImage("done");
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        INetworkCall call = (INetworkCall)element;
        switch (columnIndex) {
            case 0: {
                return this.getImage(call);
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        INetworkCall call = (INetworkCall)element;
        switch (columnIndex) {
            case 0: {
                break;
            }
            case 1: {
                result = call.getRequest().getURL().toString();
                break;
            }
            case 2: {
                IRequest req = call.getRequest();
                if (!(req instanceof IHTTPRequest)) break;
                result = ((IHTTPRequest)req).getMethod();
                break;
            }
            case 3: {
                long startTime = call.getStartTime();
                if (startTime == -1L) break;
                result = new Date(startTime).toString();
                break;
            }
            case 4: {
                long endTime = call.getEndTime();
                if (endTime == -1L) break;
                result = new Date(endTime).toString();
                break;
            }
            case 5: {
                long totalTime = call.getTotalTime();
                if (totalTime == -1L) break;
                result = String.valueOf(totalTime) + " ms";
                break;
            }
            case 6: {
                IResponse res = call.getResponse();
                if (!(res instanceof IHTTPResponse)) break;
                result = ((IHTTPResponse)res).getStatus();
                break;
            }
        }
        return result;
    }
}

