/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon.payload;

import java.util.HashMap;
import org.eclipse.atf.mozilla.ide.network.IHeaderContainer;
import org.eclipse.atf.mozilla.ide.ui.netmon.payload.CSSPayloadRenderStrategy;
import org.eclipse.atf.mozilla.ide.ui.netmon.payload.HTMLPayloadRenderStrategy;
import org.eclipse.atf.mozilla.ide.ui.netmon.payload.IPayloadRenderStrategy;
import org.eclipse.atf.mozilla.ide.ui.netmon.payload.ImagePayloadRenderStrategy;
import org.eclipse.atf.mozilla.ide.ui.netmon.payload.SimpleTextPayloadRenderStrategy;
import org.eclipse.atf.mozilla.ide.ui.netmon.payload.UnsupportedContentStrategy;

public class PayloadRenderStrategyFactory {
    private static PayloadRenderStrategyFactory instance = null;
    protected HashMap cachedStrategies = new HashMap();
    protected IPayloadRenderStrategy defaultStrategy = null;

    public static PayloadRenderStrategyFactory getInstance() {
        if (instance == null) {
            instance = new PayloadRenderStrategyFactory();
        }
        return instance;
    }

    private PayloadRenderStrategyFactory() {
    }

    public IPayloadRenderStrategy getStrategy(IHeaderContainer headerContainer) {
        int mimeDelim;
        String contentType = (String)headerContainer.getHeaders().get("Content-Type");
        String type = "?";
        if (contentType != null) {
            type = contentType;
        }
        if ((mimeDelim = type.indexOf(59)) != -1) {
            type = type.substring(0, mimeDelim);
        }
        IPayloadRenderStrategy strategy = null;
        if ("image/gif:image/jpeg:image/pjpeg:image/png:image/bmp".indexOf(type) != -1) {
            if (!this.cachedStrategies.containsKey("image/gif:image/jpeg:image/pjpeg:image/png:image/bmp")) {
                this.cachedStrategies.put("image/gif:image/jpeg:image/pjpeg:image/png:image/bmp", new ImagePayloadRenderStrategy());
            }
            strategy = (IPayloadRenderStrategy)this.cachedStrategies.get("image/gif:image/jpeg:image/pjpeg:image/png:image/bmp");
        } else if ("application/x-javascript:text/javascript:application/javascript".indexOf(type) != -1) {
            if (!this.cachedStrategies.containsKey("application/x-javascript:text/javascript:application/javascript")) {
                this.cachedStrategies.put("application/x-javascript:text/javascript:application/javascript", new SimpleTextPayloadRenderStrategy());
            }
            strategy = (IPayloadRenderStrategy)this.cachedStrategies.get("application/x-javascript:text/javascript:application/javascript");
        } else if ("text/css".indexOf(type) != -1) {
            if (!this.cachedStrategies.containsKey("text/css")) {
                this.cachedStrategies.put("text/css", new CSSPayloadRenderStrategy());
            }
            strategy = (IPayloadRenderStrategy)this.cachedStrategies.get("text/css");
        } else if ("text/html".indexOf(type) != -1) {
            if (!this.cachedStrategies.containsKey("text/html")) {
                this.cachedStrategies.put("text/html", new HTMLPayloadRenderStrategy());
            }
            strategy = (IPayloadRenderStrategy)this.cachedStrategies.get("text/html");
        } else if ("application/xml:text/xml:application/atom+xml".indexOf(type) != -1) {
            if (!this.cachedStrategies.containsKey("application/xml:text/xml:application/atom+xml")) {
                this.cachedStrategies.put("application/xml:text/xml:application/atom+xml", new HTMLPayloadRenderStrategy());
            }
            strategy = (IPayloadRenderStrategy)this.cachedStrategies.get("application/xml:text/xml:application/atom+xml");
        } else if ("application/xhtml+xml".indexOf(type) != -1) {
            if (!this.cachedStrategies.containsKey("application/xhtml+xml")) {
                this.cachedStrategies.put("application/xhtml+xml", new HTMLPayloadRenderStrategy());
            }
            strategy = (IPayloadRenderStrategy)this.cachedStrategies.get("application/xhtml+xml");
        } else if ("text/plain".indexOf(type) != -1) {
            if (!this.cachedStrategies.containsKey("text/plain")) {
                this.cachedStrategies.put("text/plain", new SimpleTextPayloadRenderStrategy());
            }
            strategy = (IPayloadRenderStrategy)this.cachedStrategies.get("text/plain");
        } else {
            if (this.defaultStrategy == null) {
                this.defaultStrategy = new UnsupportedContentStrategy();
            }
            strategy = this.defaultStrategy;
        }
        return strategy;
    }
}

