/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.source;

import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.atf.mozilla.ide.common.IDOMNodeSelection;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.core.ContentFormatter;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentEvent;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentListener;
import org.eclipse.atf.mozilla.ide.events.DOMMutationListener;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.views.IBrowserView;
import org.eclipse.atf.mozilla.ide.ui.common.SelectionProviderHandler;
import org.eclipse.atf.mozilla.ide.ui.common.configs.HTMLDOMSourceViewerConfiguration;
import org.eclipse.atf.mozilla.ide.ui.source.IDOMSourcePage;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMSerializer;
import org.mozilla.xpcom.Mozilla;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.XMLFilterImpl;

public class DOMSourcePage
extends Page
implements IDOMSourcePage,
IBrowserView,
ISelectionListener {
    protected IWebBrowser documentContainer = null;
    protected nsIDOMNode currentlySelectedNode = null;
    private DOMDocumentListener domDocumentListener = new DOMDocumentListener(){

        public void documentUnloaded(DOMDocumentEvent event) {
            if (event.isTop()) {
                DOMSourcePage.this.clearSource();
            }
        }
    };
    private DOMMutationListener domMutationListener = new DOMMutationListener(){

        public void attributeAdded(nsIDOMElement ownerElement, String attributeName) {
            if (DOMSourcePage.this.currElement != null && ownerElement.equals(DOMSourcePage.this.currElement)) {
                DOMSourcePage.this.showDomChange();
            }
        }

        public void attributeModified(nsIDOMElement ownerElement, String attributeName, String newValue, String previousValue) {
            if (DOMSourcePage.this.currElement != null && ownerElement.equals(DOMSourcePage.this.currElement)) {
                DOMSourcePage.this.showDomChange();
            }
        }

        public void attributeRemoved(nsIDOMElement ownerElement, String attributeName) {
            if (DOMSourcePage.this.currElement != null && ownerElement.equals(DOMSourcePage.this.currElement)) {
                DOMSourcePage.this.showDomChange();
            }
        }

        public void nodeInserted(nsIDOMNode parentNode, nsIDOMNode insertedNode) {
            if (DOMSourcePage.this.currentlySelectedNode != null && parentNode.equals(DOMSourcePage.this.currentlySelectedNode)) {
                DOMSourcePage.this.showDomChange();
            }
        }
    };
    protected Menu menu;
    protected MenuItem update;
    protected MenuItem validate;
    protected MenuItem refresh;
    protected nsIDOMElement currElement;
    protected SourceViewer sourceViewer = null;
    protected HTMLDOMSourceViewerConfiguration config;
    protected StyledText status_bar;
    protected StyleRange sr;
    protected SashForm displayArea = null;
    protected Composite top = null;
    protected static final String STATUS = "Source Status:  ";
    protected static final String PREPROCESSING = "Loading...";
    protected static final String UNSAVED_UNVALIDATED = "Unsaved and unvalidated changes to source.";
    protected static final String REMOVED = "Node has been removed.";
    protected static final String CHANGED = "Node has been changed in browser.";
    protected static final String NO_CHANGES = "No unsaved changes.";
    protected static final String NO_SAVE = "Could not update. ";
    protected String edited = "";
    protected Action saveAction;
    protected Action validateAction;
    protected Action refreshAction;
    protected SelectionProviderHandler provider = new SelectionProviderHandler();
    protected Color colorWhite = new Color((Device)Display.getCurrent(), new RGB(225, 225, 225));
    protected Color colorBlack = new Color((Device)Display.getCurrent(), new RGB(0, 0, 0));
    protected Color colorRed = new Color((Device)Display.getCurrent(), new RGB(255, 0, 0));
    protected static final Document emptyDoc = new Document("");
    protected DOMSourcePreprocessingJob currentFormmatingJob = null;

    public void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        this.top = new Composite(parent, 0);
        this.top.setLayout((Layout)layout);
        this.top.setLayoutData((Object)new GridData(4, 4, true, true));
        this.status_bar = new StyledText(this.top, 0);
        this.status_bar.setBackground(this.colorWhite);
        this.sr = new StyleRange(0, 14, this.colorBlack, this.colorWhite, 1);
        this.status_bar.setLayoutData((Object)new GridData(4, 4, true, false));
        this.status_bar.setEditable(false);
        this.status_bar.setEnabled(false);
        this.status_bar.setText(STATUS);
        this.status_bar.setStyleRange(this.sr);
        this.displayArea = new SashForm(this.top, 2048);
        layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = false;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        this.displayArea.setLayout((Layout)layout);
        this.displayArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.config = new HTMLDOMSourceViewerConfiguration(this.provider);
        this.sourceViewer = new SourceViewer((Composite)this.displayArea, null, 2816);
        this.sourceViewer.configure((SourceViewerConfiguration)this.config);
        this.sourceViewer.setEditable(false);
        this.sourceViewer.setDocument((IDocument)emptyDoc);
        this.sourceViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                if (!DOMSourcePage.this.edited.equals(event.getText()) && event.getDocumentEvent() != null) {
                    DOMSourcePage.this.status_bar.setText("Source Status:  Unsaved and unvalidated changes to source.");
                    StyleRange sr1 = new StyleRange(DOMSourcePage.STATUS.length(), DOMSourcePage.UNSAVED_UNVALIDATED.length(), DOMSourcePage.this.colorRed, DOMSourcePage.this.colorWhite);
                    DOMSourcePage.this.status_bar.setStyleRange(DOMSourcePage.this.sr);
                    DOMSourcePage.this.status_bar.setStyleRange(sr1);
                }
            }
        });
        this.sourceViewer.refresh();
        this.menu = new Menu(this.sourceViewer.getControl());
        this.menu.setEnabled(true);
        this.update = new MenuItem(this.menu, 8);
        this.update.setText("Update browser page");
        this.update.setEnabled(false);
        this.update.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DOMSourcePage.this.save();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.update.setImage(MozIDEUIPlugin.getDefault().getImage("E_UPDATE_ID"));
        this.refresh = new MenuItem(this.menu, 8);
        this.refresh.setText("Refresh from browser");
        this.refresh.setEnabled(false);
        this.refresh.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DOMSourcePage.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.refresh.setImage(MozIDEUIPlugin.getDefault().getImage("E_REFRESH_ID"));
        this.validate = new MenuItem(this.menu, 8);
        this.validate.setText("Validate source");
        this.validate.setEnabled(false);
        this.validate.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DOMSourcePage.this.validate();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.validate.setImage(MozIDEUIPlugin.getDefault().getImage("VALIDATE_ID"));
        this.sourceViewer.getControl().setMenu(this.menu);
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        this.saveAction = new Action(){

            public void run() {
                DOMSourcePage.this.save();
            }
        };
        this.saveAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("E_UPDATE_ID"));
        this.saveAction.setToolTipText("Update browser source with changes");
        this.saveAction.setEnabled(false);
        toolBarManager.add((IAction)this.saveAction);
        this.refreshAction = new Action(){

            public void run() {
                DOMSourcePage.this.refresh();
            }
        };
        this.refreshAction.setEnabled(false);
        this.refreshAction.setToolTipText("Refresh source from browser page");
        this.refreshAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("E_REFRESH_ID"));
        toolBarManager.add((IAction)this.refreshAction);
        this.validateAction = new Action(){

            public void run() {
                DOMSourcePage.this.validate();
            }
        };
        this.validateAction.setEnabled(false);
        this.validateAction.setToolTipText("Validate DOM source");
        this.validateAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("VALIDATE_ID"));
        toolBarManager.add((IAction)this.validateAction);
        this.getSite().setSelectionProvider((ISelectionProvider)this.provider);
    }

    private void save() {
        boolean saved = this.config.save();
        if (saved) {
            this.currElement = (nsIDOMElement)this.config.getNode().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            this.status_bar.setText("Source Status:  No unsaved changes.");
            StyleRange sr1 = new StyleRange(STATUS.length(), NO_CHANGES.length(), this.colorBlack, this.colorWhite);
            this.status_bar.setStyleRange(this.sr);
            this.status_bar.setStyleRange(sr1);
            this.currentlySelectedNode = this.config.getNode();
        } else {
            String validated = this.config.validate();
            this.status_bar.setText("Source Status:  Could not update. " + validated);
            StyleRange sr1 = new StyleRange(STATUS.length(), NO_SAVE.length() + validated.length(), this.colorRed, this.colorWhite);
            this.showErrors();
            this.status_bar.setStyleRange(this.sr);
            this.status_bar.setStyleRange(sr1);
        }
    }

    private void showErrors() {
        if (this.config.getErrorOffset() != -1) {
            this.sourceViewer.setSelectedRange(this.config.getErrorOffset(), 0);
            this.sourceViewer.revealRange(this.config.getErrorOffset(), 0);
        }
    }

    private void validate() {
        String validated = this.config.validate();
        this.status_bar.setText(STATUS + validated);
        StyleRange sr1 = null;
        sr1 = validated.indexOf("Validation error: ") == -1 ? new StyleRange(STATUS.length(), validated.length(), this.colorBlack, this.colorWhite) : new StyleRange(STATUS.length(), validated.length(), this.colorRed, this.colorWhite);
        this.showErrors();
        this.status_bar.setStyleRange(this.sr);
        this.status_bar.setStyleRange(sr1);
    }

    private void refresh() {
        this.displaySource(this.currentlySelectedNode);
    }

    public Control getControl() {
        return this.top;
    }

    public void setFocus() {
    }

    public void dispose() {
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().removeEventListener(this.documentContainer, (IApplicationEventListener)this.domDocumentListener);
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().removeEventListener(this.documentContainer, (IApplicationEventListener)this.domMutationListener);
        this.colorWhite.dispose();
        this.colorBlack.dispose();
        this.colorRed.dispose();
        super.dispose();
    }

    public void setWebBrowser(IWebBrowser documentContainer) {
        if (this.documentContainer != null) {
            throw new AssertionFailedException("DOMSourcePage already initialized, cannot call setDOMDocumentContainer() more than once.");
        }
        this.documentContainer = documentContainer;
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().addEventListener(documentContainer, (IApplicationEventListener)this.domDocumentListener);
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().addEventListener(documentContainer, (IApplicationEventListener)this.domMutationListener);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IDOMNodeSelection) {
            if (selection.isEmpty()) {
                this.currentlySelectedNode = ((IDOMNodeSelection)selection).getSelectedNode();
                this.clearSource();
            } else if (this.currentlySelectedNode == null || !this.currentlySelectedNode.equals(((IDOMNodeSelection)selection).getSelectedNode())) {
                this.currentlySelectedNode = ((IDOMNodeSelection)selection).getSelectedNode();
                this.displaySource(((IDOMNodeSelection)selection).getSelectedNode());
                if (((IDOMNodeSelection)selection).getSelectedNode().getNodeType() == 1) {
                    this.currElement = (nsIDOMElement)((IDOMNodeSelection)selection).getSelectedNode().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                }
                this.update.setEnabled(true);
                this.validate.setEnabled(true);
                this.refresh.setEnabled(true);
            }
        }
    }

    protected void displaySource(nsIDOMNode node) {
        this.config.setNode(node);
        this.config.clear();
        this.config.getNodes(node, 0);
        this.status_bar.setText("Source Status:  Loading...");
        StyleRange sr1 = new StyleRange(STATUS.length(), PREPROCESSING.length(), this.colorBlack, this.colorWhite);
        this.status_bar.setStyleRange(this.sr);
        this.status_bar.setStyleRange(sr1);
        this.clearSource();
        nsIDOMSerializer domSerializer = (nsIDOMSerializer)Mozilla.getInstance().getComponentManager().createInstanceByContractID("@mozilla.org/xmlextras/xmlserializer;1", null, "{9fd4ba15-e67c-4c98-b52c-7715f62c9196}");
        String text = domSerializer.serializeToString(node);
        if (this.currentFormmatingJob != null) {
            this.currentFormmatingJob.cancel();
        }
        if (node.getNodeType() == 1 || node.getNodeType() == 9) {
            this.currentFormmatingJob = new DOMSourcePreprocessingJob(text);
            this.currentFormmatingJob.addJobChangeListener(new IJobChangeListener(){

                public void aboutToRun(IJobChangeEvent event) {
                }

                public void awake(IJobChangeEvent event) {
                }

                public void done(IJobChangeEvent event) {
                    event.getJob().removeJobChangeListener((IJobChangeListener)this);
                    if (event.getJob() == DOMSourcePage.this.currentFormmatingJob) {
                        final String domSource = DOMSourcePage.this.currentFormmatingJob.getResultText();
                        DOMSourcePage.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                DOMSourcePage.this.displaySource(domSource);
                            }
                        });
                        DOMSourcePage.this.currentFormmatingJob = null;
                    }
                }

                public void running(IJobChangeEvent event) {
                }

                public void scheduled(IJobChangeEvent event) {
                }

                public void sleeping(IJobChangeEvent event) {
                }
            });
            this.currentFormmatingJob.schedule();
        } else {
            this.displaySource(text);
        }
    }

    protected void displaySource(String text) {
        Document doc = new Document(text);
        this.edited = text;
        this.status_bar.setText("Source Status:  No unsaved changes.");
        this.saveAction.setEnabled(true);
        this.validateAction.setEnabled(true);
        this.refreshAction.setEnabled(true);
        StyleRange sr1 = new StyleRange(STATUS.length(), NO_CHANGES.length(), this.colorBlack, this.colorWhite);
        this.status_bar.setStyleRange(this.sr);
        this.status_bar.setStyleRange(sr1);
        this.sourceViewer.setDocument((IDocument)doc);
        this.config.setDocument((IDocument)doc);
        this.sourceViewer.setEditable(true);
        this.sourceViewer.refresh();
    }

    protected void clearSource() {
        this.update.setEnabled(false);
        this.validate.setEnabled(false);
        this.refresh.setEnabled(false);
        this.saveAction.setEnabled(false);
        this.validateAction.setEnabled(false);
        this.refreshAction.setEnabled(false);
        this.sourceViewer.setEditable(false);
        this.sourceViewer.setDocument((IDocument)emptyDoc);
        this.sourceViewer.refresh();
    }

    private void showDomChange() {
        this.status_bar.setText("Source Status:  Node has been changed in browser.");
        StyleRange sr1 = new StyleRange(STATUS.length(), CHANGED.length(), this.colorRed, this.colorWhite);
        this.status_bar.setStyleRange(this.sr);
        this.status_bar.setStyleRange(sr1);
    }

    protected class DOMSourcePreprocessingJob
    extends Job {
        protected String domAsText;

        public DOMSourcePreprocessingJob(String domAsText) {
            super("DOM Source Preprocessing Job");
            this.domAsText = null;
            this.domAsText = domAsText;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                Transformer xformer = TransformerFactory.newInstance().newTransformer();
                xformer.setOutputProperty("method", "xml");
                xformer.setOutputProperty("omit-xml-declaration", "yes");
                xformer.setOutputProperty("indent", "yes");
                SAXParserFactory saxFact = SAXParserFactory.newInstance();
                saxFact.setFeature("http://xml.org/sax/features/validation", false);
                SAXParser parser = saxFact.newSAXParser();
                SAXSource input = new SAXSource(new XMLFilterImpl(parser.getXMLReader()){
                    protected int level;
                    {
                        this.level = 0;
                    }

                    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
                        if (this.level > 0) {
                            ++this.level;
                            return;
                        }
                        String classAttrValue = atts.getValue("class");
                        if (classAttrValue != null && classAttrValue.equals("___ATF_INTERNAL")) {
                            this.level = 1;
                        } else {
                            super.startElement(uri, localName, qName, atts);
                        }
                    }

                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        if (this.level > 0) {
                            --this.level;
                        } else {
                            super.endElement(uri, localName, qName);
                        }
                    }

                    public void characters(char[] ch, int start, int length) throws SAXException {
                        if (this.level == 0) {
                            super.characters(ch, start, length);
                        }
                    }
                }, new InputSource(new ByteArrayInputStream(this.domAsText.getBytes("UTF-8"))));
                StringWriter writer = new StringWriter();
                StreamResult output = new StreamResult(writer);
                xformer.transform(input, output);
                this.domAsText = writer.toString();
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
                this.domAsText = ContentFormatter.removeFlashingDiv((String)this.domAsText);
                this.domAsText = ContentFormatter.removeInternalScriptNode((String)this.domAsText);
            }
            this.domAsText = ContentFormatter.format((String)this.domAsText, (String)"html");
            return Status.OK_STATUS;
        }

        public String getResultText() {
            return this.domAsText;
        }
    }
}

