/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.util;

import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;

public class DOMNodeUtils {
    public static String nodeToString(nsIDOMNode node) {
        StringBuffer buffer = new StringBuffer();
        while (node != null) {
            buffer.append(node.getNodeName());
            if (node.getNodeType() == 1) {
                nsIDOMElement element = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                if (element.hasAttribute("id")) {
                    buffer.append("[");
                    buffer.append(element.getAttribute("id"));
                    buffer.append("]");
                } else if (element.hasAttribute("class")) {
                    buffer.append("[");
                    buffer.append(element.getAttribute("class"));
                    buffer.append("]");
                } else {
                    nsIDOMNode sibling = element.getPreviousSibling();
                    int index = 0;
                    while (sibling != null) {
                        if (sibling.getNodeType() == 1 && sibling.getNodeName().equalsIgnoreCase(element.getNodeName())) {
                            ++index;
                        }
                        sibling = sibling.getPreviousSibling();
                    }
                    if (index > 0) {
                        buffer.append("[");
                        buffer.append(index);
                        buffer.append("]");
                    }
                }
            }
            if (node.getNodeType() != 9) {
                buffer.append("/");
            }
            node = node.getParentNode();
        }
        return buffer.toString();
    }
}

