/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.internal.model;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugElementWithVariables;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.mozilla.interfaces.jsdIProperty;
import org.mozilla.interfaces.jsdIValue;

public class JSDebugValue
extends JSDebugElementWithVariables
implements IValue {
    private jsdIValue _value;
    private String _valueString;
    private String _typeName = null;
    private boolean _compound;
    private boolean _initializedVars;
    private IThread _thread;

    public JSDebugValue(IDebugTarget target, IThread thread, jsdIValue value) {
        super(target);
        this._thread = thread;
        this._value = value;
        this._compound = !this._value.getIsNumber() && !this._value.getIsPrimitive();
    }

    public String getLabel() {
        try {
            return this.getValueString();
        }
        catch (DebugException debugException) {
            return null;
        }
    }

    public String getReferenceTypeName() throws DebugException {
        if (this._typeName == null) {
            switch ((int)this._value.getJsType()) {
                case 0: {
                    this._typeName = "boolean";
                    break;
                }
                case 1: {
                    this._typeName = "double";
                    break;
                }
                case 2: {
                    this._typeName = "int";
                    break;
                }
                case 3: {
                    this._typeName = "function";
                    break;
                }
                case 4: {
                    this._typeName = "null";
                    break;
                }
                case 5: {
                    this._typeName = "object";
                    break;
                }
                case 6: {
                    this._typeName = "string";
                    break;
                }
                case 7: {
                    this._typeName = "void";
                    break;
                }
                default: {
                    this._typeName = "unknown";
                }
            }
        }
        return this._typeName;
    }

    public String getValueString() throws DebugException {
        if (this._valueString == null) {
            this._valueString = this._value.getStringValue();
        }
        return this._valueString;
    }

    public String setValueString(String valueString) {
        return null;
    }

    public boolean isAllocated() throws DebugException {
        return true;
    }

    public IVariable[] getVariables() throws DebugException {
        if (!this._initializedVars) {
            this.initializeVars();
        }
        return super.getVariables();
    }

    public boolean hasVariables() throws DebugException {
        if (!this._initializedVars) {
            return this._compound;
        }
        return super.hasVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeVars() throws DebugException {
        IThread iThread = this._thread;
        synchronized (iThread) {
            jsdIValue parent;
            jsdIValue constr;
            if (this._initializedVars) {
                return;
            }
            jsdIValue proto = this._value.getJsPrototype();
            if (proto != null) {
                this.addVariable(new JSDebugVariable(this.getDebugTarget(), this._thread, "prototype", proto, true));
            }
            if ((constr = this._value.getJsConstructor()) != null) {
                this.addVariable(new JSDebugVariable(this.getDebugTarget(), this._thread, "constructor", constr, true));
            }
            if ((parent = this._value.getJsParent()) != null) {
                this.addVariable(new JSDebugVariable(this.getDebugTarget(), this._thread, "parent", parent, true));
            }
            jsdIProperty[][] propArray = new jsdIProperty[1][];
            long[] lengthRef = new long[1];
            this._value.getProperties((jsdIProperty[][])propArray, lengthRef);
            if (lengthRef[0] > 0L) {
                Arrays.sort(propArray[0], 0, (int)lengthRef[0], new Comparator(){

                    public int compare(Object val1, Object val2) {
                        try {
                            String prop1 = ((jsdIProperty)val1).getName().getStringValue();
                            String prop2 = ((jsdIProperty)val2).getName().getStringValue();
                            return prop1.compareTo(prop2);
                        }
                        catch (Exception e) {
                            MozillaDebugPlugin.log(e);
                            return 0;
                        }
                    }
                });
            }
            int i = 0;
            while ((long)i < lengthRef[0]) {
                jsdIProperty prop = propArray[0][i];
                String name = prop.getName().getStringValue();
                jsdIValue value = prop.getValue();
                this.addVariable(new JSDebugVariable(this.getDebugTarget(), this._thread, name, value));
                ++i;
            }
            this._initializedVars = true;
        }
    }

    public Object getAdapter(Class adapter) {
        if (jsdIValue.class.equals((Object)adapter)) {
            return this._value;
        }
        return super.getAdapter(adapter);
    }
}

