/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.internal.model;

import org.eclipse.atf.mozilla.ide.core.IXPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.core.XPCOMThreadProxy;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugElement;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTarget;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.mozilla.interfaces.jsdIValue;
import org.mozilla.interfaces.nsISupports;

public class JSDebugVariable
extends JSDebugElement
implements IVariable {
    private String _name;
    private IValue _value;
    private boolean isInternal;

    public JSDebugVariable(IDebugTarget target, IThread thread, String name, jsdIValue initialValue, boolean isInternal) {
        this(target, thread, name, initialValue);
        this.isInternal = isInternal;
    }

    public JSDebugVariable(IDebugTarget target, IThread thread, String name, jsdIValue initialValue) {
        super(target);
        this._name = name;
        if (initialValue != null) {
            initialValue = (jsdIValue)XPCOMThreadProxy.createProxy((nsISupports)initialValue, (IXPCOMThreadProxyHelper)((JSDebugTarget)target).getProxyHelper());
            this._value = new JSDebugValue(this.getDebugTarget(), thread, initialValue);
        }
    }

    public String getLabel() {
        StringBuffer buffer = new StringBuffer(this._name);
        try {
            buffer.append("=");
            buffer.append(this.getValue().getValueString());
        }
        catch (DebugException debugException) {
            return this._name;
        }
        return buffer.toString();
    }

    public IValue getValue() throws DebugException {
        return this._value;
    }

    public String getName() throws DebugException {
        return this._name;
    }

    public String getReferenceTypeName() throws DebugException {
        return this._value.getReferenceTypeName();
    }

    public boolean hasValueChanged() throws DebugException {
        return false;
    }

    public void setValue(String expression) throws DebugException {
        this._value = null;
    }

    public void setValue(IValue value) throws DebugException {
        this._value = null;
        throw new DebugException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug", 0, "not supported", null));
    }

    public boolean supportsValueModification() {
        return false;
    }

    public boolean verifyValue(String expression) throws DebugException {
        return true;
    }

    public boolean verifyValue(IValue value) throws DebugException {
        return false;
    }

    public boolean isInternal() {
        return this.isInternal;
    }
}

