/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui;

import org.eclipse.atf.mozilla.ide.debug.model.JSLineBreakpoint;
import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class JSLineBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IBreakpoint breakpoint;
        if (!(part instanceof ITextEditor)) {
            return;
        }
        ITextEditor textEditor = (ITextEditor)part;
        IEditorInput input = textEditor.getEditorInput();
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine();
        IStorage storage = null;
        if (input instanceof IStorageEditorInput) {
            storage = ((IStorageEditorInput)input).getStorage();
        }
        if ((breakpoint = this.findBreakpoint(storage, lineNumber + 1)) != null) {
            breakpoint.delete();
            return;
        }
        JSLineBreakpoint lineBreakpoint = new JSLineBreakpoint(storage, lineNumber + 1, -1, -1, true, null);
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
    }

    private IBreakpoint findBreakpoint(IStorage storage, int lineNumber) throws CoreException {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.atf.mozilla.ide.debug");
        int i = 0;
        while (i < breakpoints.length) {
            block9: {
                IBreakpoint breakpoint;
                block8: {
                    IMarker marker;
                    block7: {
                        breakpoint = breakpoints[i];
                        marker = breakpoint.getMarker();
                        if (!(storage instanceof IFile)) break block7;
                        if (storage.equals(marker.getResource())) break block8;
                        break block9;
                    }
                    String id = storage.getName();
                    String markerId = null;
                    try {
                        markerId = (String)marker.getAttribute("org.eclipse.wst.sse.ui.extensions.breakpoint.path");
                    }
                    catch (CoreException e) {
                        MozillaDebugUIPlugin.log(e);
                    }
                    if (!id.equals(markerId)) break block9;
                }
                if (((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber) {
                    return breakpoint;
                }
            }
            ++i;
        }
        return null;
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection);
    }
}

