/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui.internal.adapter;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.atf.mozilla.ide.core.util.SourceLocatorUtil;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugScriptElement;
import org.eclipse.atf.mozilla.ide.debug.model.JSSourceLocator;
import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIPlugin;
import org.eclipse.atf.mozilla.ide.debug.ui.util.DebuggerSourceDisplayUtil;
import org.eclipse.atf.mozilla.ide.ui.util.SourceDisplayUtil;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.internal.ui.sourcelookup.SourceLookupResult;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.debug.ui.sourcelookup.ISourceLookupResult;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JSDebugScriptElementSourceDisplayAdapter
implements ISourceDisplay {
    private JSDebugScriptElement fPrevScript;
    private SourceLookupResult fPrevResult;
    private SourceLookupJob fSourceLookupJob = new SourceLookupJob();
    private SourceDisplayJob fSourceDisplayJob = new SourceDisplayJob();

    public JSDebugScriptElementSourceDisplayAdapter() {
        DebugPlugin.getDefault().addDebugEventListener(new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    switch (event.getKind()) {
                        case 8: {
                            JSDebugScriptElementSourceDisplayAdapter.this.clearCachedModel(event.getSource());
                        }
                        case 1: {
                            if (event.isEvaluation()) break;
                            JSDebugScriptElementSourceDisplayAdapter.this.clearSourceSelection(event.getSource());
                        }
                    }
                    ++i;
                }
            }
        });
    }

    public synchronized void displaySource(Object context, IWorkbenchPage page, boolean force) {
        JSDebugScriptElement script = (JSDebugScriptElement)context;
        if (!force && this.fPrevScript != null && script.getLocation().equals(this.fPrevScript.getLocation())) {
            if (!script.equals(this.fPrevScript)) {
                this.fPrevResult.updateArtifact((Object)script);
            }
            this.fSourceDisplayJob.setDisplayInfo((ISourceLookupResult)this.fPrevResult, page);
            this.fSourceDisplayJob.schedule();
        } else {
            this.fSourceLookupJob.setLookupInfo(script, page);
            this.fSourceLookupJob.schedule();
        }
    }

    private void clearSourceSelection(Object source) {
    }

    private synchronized void clearCachedModel(Object source) {
        if (this.fPrevScript != null) {
            IDebugTarget target = null;
            if (source instanceof IDebugElement) {
                target = ((IDebugElement)source).getDebugTarget();
            }
            if (this.fPrevScript.getDebugTarget().equals(target)) {
                this.fPrevScript = null;
                this.fPrevResult = null;
            }
        }
    }

    private void revealLineInEditor(ITextEditor editor, int lineNumber) {
        IRegion region;
        block9: {
            --lineNumber;
            region = null;
            IDocumentProvider provider = editor.getDocumentProvider();
            IEditorInput input = editor.getEditorInput();
            try {
                provider.connect((Object)input);
            }
            catch (CoreException coreException) {
                return;
            }
            try {
                try {
                    IDocument document = provider.getDocument((Object)input);
                    if (document != null) {
                        region = document.getLineInformation(lineNumber);
                    }
                }
                catch (BadLocationException badLocationException) {
                    provider.disconnect((Object)input);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                provider.disconnect((Object)input);
                throw throwable;
            }
            provider.disconnect((Object)input);
        }
        if (region != null) {
            editor.selectAndReveal(region.getOffset(), 0);
        }
    }

    class SourceDisplayJob
    extends UIJob {
        private ISourceLookupResult fResult;
        private IWorkbenchPage fPage;
        protected SourceDisplayUtil sourceDisplayUtil;

        public SourceDisplayJob() {
            super("Debug Source Display");
            this.sourceDisplayUtil = new DebuggerSourceDisplayUtil();
            this.setSystem(true);
            this.setPriority(10);
        }

        public synchronized void setDisplayInfo(ISourceLookupResult result, IWorkbenchPage page) {
            this.fResult = result;
            this.fPage = page;
        }

        public synchronized IStatus runInUIThread(IProgressMonitor monitor) {
            if (!monitor.isCanceled()) {
                try {
                    this.sourceDisplayUtil.openInEditor(this.fPage, this.fResult.getEditorInput(), ((JSDebugScriptElement)this.fResult.getArtifact()).getLineStart());
                }
                catch (PartInitException e) {
                    MozillaDebugUIPlugin.log(e);
                }
            }
            return Status.OK_STATUS;
        }
    }

    class SourceLookupJob
    extends Job {
        private JSDebugScriptElement fTarget;
        private IWorkbenchPage fPage;
        protected SourceLocatorUtil locatorUtil;
        protected SourceDisplayUtil sourceDisplayUtil;

        public SourceLookupJob() {
            super("Debug Source Lookup");
            this.locatorUtil = SourceLocatorUtil.getInstance();
            this.sourceDisplayUtil = new DebuggerSourceDisplayUtil();
            this.setPriority(10);
            this.setSystem(true);
        }

        public void setLookupInfo(JSDebugScriptElement script, IWorkbenchPage page) {
            this.fTarget = script;
            this.fPage = page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            block7: {
                if (!monitor.isCanceled()) {
                    JSDebugScriptElement lookupScript = this.fTarget;
                    String location = lookupScript.getLocation();
                    try {
                        if (location == null) break block7;
                        URL locationURL = new URL(location);
                        String appBase = ((JSSourceLocator)lookupScript.getLaunch().getSourceLocator()).getAppBase();
                        IProject project = ((JSSourceLocator)lookupScript.getLaunch().getSourceLocator()).getProject();
                        IStorage sourceElement = this.locatorUtil.getSourceElement(locationURL, appBase, project);
                        IEditorInput editorInput = this.sourceDisplayUtil.getEditorInput((Object)sourceElement);
                        String editorId = this.sourceDisplayUtil.getEditorId(editorInput, (Object)sourceElement);
                        SourceLookupResult result = new SourceLookupResult((Object)lookupScript, (Object)sourceElement, editorId, editorInput);
                        JSDebugScriptElementSourceDisplayAdapter jSDebugScriptElementSourceDisplayAdapter = JSDebugScriptElementSourceDisplayAdapter.this;
                        synchronized (jSDebugScriptElementSourceDisplayAdapter) {
                            JSDebugScriptElementSourceDisplayAdapter.this.fPrevResult = result;
                            JSDebugScriptElementSourceDisplayAdapter.this.fPrevScript = lookupScript;
                        }
                        if (!monitor.isCanceled()) {
                            JSDebugScriptElementSourceDisplayAdapter.this.fSourceDisplayJob.setDisplayInfo((ISourceLookupResult)result, this.fPage);
                            JSDebugScriptElementSourceDisplayAdapter.this.fSourceDisplayJob.schedule();
                        }
                    }
                    catch (MalformedURLException mue) {
                        Status status = new Status(4, "org.eclipse.atf.mozilla.ide.debug", 120, "Invalid URL supplied by Mozilla.  Unable to open source.", (Throwable)mue);
                        DebugPlugin.log((IStatus)status);
                    }
                }
            }
            return Status.OK_STATUS;
        }
    }
}

