/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui.scriptview;

import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugElement;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugThread;
import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.internal.ui.contexts.DebugContextManager;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.PresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.contexts.DebugContextEvent;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.debug.ui.sourcelookup.ISourceDisplay;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class ScriptView
extends AbstractDebugView
implements IDebugContextListener {
    public static final String ID = "org.eclipse.atf.mozilla.ide.debug.ui.scriptview";

    protected Viewer createViewer(Composite parent) {
        DebugContextManager.getDefault().addDebugContextListener((IDebugContextListener)this);
        TreeModelViewer treeViewer = new TreeModelViewer(parent, 268501762, (IPresentationContext)new PresentationContext(ID));
        this.configureDblClickBehavior((TreeViewer)treeViewer);
        return treeViewer;
    }

    protected void configureToolBar(IToolBarManager tbm) {
    }

    protected void createActions() {
    }

    protected void fillContextMenu(IMenuManager menu) {
    }

    protected String getHelpContextId() {
        return null;
    }

    protected void configureDblClickBehavior(TreeViewer treeViewer) {
        treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IAdaptable adaptable;
                ISourceDisplay adapter;
                Object selectedObject;
                ISelection selection = event.getSelection();
                if (!selection.isEmpty() && selection instanceof StructuredSelection && (selectedObject = ((StructuredSelection)selection).getFirstElement()) instanceof IAdaptable && (adapter = (ISourceDisplay)(adaptable = (IAdaptable)selectedObject).getAdapter(ISourceDisplay.class)) != null) {
                    adapter.displaySource(selectedObject, ScriptView.this.getSite().getPage(), true);
                }
            }
        });
    }

    public void dispose() {
        DebugContextManager.getDefault().removeDebugContextListener((IDebugContextListener)this);
        super.dispose();
    }

    protected void becomesHidden() {
        this.setViewerInput(null);
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        ISelection selection = DebugContextManager.getDefault().getContextService(this.getSite().getWorkbenchWindow()).getActiveContext();
        Object contextElement = this.extractDebugElement(selection);
        this.setViewerInput(contextElement);
    }

    protected void setViewerInput(Object context) {
        if (context == null) {
            this.showViewer();
            this.getViewer().setInput(null);
        } else if (context instanceof JSDebugElement) {
            JSDebugThread thread;
            Object currentThread = this.getViewer().getInput();
            try {
                thread = this.findJSDebugThread((JSDebugElement)context);
            }
            catch (DebugException e) {
                MozillaDebugUIPlugin.log((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", "ScriptView could not locate the JavaScript Thread from selection... <" + e.getMessage() + ">!", (Throwable)e));
                this.showMessage("ScriptView could not locate the JavaScript Thread from selection...");
                return;
            }
            if (thread != currentThread) {
                this.getViewer().setInput((Object)thread);
            }
            this.showViewer();
            this.getViewer().refresh();
        }
    }

    protected JSDebugThread findJSDebugThread(JSDebugElement selectedElement) throws DebugException {
        ILaunch launch = selectedElement.getLaunch();
        if (!launch.isTerminated()) {
            return (JSDebugThread)launch.getDebugTarget().getThreads()[0];
        }
        return null;
    }

    public void debugContextChanged(DebugContextEvent event) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if ((event.getFlags() & 1) != 0) {
            Object contextElement = this.extractDebugElement(event.getContext());
            if (contextElement instanceof JSDebugElement) {
                this.setViewerInput(contextElement);
            } else {
                this.showMessage("View only valid for Browser Debug context.");
            }
        }
    }

    protected Object extractDebugElement(ISelection selection) {
        Object debugElement = null;
        if (selection instanceof IStructuredSelection) {
            debugElement = ((IStructuredSelection)selection).getFirstElement();
        }
        return debugElement;
    }
}

