/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui.watch;

import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugStackFrame;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IWatchExpressionDelegate;
import org.eclipse.debug.core.model.IWatchExpressionListener;
import org.eclipse.debug.core.model.IWatchExpressionResult;

public class WatchExpressionDelegate
implements IWatchExpressionDelegate {
    private Job fRunDispatch;

    public void evaluateExpression(String expression, IDebugElement context, IWatchExpressionListener listener) {
        IStackFrame frame = null;
        if (context instanceof IStackFrame) {
            frame = (IStackFrame)context;
        } else if (context instanceof IThread) {
            try {
                frame = ((IThread)context).getTopStackFrame();
            }
            catch (DebugException debugException) {}
        }
        if (frame == null) {
            listener.watchEvaluationFinished(null);
        } else if (frame instanceof JSDebugStackFrame) {
            this.fRunDispatch = new EvaluationRunnable(expression, listener, (JSDebugStackFrame)frame);
            this.fRunDispatch.schedule();
        } else {
            listener.watchEvaluationFinished(null);
        }
    }

    private final class EvaluationRunnable
    extends Job {
        private String fExpressionText;
        private IWatchExpressionListener fListener;
        private JSDebugStackFrame fFrame;
        private boolean fHasErrors;
        private String[] fErrorMessage;

        public EvaluationRunnable(String expressionText, IWatchExpressionListener listener, JSDebugStackFrame frame) {
            super("EvaluationRunnable");
            this.setSystem(true);
            this.fExpressionText = expressionText;
            this.fListener = listener;
            this.fFrame = frame;
            this.fHasErrors = false;
            this.fErrorMessage = null;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                final IValue value = this.fFrame.eval(this.fExpressionText);
                IWatchExpressionResult watchResult = new IWatchExpressionResult(){

                    public IValue getValue() {
                        return value;
                    }

                    public boolean hasErrors() {
                        return EvaluationRunnable.this.fHasErrors;
                    }

                    public String[] getErrorMessages() {
                        return EvaluationRunnable.this.fErrorMessage;
                    }

                    public String getExpressionText() {
                        return EvaluationRunnable.this.fExpressionText;
                    }

                    public DebugException getException() {
                        return null;
                    }
                };
                this.fListener.watchEvaluationFinished(watchResult);
            }
            catch (Exception exception) {
                this.fListener.watchEvaluationFinished(null);
            }
            DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{new DebugEvent((Object)WatchExpressionDelegate.this, 2, 128)});
            return Status.OK_STATUS;
        }
    }
}

