/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.ui.debug;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.atf.mozilla.ide.core.IXPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.debug.INestedEventLoop;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTarget;
import org.eclipse.atf.mozilla.ide.ui.XPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.ui.browser.MozBrowserProcess;
import org.eclipse.atf.mozilla.ide.ui.browser.util.MozBrowserUtil;
import org.eclipse.atf.mozilla.ide.ui.internal.browser.support.InternalWebBrowser;
import org.eclipse.atf.mozilla.ide.ui.internal.browser.support.WorkbenchBrowserSupport;
import org.eclipse.atf.ui.debug.NestedEventLoop;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.progress.UIJob;

public class MozillaLaunchJob
extends UIJob {
    protected ILaunch launch;
    protected URL url;

    public MozillaLaunchJob(String name, ILaunch launch, URL url) {
        super(name);
        this.launch = launch;
        this.url = url;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        IStatus status = Status.OK_STATUS;
        try {
            this.launchApp();
        }
        catch (Exception e) {
            status = new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", 0, "Error launching Mozilla application in debug mode", (Throwable)e);
        }
        return status;
    }

    protected void launchApp() throws CoreException {
        boolean useInternalBrowser = this.launch.getLaunchConfiguration().getAttribute("org.eclipse.atf.config.isinternalbrowser", true);
        if (useInternalBrowser) {
            this.launchInternalBrowser();
        } else {
            this.launchExternalBrowser();
        }
    }

    private void launchExternalBrowser() throws CoreException {
        String browserExec = this.launch.getLaunchConfiguration().getAttribute("org.eclipse.atf.ui.debug.browserexec", "");
        String[] args = new String[]{browserExec, this.url.toString()};
        String[] args2 = new String[]{browserExec, "-venkman"};
        try {
            Process myProcess = Runtime.getRuntime().exec(args);
            String myLabel = this.url.toExternalForm();
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(IProcess.ATTR_PROCESS_TYPE, this.getName());
            attrs.put(IProcess.ATTR_PROCESS_LABEL, String.valueOf(this.getName()) + " Application");
            DebugPlugin.newProcess((ILaunch)this.launch, (Process)myProcess, (String)myLabel, attrs);
            Runtime.getRuntime().exec(args2);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug.ui", 0, "Error launching application", (Throwable)e));
        }
    }

    private void launchInternalBrowser() throws CoreException, DebugException {
        org.eclipse.atf.mozilla.ide.common.IWebBrowser webBrowser = this.getBrowser();
        if ("debug".equals(this.launch.getLaunchMode())) {
            this.configureJSDebugTarget(webBrowser);
        }
        if ("run".equals(this.launch.getLaunchMode())) {
            MozBrowserUtil.openMozillaPerspective();
        }
    }

    private org.eclipse.atf.mozilla.ide.common.IWebBrowser getBrowser() throws CoreException {
        IWebBrowser browser;
        String browserId = this.launch.getLaunchConfiguration().getAttribute("org.eclipse.atf.ui.debug.pickBrowser", null);
        org.eclipse.atf.mozilla.ide.common.IWebBrowser webBrowser = null;
        if (browserId != null && (browser = WorkbenchBrowserSupport.getInstance().getBrowser(browserId)) != null && browser instanceof InternalWebBrowser) {
            webBrowser = ((InternalWebBrowser)browser).getWebBrowser();
        }
        if (webBrowser == null) {
            webBrowser = MozBrowserUtil.openMozillaBrowser((String)this.url.toString());
        }
        return webBrowser;
    }

    private void configureJSDebugTarget(org.eclipse.atf.mozilla.ide.common.IWebBrowser webBrowser) throws CoreException, DebugException {
        String appPath = this.launch.getLaunchConfiguration().getAttribute("org.eclipse.atf.config.appPath", null);
        String projectName = this.launch.getLaunchConfiguration().getAttribute("org.eclipse.atf.config.project", null);
        IProject project = null;
        if (projectName != null && !projectName.equals("")) {
            project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        Display display = Display.getDefault();
        XPCOMThreadProxyHelper proxyHelper = new XPCOMThreadProxyHelper(display);
        NestedEventLoop eventLoop = new NestedEventLoop(display);
        JSDebugTarget debugTarget = (JSDebugTarget)MozillaDebugPlugin.launchDebugTarget((ILaunch)this.launch, (URL)this.url, (IProject)project, (String)appPath, (INestedEventLoop)eventLoop, (IXPCOMThreadProxyHelper)proxyHelper);
        this.launch.addDebugTarget((IDebugTarget)debugTarget);
        debugTarget.setProcess((IProcess)new MozBrowserProcess(webBrowser, this.launch));
    }
}

