/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.compatibility.jsdt.debug.ui.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.atf.compatibility.jsdt.Activator;
import org.eclipse.atf.compatibility.jsdt.debug.ui.actions.ActionMessages;
import org.eclipse.atf.compatibility.jsdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.atf.mozilla.ide.debug.model.JSLineBreakpoint;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.Flags;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.ui.IWorkingCopyManager;
import org.eclipse.wst.jsdt.ui.JavaScriptUI;

public class ToggleBreakpointAdapter
implements IToggleBreakpointsTargetExtension {
    private static final String EMPTY_STRING = "";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;

    protected void report(final String message, final IWorkbenchPart part) {
        Activator.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IEditorStatusLine statusLine;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((statusLine = (IEditorStatusLine)part.getAdapter((Class)clazz)) != null) {
                    if (message != null) {
                        statusLine.setMessage(true, message, null);
                    } else {
                        statusLine.setMessage(true, null, null);
                    }
                }
                if (message != null && Activator.getActiveWorkbenchShell() != null) {
                    Activator.getActiveWorkbenchShell().getDisplay().beep();
                }
            }
        });
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, false);
    }

    public void toggleLineBreakpoints(final IWorkbenchPart part, final ISelection selection, boolean bestMatch) {
        Job job = new Job("Toggle Line Breakpoint"){

            protected IStatus run(IProgressMonitor monitor) {
                ITextEditor editor = ToggleBreakpointAdapter.this.getTextEditor(part);
                if (editor != null && selection instanceof ITextSelection) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    try {
                        IDocument document;
                        HashMap attributes;
                        int lnumber;
                        ToggleBreakpointAdapter.this.report(null, part);
                        ISelection sel = selection;
                        if (!(selection instanceof IStructuredSelection)) {
                            sel = ToggleBreakpointAdapter.this.translateToMembers(part, selection);
                        }
                        if (sel instanceof IStructuredSelection) {
                            IJavaScriptElement member = (IJavaScriptElement)((IStructuredSelection)sel).getFirstElement();
                            String tname = ToggleBreakpointAdapter.this.createQualifiedTypeName(member);
                            IResource resource = BreakpointUtils.getBreakpointResource(member);
                            JSLineBreakpoint existingBreakpoint = BreakpointUtils.lineBreakpointExists(resource, tname, lnumber = ((ITextSelection)selection).getStartLine() + 1);
                            if (existingBreakpoint != null) {
                                DebugPlugin.getDefault().getBreakpointManager().removeBreakpoint((IBreakpoint)existingBreakpoint, true);
                                return Status.OK_STATUS;
                            }
                            attributes = new HashMap(10);
                            IDocumentProvider documentProvider = editor.getDocumentProvider();
                            if (documentProvider == null) {
                                return Status.CANCEL_STATUS;
                            }
                            document = documentProvider.getDocument((Object)editor.getEditorInput());
                            try {
                                IRegion line = document.getLineInformation(lnumber - 1);
                                int start = line.getOffset();
                                int end = start + line.getLength() - 1;
                                BreakpointUtils.addJavaBreakpointAttributesWithMemberDetails(attributes, member, start, end);
                            }
                            catch (BadLocationException ble) {
                                Activator.log(ble);
                            }
                        } else {
                            ToggleBreakpointAdapter.this.report(ActionMessages.ToggleBreakpointAdapter_3, part);
                            return Status.OK_STATUS;
                        }
                        BreakpointUtils.createLineBreakpoint(document, editor.getEditorInput(), lnumber, -1, -1, 0, true, attributes);
                    }
                    catch (CoreException ce) {
                        return ce.getStatus();
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        return selection instanceof ITextSelection;
    }

    private String createQualifiedTypeName(IJavaScriptElement type) {
        ITypeRoot typeRoot = type instanceof IMember ? ((IMember)type).getTypeRoot() : (ITypeRoot)type;
        String tname = typeRoot.getElementName();
        type.getJavaScriptProject().exists();
        return tname;
    }

    private IJavaScriptElement getJavaElement(IEditorInput input) {
        IJavaScriptElement je = JavaScriptUI.getEditorInputJavaElement((IEditorInput)input);
        if (je != null) {
            return je;
        }
        return ((WorkingCopyManager)JavaScriptUI.getWorkingCopyManager()).getWorkingCopy(input, false);
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.getMethods(ss).length > 0;
        }
        return selection instanceof ITextSelection && this.isMethod((ITextSelection)selection, part);
    }

    protected boolean isRemote(IWorkbenchPart part, ISelection selection) {
        IStructuredSelection ss;
        Object element;
        if (selection instanceof IStructuredSelection && (element = (ss = (IStructuredSelection)selection).getFirstElement()) instanceof IMember) {
            IMember member = (IMember)element;
            return !member.getJavaScriptProject().getProject().exists();
        }
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null) {
            IEditorInput input = editor.getEditorInput();
            Object adapter = Platform.getAdapterManager().getAdapter((Object)input, "org.eclipse.team.core.history.IFileRevision");
            return adapter != null;
        }
        return false;
    }

    protected ITextEditor getTextEditor(IWorkbenchPart part) {
        if (part instanceof ITextEditor) {
            return (ITextEditor)part;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ITextEditor)part.getAdapter((Class)clazz);
    }

    protected IFunction[] getMethods(IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return new IFunction[0];
        }
        ArrayList<IFunction> methods = new ArrayList<IFunction>(selection.size());
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object thing = iterator.next();
            try {
                IFunction method;
                if (!(thing instanceof IFunction) || Flags.isAbstract((int)(method = (IFunction)thing).getFlags())) continue;
                methods.add(method);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return methods.toArray(new IFunction[methods.size()]);
    }

    private boolean isMethod(ITextSelection selection, IWorkbenchPart part) {
        IJavaScriptElement element;
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null && (element = this.getJavaElement(editor.getEditorInput())) != null) {
            try {
                if (element instanceof IJavaScriptUnit) {
                    element = ((IJavaScriptUnit)element).getElementAt(selection.getOffset());
                } else if (element instanceof IClassFile) {
                    element = ((IClassFile)element).getElementAt(selection.getOffset());
                }
                return element != null && element.getElementType() == 9;
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return false;
            }
        }
        return false;
    }

    protected List getFields(IStructuredSelection selection) throws CoreException {
        if (selection.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList fields = new ArrayList(selection.size());
        Iterator iterator = selection.iterator();
        while (iterator.hasNext()) {
            Object thing = iterator.next();
            if (!(thing instanceof IField)) continue;
            fields.add(thing);
        }
        return fields;
    }

    private boolean isInterface(ISelection selection, IWorkbenchPart part) {
        return false;
    }

    private boolean isField(ITextSelection selection, IWorkbenchPart part) {
        IJavaScriptElement element;
        ITextEditor editor = this.getTextEditor(part);
        if (editor != null && (element = this.getJavaElement(editor.getEditorInput())) != null) {
            try {
                if (element instanceof IJavaScriptUnit) {
                    element = ((IJavaScriptUnit)element).getElementAt(selection.getOffset());
                } else if (element instanceof IClassFile) {
                    element = ((IClassFile)element).getElementAt(selection.getOffset());
                }
                return element != null && element.getElementType() == 8;
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return false;
            }
        }
        return false;
    }

    private boolean isFields(IStructuredSelection selection) {
        Iterator iterator;
        if (!selection.isEmpty() && (iterator = selection.iterator()).hasNext()) {
            Object thing = iterator.next();
            return thing instanceof IField;
        }
        return false;
    }

    protected static IResource getResource(IEditorPart editor) {
        IResource resource;
        IEditorInput editorInput = editor.getEditorInput();
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resource = (IResource)editorInput.getAdapter((Class)clazz)) == null) {
            resource = ResourcesPlugin.getWorkspace().getRoot();
        }
        return resource;
    }

    protected IFunction getMethodHandle(IEditorPart editorPart, String typeName, String methodName, String signature) throws CoreException {
        IEditorInput iEditorInput = editorPart.getEditorInput();
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("org.eclipse.wst.jsdt.core.IJavaScriptElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IJavaScriptElement element = (IJavaScriptElement)iEditorInput.getAdapter((Class)clazz);
        IType type = null;
        if (element instanceof IJavaScriptUnit) {
            IType[] types = ((IJavaScriptUnit)element).getAllTypes();
            int i = 0;
            while (i < types.length) {
                if (types[i].getFullyQualifiedName().equals(typeName)) {
                    type = types[i];
                    break;
                }
                ++i;
            }
        } else if (element instanceof IClassFile) {
            type = ((IClassFile)element).getType();
        }
        if (type != null) {
            String[] sigs = Signature.getParameterTypes((String)signature);
            return type.getFunction(methodName, sigs);
        }
        return null;
    }

    protected JavaScriptUnit parseCompilationUnit(ITextEditor editor) throws CoreException {
        IEditorInput editorInput = editor.getEditorInput();
        IDocumentProvider documentProvider = editor.getDocumentProvider();
        if (documentProvider == null) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        IDocument document = documentProvider.getDocument((Object)editorInput);
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(document.get().toCharArray());
        return (JavaScriptUnit)parser.createAST(null);
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            return this.isFields(ss);
        }
        return selection instanceof ITextSelection && this.isField((ITextSelection)selection, part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISelection translateToMembers(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getTextEditor(part);
        if (textEditor != null && selection instanceof ITextSelection) {
            IClassFile classFile;
            ITextSelection textSelection = (ITextSelection)selection;
            IEditorInput editorInput = textEditor.getEditorInput();
            IDocumentProvider documentProvider = textEditor.getDocumentProvider();
            if (documentProvider == null) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            IDocument document = documentProvider.getDocument((Object)editorInput);
            int offset = textSelection.getOffset();
            if (document != null) {
                try {
                    IRegion region = document.getLineInformationOfOffset(offset);
                    int end = region.getOffset() + region.getLength();
                    while (Character.isWhitespace(document.getChar(offset)) && offset < end) {
                        ++offset;
                    }
                }
                catch (BadLocationException badLocationException) {}
            }
            Object m = null;
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("org.eclipse.wst.jsdt.core.IClassFile");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((classFile = (IClassFile)editorInput.getAdapter((Class)clazz)) != null) {
                IJavaScriptElement e = classFile.getElementAt(offset);
                m = e instanceof IMember ? (IMember)e : classFile;
            } else {
                IJavaScriptUnit iJavaScriptUnit;
                IWorkingCopyManager manager = JavaScriptUI.getWorkingCopyManager();
                IJavaScriptUnit unit = manager.getWorkingCopy(editorInput);
                if (unit != null) {
                    iJavaScriptUnit = unit;
                    synchronized (iJavaScriptUnit) {
                        unit.reconcile(0, false, null, null);
                    }
                }
                unit = ((WorkingCopyManager)JavaScriptUI.getWorkingCopyManager()).getWorkingCopy(editorInput, false);
                if (unit != null) {
                    iJavaScriptUnit = unit;
                    synchronized (iJavaScriptUnit) {
                        unit.reconcile(0, false, null, null);
                    }
                }
                IJavaScriptElement e = unit.getElementAt(offset);
                m = e instanceof IMember ? (IMember)e : unit;
            }
            if (m != null) {
                return new StructuredSelection(m);
            }
        }
        return selection;
    }

    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection, true);
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        if (this.isRemote(part, selection)) {
            return false;
        }
        return this.canToggleLineBreakpoints(part, selection);
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }
}

