/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug;

import java.net.URL;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.atf.mozilla.ide.core.IXPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.debug.INestedEventLoop;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTarget;
import org.eclipse.atf.mozilla.ide.debug.model.JSSourceLocator;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventAdmin;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.mozilla.interfaces.jsdIDebuggerService;
import org.mozilla.interfaces.nsIObserver;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class MozillaDebugPlugin
extends Plugin {
    public static boolean logging = false;
    public static boolean events = false;
    public static String DBG = null;
    public static String EVT = null;
    public static String ERR = null;
    public static final int ERROR_STATUS = 100;
    public static final String PLUGIN_ID = "org.eclipse.atf.mozilla.ide.debug";
    public static final String DEBUG_MODEL_ID = "org.eclipse.atf.mozilla.ide.debug";
    public static final String DEBUG_JSDCALLHOOK = "org.eclipse.atf.mozilla.ide.debug/jsdCallHook";
    public static final String DEBUG_JSDSCRIPTHOOK = "org.eclipse.atf.mozilla.ide.debug/jsdScriptHook";
    private static MozillaDebugPlugin _plugin;
    private ResourceBundle _resourceBundle;
    private ServiceTracker appEventAdmTracker;
    private static IDebugTarget _debugTarget;
    private static DebugException _debugException;

    public MozillaDebugPlugin() {
        _plugin = this;
        try {
            this._resourceBundle = ResourceBundle.getBundle("org.eclipse.atf.mozilla.ide.debug.DebugPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this._resourceBundle = null;
        }
        if (this.isDebugging()) {
            String id = "org.eclipse.atf.mozilla.ide.debug";
            String test = Platform.getDebugOption((String)(String.valueOf(id) + "/debug/events"));
            if (test != null) {
                events = test.equals("true");
            }
            if ((test = Platform.getDebugOption((String)(String.valueOf(id) + "/debug/logging"))) != null) {
                logging = test.equals("true");
            }
            if ((test = Platform.getDebugOption((String)(String.valueOf(id) + "/debug/dbg"))) != null) {
                DBG = test;
            }
            if ((test = Platform.getDebugOption((String)(String.valueOf(id) + "/debug/evt"))) != null) {
                EVT = test;
            }
            if ((test = Platform.getDebugOption((String)(String.valueOf(id) + "/debug/err"))) != null) {
                ERR = test;
            }
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        ServiceReference reference = context.getServiceReference(IApplicationEventAdmin.class.getName());
        this.appEventAdmTracker = new ServiceTracker(context, reference, null);
        this.appEventAdmTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        this.appEventAdmTracker.close();
        super.stop(context);
        _plugin = null;
    }

    public static MozillaDebugPlugin getDefault() {
        return _plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MozillaDebugPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }

    public static jsdIDebuggerService createDebuggerService() throws DebugException {
        jsdIDebuggerService debuggerService;
        try {
            Mozilla browser = Mozilla.getInstance();
            debuggerService = (jsdIDebuggerService)browser.getServiceManager().getServiceByContractID("@mozilla.org/js/jsd/debugger-service;1", "{dc0a24db-f8ac-4889-80d0-6016545a2dda}");
            String jsdObserverCID = "2fd6b7f6-eb8c-4f32-ad26-113f2c02d0fe";
            nsIObserver jsdObserver = (nsIObserver)Mozilla.getInstance().getComponentManager().createInstance(jsdObserverCID, null, "{db242e01-e4d9-11d2-9dde-000064657374}");
            jsdObserver.observe(null, "", "");
        }
        catch (XPCOMException xpcome) {
            throw new DebugException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug", 5013, "Error initializing debugger service", (Throwable)xpcome));
        }
        MozillaDebugPlugin.debug("Mozilla JS Debugger: " + debuggerService.getImplementationString());
        MozillaDebugPlugin.debug("Is on:" + debuggerService.getIsOn());
        if (MozillaDebugPlugin.compareVersion(debuggerService, 1, 2) >= 0) {
            debuggerService.setFlags(64L);
        }
        return debuggerService;
    }

    public static synchronized IDebugTarget launchDebugTarget(final ILaunch launch, final URL appURL, IProject project, String appPath, final INestedEventLoop eventLoop, final IXPCOMThreadProxyHelper proxyHelper) throws DebugException {
        ISourceLocator locator = launch.getSourceLocator();
        if (locator != null && locator instanceof JSSourceLocator) {
            JSSourceLocator jslocator = (JSSourceLocator)locator;
            jslocator.setAppBase(appURL.toString());
        }
        proxyHelper.syncExec(new Runnable(){

            public void run() {
                try {
                    _debugTarget = new JSDebugTarget(launch, appURL, eventLoop, proxyHelper);
                }
                catch (DebugException de) {
                    _debugException = de;
                }
            }
        });
        if (_debugException != null) {
            throw _debugException;
        }
        return _debugTarget;
    }

    public static int compareVersion(jsdIDebuggerService debuggerService, int maj, int min) {
        if (debuggerService.getImplementationMajor() < (long)maj) {
            return -1;
        }
        if (debuggerService.getImplementationMajor() > (long)maj) {
            return 1;
        }
        if (debuggerService.getImplementationMinor() < (long)min) {
            return -1;
        }
        if (debuggerService.getImplementationMinor() > (long)min) {
            return 1;
        }
        return 0;
    }

    public static void log(Throwable t) {
        MozillaDebugPlugin.log((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug", t.getMessage(), t));
    }

    public static void log(String message) {
        MozillaDebugPlugin.log((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug", message, (Throwable)new Exception()));
    }

    public static void log(IStatus status) {
        MozillaDebugPlugin.getDefault().getLog().log(status);
    }

    public static void debug(String message) {
        if (MozillaDebugPlugin.getDefault().isDebugging()) {
            MozillaDebugPlugin.log(message);
        }
    }

    public static void debug(String key, String message) {
        String debug;
        if (MozillaDebugPlugin.getDefault().isDebugging() && (debug = Platform.getDebugOption((String)key)) != null && Boolean.parseBoolean(debug)) {
            MozillaDebugPlugin.log(message);
        }
    }

    public boolean isProfiling() {
        return false;
    }

    public IApplicationEventAdmin getApplicationEventAdmin() {
        return (IApplicationEventAdmin)this.appEventAdmTracker.getService();
    }
}

