/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.internal.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugElement;
import org.eclipse.atf.mozilla.ide.debug.model.IJSDebugScriptElement;
import org.eclipse.debug.core.model.IDebugTarget;

public class JSDebugScriptElement
extends JSDebugElement
implements IJSDebugScriptElement {
    public static final String UNNAMED = "__unnamed__";
    public static final String ANONYMOUS = "anonymous";
    protected String name = "__unnamed__";
    protected IJSDebugScriptElement parent = null;
    protected List children = new ArrayList();
    protected int lineStart = 0;
    protected int lineTotal = 0;

    public JSDebugScriptElement(IDebugTarget target) {
        super(target);
    }

    public String getName() {
        return this.name;
    }

    public String getLocation() {
        if (this.parent != null) {
            return this.parent.getLocation();
        }
        return UNNAMED;
    }

    public IJSDebugScriptElement getParent() {
        return this.parent;
    }

    public List getChildren() {
        return this.children;
    }

    public int getLineStart() {
        return this.lineStart;
    }

    public int getLineTotal() {
        return this.lineTotal;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setParent(IJSDebugScriptElement parent) {
        this.parent = parent;
    }

    public void setLineStart(int lineStart) {
        this.lineStart = lineStart;
    }

    public void setLineTotal(int lineTotal) {
        this.lineTotal = lineTotal;
    }

    public void insert(JSDebugScriptElement scriptElement) {
        this.insertAfter(scriptElement, -1);
    }

    protected void insertAfter(JSDebugScriptElement scriptElement, int idx) {
        if (this == scriptElement) {
            return;
        }
        ArrayList<JSDebugScriptElement> childrenToRemove = new ArrayList<JSDebugScriptElement>();
        int i = 0;
        Iterator iter = this.children.iterator();
        while (iter.hasNext()) {
            if (i <= idx) break;
            JSDebugScriptElement child = (JSDebugScriptElement)iter.next();
            if (child.isScriptElementInside(scriptElement)) {
                child.insert(scriptElement);
                return;
            }
            if (scriptElement.isScriptElementInside(child)) {
                scriptElement.insert(child);
                childrenToRemove.add(child);
            }
            ++i;
        }
        this.children.add(scriptElement);
        scriptElement.setParent(this);
        this.fixLineInfo(scriptElement);
        for (JSDebugScriptElement child : childrenToRemove) {
            this.children.remove(child);
        }
    }

    protected boolean isScriptElementInside(JSDebugScriptElement scriptElement) {
        return this.getLineStart() <= scriptElement.getLineStart() && this.getLineStart() + this.getLineTotal() - 1 >= scriptElement.getLineStart();
    }

    protected void fixLineInfo(JSDebugScriptElement childElement) {
        if (childElement.getLineStart() + childElement.getLineTotal() > this.lineStart + this.lineTotal) {
            this.lineTotal = childElement.getLineStart() + childElement.getLineTotal();
        }
    }

    public String getLabel() {
        return this.getName();
    }

    public String toString() {
        return "scriptelement location<" + this.getLocation() + "> name<" + this.getName() + "> start<" + this.getLineStart() + "> total<" + this.getLineTotal() + ">";
    }
}

