/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.internal.model;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.eclipse.atf.mozilla.ide.core.IXPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.core.XPCOMThreadProxy;
import org.eclipse.atf.mozilla.ide.core.util.SourceLocatorUtil;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugElementWithVariables;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTarget;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugThread;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugVariable;
import org.eclipse.atf.mozilla.ide.debug.model.JSSourceLocator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.mozilla.interfaces.jsdIProperty;
import org.mozilla.interfaces.jsdIScript;
import org.mozilla.interfaces.jsdIStackFrame;
import org.mozilla.interfaces.jsdIValue;
import org.mozilla.interfaces.nsISupports;

public class JSDebugStackFrame
extends JSDebugElementWithVariables
implements IStackFrame {
    private IThread _thread;
    private jsdIStackFrame _frameProxy;
    private boolean _initializedVars = false;
    private String _label;
    private int _line = -1;
    private long _lastpc = -1L;
    private int _depth;
    private String _location;
    private String _function;
    private IPath _relativePath;
    private String _displayFunction;
    private long _tag;
    private boolean _topLevelStart;
    private final Pattern _propertyPattern = Pattern.compile("(\\w+)\\s*[:=]\\s*$");

    public JSDebugStackFrame(IDebugTarget target, IThread thread, jsdIStackFrame frame, int depth, boolean topLevelStart) {
        super(target);
        this._thread = thread;
        this._depth = depth;
        this._topLevelStart = topLevelStart;
        this._displayFunction = !topLevelStart ? (this._function = frame.getFunctionName()) : (this._function = "Suspended at start");
        jsdIScript script = frame.getScript();
        if (script != null) {
            String guess;
            this._location = script.getFileName();
            if (this._location != null) {
                JSSourceLocator locator = (JSSourceLocator)this.getDebugTarget().getLaunch().getSourceLocator();
                this._relativePath = locator.getContentRelativePath(this._location);
            }
            this._tag = script.getTag();
            if ("anonymous".equals(this._function) && (guess = this.guessFunction(script)) != null) {
                this._displayFunction = "[" + guess + "]";
            }
        }
        this.validate(frame);
    }

    private InputStream getScriptContents() throws CoreException {
        String location = this.getLocation();
        try {
            if (location != null) {
                URL locationURL = new URL(location);
                String appBase = ((JSSourceLocator)this.getLaunch().getSourceLocator()).getAppBase();
                IProject project = ((JSSourceLocator)this.getLaunch().getSourceLocator()).getProject();
                return SourceLocatorUtil.getInstance().getSourceContent(locationURL, appBase, project);
            }
        }
        catch (MalformedURLException mue) {
            Status status = new Status(4, "org.eclipse.atf.mozilla.ide.debug", 120, "Invalid URL supplied by Mozilla.  Unable to open source.", (Throwable)mue);
            DebugPlugin.log((IStatus)status);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug", 120, "Incorrect URL <" + location + ">", (Throwable)mue));
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    private String guessFunction(jsdIScript script) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 21[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeVars() throws DebugException {
        IThread iThread = this._thread;
        synchronized (iThread) {
            if (this._initializedVars) {
                return;
            }
            if (this._frameProxy == null) {
                return;
            }
            try {
                jsdIValue thisValue = this._frameProxy.getThisValue();
                jsdIValue scopeValue = this._frameProxy.getScope();
                if (thisValue != null) {
                    JSDebugVariable thisVar = new JSDebugVariable(this.getDebugTarget(), this._thread, "this", thisValue);
                    this.addVariable(thisVar);
                }
                if (scopeValue != null) {
                    JSDebugVariable scope = new JSDebugVariable(this.getDebugTarget(), this._thread, "scope", scopeValue);
                    IVariable[] vars = scope.getValue().getVariables();
                    int i = 0;
                    while (i < vars.length) {
                        this.addVariable((JSDebugVariable)vars[i]);
                        ++i;
                    }
                }
            }
            catch (RuntimeException re) {
                MozillaDebugPlugin.log(re);
                throw new DebugException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug", 5013, "Internal Mozilla Exception", (Throwable)re));
            }
            this._initializedVars = true;
        }
    }

    private void updateLabel() {
        String name = this._function == null ? "<inline>" : this._displayFunction;
        String path = this._relativePath == null ? this._location : this._relativePath.toPortableString();
        this._label = name;
        this._label = !this._topLevelStart ? String.valueOf(this._label) + this.getArgumentList() + (this.isNative() ? " [native function]" : " file=" + path + " line=" + this._line + " pc=" + this._lastpc) : String.valueOf(this._label) + " file=" + path;
    }

    public String getLabel() {
        return this._label;
    }

    private boolean isNative() {
        return this._frameProxy.getIsNative();
    }

    private String getArgumentList() {
        StringBuffer args = new StringBuffer();
        jsdIValue scope = this._frameProxy.getScope();
        jsdIProperty[][] propsRef = new jsdIProperty[1][];
        long[] lengthRef = new long[1];
        scope.getProperties((jsdIProperty[][])propsRef, lengthRef);
        if (propsRef == null) {
            return null;
        }
        args.append('(');
        int i = 0;
        while ((long)i < lengthRef[0]) {
            if ((propsRef[0][i].getFlags() & 0x10L) > 0L) {
                if (args.length() > 1) {
                    args.append(',');
                }
                args.append(propsRef[0][i].getName().getStringValue());
            }
            ++i;
        }
        args.append(')');
        return args.toString();
    }

    public IThread getThread() {
        return this._thread;
    }

    public int getLineNumber() throws DebugException {
        return this._line;
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        return this._function;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return new IRegisterGroup[0];
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public boolean canStepInto() {
        return this._thread.canStepInto();
    }

    public boolean canStepOver() {
        return this._thread.canStepOver();
    }

    public boolean canStepReturn() {
        return this._thread.canStepReturn();
    }

    public boolean isStepping() {
        return this._thread.isStepping();
    }

    public void stepInto() throws DebugException {
        JSDebugThread thread = (JSDebugThread)this.getThread();
        thread.setStepping(this._depth, this.getLineNumber(), this.getName(), -1);
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        thread.setInterruptHook();
        target.exitNestedEventLoop(1L);
    }

    public void stepOver() throws DebugException {
        JSDebugThread thread = (JSDebugThread)this.getThread();
        thread.setStepping(this._depth, this.getLineNumber(), this.getName(), this._depth);
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        thread.setInterruptHook();
        thread.setFunctionHook();
        target.exitNestedEventLoop(1L);
    }

    public void stepReturn() throws DebugException {
        JSDebugThread thread = (JSDebugThread)this.getThread();
        thread.setStepping(-1, -1, null, this._depth - 1);
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.unsetInterruptHook();
        thread.setFunctionHook();
        target.exitNestedEventLoop(1L);
    }

    public boolean canResume() {
        return this._thread.canResume();
    }

    public boolean canSuspend() {
        return this._thread.canSuspend();
    }

    public boolean isSuspended() {
        return this._thread.isSuspended();
    }

    public void resume() throws DebugException {
        this._thread.resume();
    }

    public void suspend() throws DebugException {
        this._thread.suspend();
    }

    public boolean canTerminate() {
        return this._thread.canTerminate();
    }

    public boolean isTerminated() {
        return this._thread.isTerminated();
    }

    public void terminate() throws DebugException {
        this._thread.terminate();
    }

    public IVariable[] getVariables() throws DebugException {
        if (!this._initializedVars) {
            this.initializeVars();
        }
        return super.getVariables();
    }

    public boolean hasVariables() throws DebugException {
        if (!this._initializedVars) {
            this.initializeVars();
        }
        return super.hasVariables();
    }

    public int getDepth() {
        return this._depth;
    }

    public void validate(jsdIStackFrame frame) {
        this._frameProxy = (jsdIStackFrame)XPCOMThreadProxy.createProxy((nsISupports)frame, (IXPCOMThreadProxyHelper)((JSDebugTarget)this.getDebugTarget()).getProxyHelper());
        this._label = null;
        try {
            this._line = (int)this._frameProxy.getLine();
            if (!this.isNative()) {
                this._lastpc = this._frameProxy.getPc();
            }
        }
        catch (RuntimeException re) {
            MozillaDebugPlugin.log(re);
        }
        this._variables = null;
        this._initializedVars = false;
        this.updateLabel();
    }

    public void invalidate() {
        this._frameProxy = null;
        this._line = -1;
        this._variables = null;
        this._initializedVars = false;
        this._topLevelStart = false;
    }

    public boolean isUnchangedFrom(jsdIStackFrame thatFrame) {
        return this.isSameAs(thatFrame) && this._lastpc == thatFrame.getPc();
    }

    public boolean isSameAs(jsdIStackFrame thatFrame) {
        jsdIScript script = thatFrame.getScript();
        if (script != null && this._tag == script.getTag()) {
            String thatFunction = thatFrame.getFunctionName();
            return this._function == null ? thatFunction == null : this._function.equals(thatFunction);
        }
        return false;
    }

    public String getLocation() {
        return this._location;
    }

    public IPath getRelativePath() {
        return this._relativePath;
    }

    public IValue eval(String expression) {
        IValue value = null;
        if (this._frameProxy != null) {
            jsdIValue[] result;
            jsdIScript script = this._frameProxy.getScript();
            String fileName = script.getFileName();
            boolean status = this._frameProxy.eval(expression, fileName, 1L, result = new jsdIValue[1]);
            if (status || !status) {
                if (result.length != 0) {
                    JSDebugVariable thisVar = new JSDebugVariable(this.getDebugTarget(), this._thread, "this", result[0]);
                    try {
                        value = thisVar.getValue();
                        value.getVariables();
                    }
                    catch (DebugException e) {
                        MozillaDebugPlugin.log(e);
                    }
                }
            } else {
                value = null;
            }
        }
        return value;
    }
}

