/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.internal.model;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugElement;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugStackFrame;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTarget;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTopScriptElement;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugVariable;
import org.eclipse.atf.mozilla.ide.debug.model.IJSDebugScriptElement;
import org.eclipse.atf.mozilla.ide.debug.model.JSSourceLocator;
import org.eclipse.atf.mozilla.ide.events.ApplicationEvent;
import org.eclipse.atf.mozilla.ide.events.IApplicationEvent;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventAdmin;
import org.eclipse.atf.mozilla.ide.events.ITimedEvent;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.mozilla.interfaces.jsdICallHook;
import org.mozilla.interfaces.jsdIContext;
import org.mozilla.interfaces.jsdIErrorHook;
import org.mozilla.interfaces.jsdIExecutionHook;
import org.mozilla.interfaces.jsdIObject;
import org.mozilla.interfaces.jsdIProperty;
import org.mozilla.interfaces.jsdIScript;
import org.mozilla.interfaces.jsdIScriptHook;
import org.mozilla.interfaces.jsdIStackFrame;
import org.mozilla.interfaces.jsdIValue;
import org.mozilla.interfaces.nsIBaseWindow;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMLocation;
import org.mozilla.interfaces.nsIDOMNSDocument;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;

public class JSDebugThread
extends JSDebugElement
implements IThread {
    public static final String JAVASCRIPT_FUNCTION = "org.eclipse.atf.debug.javascript.function";
    public static final String JAVASCRIPT_SOURCE_URI = "javascriptSourceFileURI";
    public static final String JAVASCRIPT_FUNCTION_NAME = "functionName";
    public static final String JAVASCRIPT_FUNCTION_STARTLINE = "functionStartLine";
    private final IStackFrame[] _emptyStack = new IStackFrame[0];
    private IBreakpoint[] _breakpoints = new IBreakpoint[0];
    private IStackFrame[] _stackFrames = this._emptyStack;
    private static final long TYPE_RUNNING = -1L;
    private long _suspendedType = -1L;
    private JSDebugVariable _exceptionObject = null;
    private boolean _stepping = false;
    private boolean _terminated = false;
    private IBreakpointManager _breakpointManager;
    private boolean _suspendOnErrors;
    private boolean _suspendOnExceptions;
    private boolean _suspendOnTopLevel;
    private boolean _reachedFirstLine;
    DebuggerServiceHook hook = new DebuggerServiceHook();
    protected HashMap topScriptElements = new HashMap();
    private int _stepPastDepth = -1;
    private int _stepPastLine = -1;
    private String _stepPastFrame = null;
    private int _stepOverDepth = -1;
    private String _stackTrace = null;
    private jsdIContext _cx;
    private List events = new ArrayList();

    public JSDebugThread(IDebugTarget target) {
        super(target);
        this._breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        return this.isSuspended() ? this._stackFrames : this._emptyStack;
    }

    public boolean hasStackFrames() throws DebugException {
        return this._stackFrames != null && this._stackFrames.length > 0;
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        return this._stackFrames.length > 0 ? this._stackFrames[0] : null;
    }

    public String getName() throws DebugException {
        return "Application Thread";
    }

    public IBreakpoint[] getBreakpoints() {
        return this._breakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this._suspendedType != -1L;
    }

    public void resume() throws DebugException {
        this.resume(false);
    }

    protected void resumeAbortScript() {
        this.resume(true);
        this._suspendedType = -1L;
    }

    private void resume(boolean abortScript) {
        long returnType;
        if (this._stepping) {
            this._stepping = false;
            JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
            target.getProxyHelper().syncExec(new Runnable(){

                public void run() {
                    ((JSDebugTarget)JSDebugThread.this.getDebugTarget()).unsetInterruptHook();
                }
            });
        }
        this._reachedFirstLine = false;
        long l = returnType = this._suspendedType == 4L ? 5L : 1L;
        if (abortScript) {
            returnType = 2L;
        }
        ((JSDebugTarget)this.getDebugTarget()).exitNestedEventLoop(returnType);
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return this.isSuspended() && !this._reachedFirstLine;
    }

    public boolean canStepOver() {
        return this.isSuspended() && !this._reachedFirstLine;
    }

    public boolean canStepReturn() {
        return this.isSuspended() && !this._reachedFirstLine;
    }

    public boolean isStepping() {
        return this._stepping;
    }

    public void setStepping(int pastDepth, int pastLine, String pastFrame, int overDepth) {
        this._stepping = true;
        this._stepPastDepth = pastDepth;
        this._stepPastLine = pastLine;
        this._stepPastFrame = pastFrame;
        this._stepOverDepth = overDepth;
    }

    public void stepInto() throws DebugException {
        this.getTopStackFrame().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getTopStackFrame().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getTopStackFrame().stepReturn();
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this._terminated;
    }

    public void terminate() throws DebugException {
        if (this.isTerminated()) {
            return;
        }
        this._terminated = true;
        this._stackFrames = null;
        this.fireTerminateEvent();
    }

    public String getLabel() {
        StringBuffer label = new StringBuffer("<unknown>");
        try {
            label = new StringBuffer(this.getName());
            label.append(" (");
            try {
                switch ((int)this._suspendedType) {
                    case 0: {
                        label.append(this.isStepping() ? "stepping" : "interrupted");
                        break;
                    }
                    case 1: {
                        label.append("at breakpoint");
                        break;
                    }
                    case 2: {
                        label.append("at error breakpoint");
                        break;
                    }
                    case 3: {
                        if (!this._reachedFirstLine) {
                            label.append("debugger keyword");
                            break;
                        }
                        label.append("suspended at start");
                        break;
                    }
                    case 4: {
                        label.append("exception: ");
                        if (this._exceptionObject != null) {
                            jsdIValue exception = (jsdIValue)this._exceptionObject.getValue().getAdapter(jsdIValue.class);
                            if (exception != null && exception.getJsClassName() == "Error") {
                                label.append(exception.getProperty("message"));
                                break;
                            }
                            label.append(this._exceptionObject.getValue().getValueString());
                        }
                        break;
                    }
                    case -1: {
                        label.append("running");
                        break;
                    }
                    default: {
                        label.append("unknown");
                        break;
                    }
                }
            }
            finally {
                label.append(')');
            }
        }
        catch (DebugException de) {
            MozillaDebugPlugin.log(de);
        }
        return label.toString();
    }

    public void setSuspendOnErrors(boolean suspend) {
        this._suspendOnErrors = suspend;
    }

    public void setSuspendOnExceptions(boolean suspend) {
        this._suspendOnExceptions = suspend;
    }

    public void setSuspendOnTopLevel(boolean suspend) {
        this._suspendOnTopLevel = suspend;
    }

    public boolean onError0(String message, String fileName, long line, long pos, long flags, long errnum, jsdIValue exception) {
        boolean resume = !this._suspendOnErrors;
        try {
            Throwable throwable = null;
            if ((flags & 1L) > 0L) {
                // empty if block
            }
            if (0L > 0L) {
                // empty if block
            }
            if ((flags & 2L) > 0L) {
                throwable = new Throwable(){
                    private String _stackTrace;
                    {
                        this._stackTrace = JSDebugThread.this._stackTrace;
                    }

                    public void printStackTrace(PrintStream s) {
                        s.println(this._stackTrace);
                    }

                    public void printStackTrace(PrintWriter s) {
                        s.println(this._stackTrace);
                    }

                    public String getMessage() {
                        return "JavaScript stack trace:\n" + this._stackTrace;
                    }
                };
            }
            if ((flags & 4L) > 0L) {
                // empty if block
            }
            MozillaDebugPlugin.log(new DebugException((IStatus)new Status(4, "org.eclipse.atf.mozilla.ide.debug", 5012, "Mozilla JavaScript Exception: " + message, throwable)));
            this._stackTrace = null;
        }
        catch (RuntimeException re) {
            MozillaDebugPlugin.log(re);
            throw re;
        }
        catch (Error e) {
            MozillaDebugPlugin.log(e);
            throw e;
        }
        return resume;
    }

    public void clearCX() {
        if (this.isSuspended() && this._cx != null) {
            this._cx.setScriptsEnabled(true);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long onExecute0(jsdIStackFrame frame, long type, jsdIValue[] rv) {
        try {
            String[] types = new String[]{"TYPE_INTERRUPTED", "TYPE_BREAKPOINT", "TYPE_DEBUG_REQUESTED", "TYPE_DEBUGGER_KEYWORD", "TYPE_THROW", "RETURN_HOOK_ERROR", "RETURN_CONTINUE", "RETURN_ABORT", "RETURN_RET_WITH_VAL", "RETURN_THROW_WITH_VAL", "RETURN_CONTINUE_THROW"};
            MozillaDebugPlugin.debug("jsdiExecutionHook.onExecute: pc=" + frame.getPc() + " calee=" + frame.getCallingFrame() + " isConstructing=" + frame.getIsConstructing() + " function=" + frame.getFunctionName() + " type=" + types[(int)type] + " scope=" + this.jsdP(frame.getScope()) + " this=" + this.jsdP(frame.getThisValue()) + " ctx=" + frame.getExecutionContext().getOptions());
            if (frame.getIsNative()) {
                return 1L;
            }
            if (type == 4L) {
                if (this._stackTrace == null) {
                    StringBuffer trace = new StringBuffer();
                    jsdIStackFrame f = frame;
                    while (true) {
                        if (f == null) {
                            this._stackTrace = trace.toString();
                            break;
                        }
                        trace.append(f.getFunctionName());
                        trace.append("()");
                        trace.append(' ');
                        boolean isNative = f.getIsNative();
                        if (isNative) {
                            trace.append("[native function]");
                        } else {
                            jsdIScript script = frame.getScript();
                            trace.append(script.getFileName());
                            trace.append(':');
                            trace.append(f.getLine());
                        }
                        trace.append('\n');
                        f = f.getCallingFrame();
                    }
                }
                if (!this._suspendOnExceptions) {
                    return 5L;
                }
            }
            this._cx = frame.getExecutionContext();
            this._cx.setScriptsEnabled(false);
            long result = 2L;
            nsIBaseWindow window = (nsIBaseWindow)this.getDebugTarget().getProcess().getAdapter(nsIBaseWindow.class);
            try {
                jsdIValue exception;
                block31: {
                    try {
                        window.setEnabled(false);
                    }
                    catch (XPCOMException xpcome) {
                        if (xpcome.errorcode == 2147500033L) break block31;
                        throw xpcome;
                    }
                }
                this._suspendedType = type;
                switch ((int)type) {
                    case 0: {
                        boolean theSameFrame;
                        if (!this.isStepping()) break;
                        boolean bl = theSameFrame = this._stepPastFrame == null && frame.getFunctionName() == null || this._stepPastFrame != null && this._stepPastFrame.equals(frame.getFunctionName());
                        if (this._stepPastDepth == this.getDepth(frame) && theSameFrame && (long)this._stepPastLine == frame.getLine()) {
                            MozillaDebugPlugin.debug("stepPast: " + this._stepPastFrame + "line: " + this._stepPastLine + " depth:" + this._stepPastDepth);
                            return 1L;
                        }
                        this._stepPastDepth = -1;
                        break;
                    }
                    case 1: {
                        Vector foundBreakpoints = new Vector();
                        this._breakpoints = foundBreakpoints.toArray(new IBreakpoint[0]);
                        break;
                    }
                }
                this.updateFrames(frame);
                if (type == 4L && rv.length > 0 && (exception = rv[0]) != null) {
                    this._exceptionObject = new JSDebugVariable(this.getDebugTarget(), this, "[exception object]", exception);
                    JSDebugStackFrame topFrame = (JSDebugStackFrame)this._stackFrames[0];
                    topFrame.addVariable(this._exceptionObject);
                }
                result = this.waitLoop();
                if (this._stackFrames == null) return result;
                int i = 0;
                while (true) {
                    if (i >= this._stackFrames.length) {
                        return result;
                    }
                    JSDebugStackFrame f = (JSDebugStackFrame)this._stackFrames[i];
                    f.invalidate();
                    ++i;
                }
            }
            finally {
                block32: {
                    this._suspendedType = -1L;
                    this._exceptionObject = null;
                    this._breakpoints = new IBreakpoint[0];
                    this._cx.setScriptsEnabled(true);
                    this._cx = null;
                    try {
                        window.setEnabled(true);
                    }
                    catch (XPCOMException xpcome) {
                        if (xpcome.errorcode == 2147500033L) break block32;
                        throw xpcome;
                    }
                }
            }
        }
        catch (RuntimeException re) {
            MozillaDebugPlugin.log(re);
            throw re;
        }
        catch (Error e) {
            MozillaDebugPlugin.log(e);
            throw e;
        }
    }

    private String jsdP(jsdIValue value) {
        switch ((int)value.getJsType()) {
            case 0: {
                return Boolean.toString(value.getBooleanValue());
            }
            case 1: {
                return Double.toString(value.getDoubleValue());
            }
            case 3: {
                return "Fn" + value.getJsClassName() + value.getJsFunctionName();
            }
            case 2: {
                return Integer.toString(value.getIntValue());
            }
            case 4: {
                return "NuLL";
            }
            case 5: {
                jsdIObject obj = value.getObjectValue();
                return String.valueOf(obj.getConstructorURL()) + ":" + obj.getConstructorLine() + "/" + obj.getCreatorURL() + ":" + obj.getCreatorLine();
            }
            case 6: {
                return value.getStringValue();
            }
            case 7: {
                return "void";
            }
        }
        return "??";
    }

    private long waitLoop() {
        this.fireSuspendEvent(this.isStepping() ? 8 : 16);
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.unsetFunctionHook();
        this.fireChangeEvent(256);
        long result = target.enterNestedEventLoop(null);
        if (!this.isStepping() && target.getDebuggerService() != null) {
            ((JSDebugTarget)this.getDebugTarget()).unsetInterruptHook();
        }
        target.fireChangeEvent(256);
        this.fireResumeEvent(this.isStepping() ? 0 : 32);
        return result;
    }

    private void onCall0(jsdIStackFrame frame, long type) {
        try {
            String[] stringArray = new String[]{"TYPE_TOPLEVEL_START", "TYPE_TOPLEVEL_END", "TYPE_FUNCTION_CALL", "TYPE_FUNCTION_RETURN"};
            JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
            switch ((int)type) {
                case 0: {
                    if (this._suspendOnTopLevel && !this._reachedFirstLine) {
                        this._reachedFirstLine = true;
                        this.onExecute0(frame, 3L, new jsdIValue[0]);
                    }
                    break;
                }
                case 2: {
                    if (this.isStepping()) {
                        ((JSDebugTarget)this.getDebugTarget()).unsetInterruptHook();
                    }
                    break;
                }
                case 3: {
                    int depth;
                    if (this.isStepping() && (depth = this.getDepth(frame) - 1) <= this._stepOverDepth) {
                        MozillaDebugPlugin.debug("step over at target depth of " + depth);
                        this.setInterruptHook();
                    }
                    break;
                }
                case 1: {
                    target.unsetInterruptHook();
                }
            }
        }
        catch (RuntimeException re) {
            MozillaDebugPlugin.log(re);
            throw re;
        }
        catch (Error e) {
            MozillaDebugPlugin.log(e);
            throw e;
        }
    }

    private void onScriptCreated0(jsdIScript script) {
        try {
            String fileName = script.getFileName();
            URL url = null;
            try {
                url = new URL(fileName);
            }
            catch (MalformedURLException malformedURLException) {
                MozillaDebugPlugin.debug("Error creating URL for request: " + fileName);
                return;
            }
            String path = url.getPath();
            MozillaDebugPlugin.debug("org.eclipse.atf.mozilla.ide.debug/jsdScriptHook", "onScriptCreated file=" + fileName + " func=" + script.getFunctionName() + " baseline=" + script.getBaseLineNumber() + " extent" + script.getLineExtent());
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            JSSourceLocator locator = (JSSourceLocator)this.getLaunch().getSourceLocator();
            if (this._breakpointManager.isEnabled()) {
                int i = 0;
                while (i < breakpoints.length) {
                    try {
                        if (breakpoints[i].isEnabled()) {
                            ((JSDebugTarget)this.getDebugTarget()).establishBreakpoint(true, locator, script, breakpoints[i]);
                        }
                    }
                    catch (CoreException e) {
                        MozillaDebugPlugin.log(e);
                    }
                    ++i;
                }
            }
            JSDebugTopScriptElement topScriptElement = null;
            if (this.topScriptElements.containsKey(path)) {
                topScriptElement = (JSDebugTopScriptElement)this.topScriptElements.get(path);
            } else {
                topScriptElement = new JSDebugTopScriptElement(this.getDebugTarget());
                topScriptElement.setName(path);
                topScriptElement.setLocation(fileName);
                this.topScriptElements.put(path, topScriptElement);
            }
        }
        catch (RuntimeException re) {
            MozillaDebugPlugin.log(re);
            throw re;
        }
        catch (Error e) {
            MozillaDebugPlugin.log(e);
            throw e;
        }
    }

    public IJSDebugScriptElement[] getTopScriptElements() {
        IJSDebugScriptElement[] array = new IJSDebugScriptElement[this.topScriptElements.size()];
        this.topScriptElements.values().toArray(array);
        return array;
    }

    private void onScriptDestroyed0(jsdIScript script) {
        try {
            MozillaDebugPlugin.debug("org.eclipse.atf.mozilla.ide.debug/jsdScriptHook", "onScriptDestroyed file=" + script.getFileName() + " func=" + script.getFunctionName());
        }
        catch (RuntimeException re) {
            MozillaDebugPlugin.log(re);
            throw re;
        }
        catch (Error e) {
            MozillaDebugPlugin.log(e);
            throw e;
        }
    }

    private void updateFrames(jsdIStackFrame topFrame) {
        IStackFrame[] newStack = this._emptyStack;
        try {
            jsdIStackFrame[] newFrames = this.getFullStack(topFrame);
            int newLength = newFrames.length;
            int i = this._stackFrames.length - 1;
            int j = newFrames.length - 1;
            while (i >= 0 && j >= 0) {
                JSDebugStackFrame oldFrame = (JSDebugStackFrame)this._stackFrames[i];
                jsdIStackFrame newFrame = newFrames[j];
                if (!oldFrame.isUnchangedFrom(newFrame)) {
                    if (!oldFrame.isSameAs(newFrame)) break;
                    --i;
                    oldFrame.validate(newFrame);
                    break;
                }
                oldFrame.validate(newFrame);
                --i;
                --j;
            }
            if (i < 0 && this._stackFrames.length == newLength) {
                return;
            }
            newStack = new IStackFrame[newLength];
            int n = newLength - 1;
            int m = this._stackFrames.length - 1;
            while (m > i) {
                newStack[n] = this._stackFrames[m];
                --m;
                --n;
            }
            while (n >= 0) {
                newStack[n] = new JSDebugStackFrame(this.getDebugTarget(), this, newFrames[n], newLength - 1 - n, this._reachedFirstLine);
                --n;
            }
        }
        catch (RuntimeException re) {
            MozillaDebugPlugin.log(re);
        }
        this._stackFrames = newStack;
    }

    private int getDepth(jsdIStackFrame frame) {
        int depth = -1;
        while (frame != null) {
            frame = frame.getCallingFrame();
            ++depth;
        }
        return depth;
    }

    private jsdIStackFrame[] getFullStack(jsdIStackFrame topFrame) {
        ArrayList<jsdIStackFrame> frames = new ArrayList<jsdIStackFrame>();
        jsdIStackFrame frame = topFrame;
        while (frame != null) {
            frames.add(frame);
            frame = frame.getCallingFrame();
        }
        return frames.toArray(new jsdIStackFrame[0]);
    }

    private boolean isCorrectContext(jsdIStackFrame frame) {
        nsIWebBrowser browser = (nsIWebBrowser)this.getDebugTarget().getProcess().getAdapter(nsIWebBrowser.class);
        nsIDOMWindow window = browser.getContentDOMWindow();
        nsIDOMDocument document = window.getDocument();
        nsIDOMNSDocument domNSDoc = (nsIDOMNSDocument)document.queryInterface("{09a439ad-4079-46d5-a050-4d7015d1a108}");
        nsIDOMLocation location = domNSDoc.getLocation();
        jsdIContext context = frame.getExecutionContext();
        jsdIValue globalObject = context.getGlobalObject();
        jsdIProperty prop = globalObject.getProperty("location");
        jsdIValue value = prop.getValue();
        String frameLoc = "";
        MozillaDebugPlugin.debug("Window href: " + location.getHref());
        if (value.getIsValid()) {
            frameLoc = value.getStringValue();
            MozillaDebugPlugin.debug("Frame Location: " + frameLoc);
            if (frameLoc.equalsIgnoreCase(location.getHref())) {
                return true;
            }
        }
        return false;
    }

    public void setInterruptHook() {
        MozillaDebugPlugin.debug("setInterruptHook(thread)");
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.getDebuggerService().setInterruptHook((jsdIExecutionHook)this.hook);
    }

    public void setDebuggerHook() {
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.getDebuggerService().setDebuggerHook((jsdIExecutionHook)this.hook);
    }

    public void setThrowHook() {
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.getDebuggerService().setThrowHook((jsdIExecutionHook)this.hook);
    }

    public void setDebugHook() {
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.getDebuggerService().setDebugHook((jsdIExecutionHook)this.hook);
    }

    public void setBreakpointHook() {
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.getDebuggerService().setBreakpointHook((jsdIExecutionHook)this.hook);
    }

    public void setTopLevelHook() {
        MozillaDebugPlugin.debug("setTopLevelHook(thread)");
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.getDebuggerService().setTopLevelHook((jsdICallHook)this.hook);
    }

    public void setFunctionHook() {
        MozillaDebugPlugin.debug("setFunctionHook(thread)");
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.getDebuggerService().setFunctionHook((jsdICallHook)this.hook);
    }

    public void setErrorHook() {
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.getDebuggerService().setErrorHook((jsdIErrorHook)this.hook);
    }

    public void setScriptHook() {
        JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
        target.getDebuggerService().setScriptHook((jsdIScriptHook)this.hook);
    }

    private void postJavaScriptCallEvent(jsdIStackFrame frame, boolean start) {
        if (start) {
            ITimedEvent parent = null;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put(JAVASCRIPT_SOURCE_URI, frame.getScript().getFileName());
            data.put(JAVASCRIPT_FUNCTION_NAME, frame.getFunctionName());
            data.put(JAVASCRIPT_FUNCTION_STARTLINE, (int)frame.getLine());
            JSDebugTarget target = (JSDebugTarget)this.getDebugTarget();
            IWebBrowser wb = (IWebBrowser)target.getProcess().getAdapter(IWebBrowser.class);
            ApplicationEvent event = new ApplicationEvent(wb, JAVASCRIPT_FUNCTION, parent, data);
            this.events.add(event);
            return;
        }
        ApplicationEvent event = (ApplicationEvent)this.events.remove(this.events.size() - 1);
        event.setLength(System.currentTimeMillis() - event.getStartTime());
        IApplicationEventAdmin adm = MozillaDebugPlugin.getDefault().getApplicationEventAdmin();
        adm.postEvent((IApplicationEvent)event);
    }

    private class DebuggerServiceHook
    implements jsdIExecutionHook,
    jsdICallHook,
    jsdIErrorHook,
    jsdIScriptHook {
        private DebuggerServiceHook() {
        }

        public long onExecute(jsdIStackFrame frame, long type, jsdIValue[] rv) {
            if (MozillaDebugPlugin.getDefault().isProfiling()) {
                return 1L;
            }
            return JSDebugThread.this.onExecute0(frame, type, rv);
        }

        public void onCall(jsdIStackFrame frame, long type) {
            if (MozillaDebugPlugin.getDefault().isProfiling()) {
                JSDebugThread.this.postJavaScriptCallEvent(frame, type == 2L || type == 0L);
                return;
            }
            JSDebugThread.this.onCall0(frame, type);
        }

        public boolean onError(String message, String filename, long line, long pos, long flags, long errornum, jsdIValue exception) {
            if (MozillaDebugPlugin.getDefault().isProfiling()) {
                return true;
            }
            return JSDebugThread.this.onError0(message, filename, line, pos, flags, errornum, exception);
        }

        public void onScriptCreated(jsdIScript script) {
            if (MozillaDebugPlugin.getDefault().isProfiling()) {
                return;
            }
            JSDebugThread.this.onScriptCreated0(script);
        }

        public void onScriptDestroyed(jsdIScript script) {
            if (MozillaDebugPlugin.getDefault().isProfiling()) {
                return;
            }
            JSDebugThread.this.onScriptDestroyed0(script);
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    }
}

