/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.model;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

public abstract class JSBreakpoint
extends Breakpoint {
    public String getModelIdentifier() {
        return "org.eclipse.atf.mozilla.ide.debug";
    }

    public static IResource getStorageMarkerResource() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    private void registerBreakpoint() throws CoreException {
        DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)this);
    }

    protected void createMarker(final IResource resource, final String markerType, final boolean register, final Map attributes) {
        IWorkspaceRunnable body = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                IMarker marker = resource.createMarker(markerType);
                Map fAttrs = attributes != null ? attributes : new HashMap();
                fAttrs.put("org.eclipse.debug.core.enabled", new Boolean(true));
                fAttrs.put("org.eclipse.debug.core.id", JSBreakpoint.this.getModelIdentifier());
                marker.setAttributes(fAttrs);
                JSBreakpoint.this.setMarker(marker);
                if (register) {
                    JSBreakpoint.this.registerBreakpoint();
                }
                JSBreakpoint.this.setPersisted(true);
            }
        };
        try {
            ResourcesPlugin.getWorkspace().run(body, null);
        }
        catch (CoreException ce) {
            MozillaDebugPlugin.log(ce);
        }
    }

    public abstract String getLabel();
}

