/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.model;

import java.util.HashMap;
import org.eclipse.atf.mozilla.ide.debug.model.JSBreakpoint;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;

public class JSFunctionBreakpoint
extends JSBreakpoint {
    public static final String BREAKPOINT_ID = "org.eclipse.atf.mozilla.ide.debug.JSFunctionBreakpointMarker";

    public JSFunctionBreakpoint() {
    }

    public JSFunctionBreakpoint(String functionName) {
        IResource resource = JSFunctionBreakpoint.getStorageMarkerResource();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("functionName", functionName);
        this.createMarker(resource, BREAKPOINT_ID, true, map);
    }

    public String getLabel() {
        return this.getFunctionName();
    }

    public static JSFunctionBreakpoint createBreakpoint(String functionName) {
        IResource resource = JSFunctionBreakpoint.getStorageMarkerResource();
        try {
            IMarker[] markers = resource.findMarkers(BREAKPOINT_ID, false, 0);
            if (markers.length > 0) {
                int i = 0;
                while (i < markers.length) {
                    if (functionName.equals(markers[i].getAttribute("functionName", null))) {
                        return (JSFunctionBreakpoint)DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(markers[0]);
                    }
                    ++i;
                }
            }
        }
        catch (CoreException coreException) {}
        JSFunctionBreakpoint breakpoint = new JSFunctionBreakpoint(functionName);
        return breakpoint;
    }

    public String getFunctionName() {
        String functionName = this.getMarker().getAttribute("functionName", null);
        return functionName;
    }
}

