/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.model;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.debug.JSDebugCoreMessages;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.model.JSBreakpoint;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;

public class JSLineBreakpoint
extends JSBreakpoint
implements ILineBreakpoint {
    public static final String STORAGE_ID = "org.eclipse.wst.sse.ui.extensions.breakpoint.path";
    public static final String BREAKPOINT_ID = "org.eclipse.atf.mozilla.ide.debug.JSLineBreakpointMarker";
    private int _lineNumber;
    private String _id;

    public JSLineBreakpoint() {
    }

    public JSLineBreakpoint(IStorage storage, int lineNumber, int charStart, int charEnd, boolean register, Map map) {
        IResource resource;
        if (map == null) {
            map = new HashMap<String, Object>();
        }
        if (storage instanceof IFile) {
            resource = (IFile)storage;
        } else {
            resource = JSLineBreakpoint.getStorageMarkerResource();
            map.put(STORAGE_ID, storage.getName());
        }
        map.put("lineNumber", new Integer(lineNumber));
        map.put("charStart", new Integer(charStart));
        map.put("charEnd", new Integer(charEnd));
        this.createMarker(resource, BREAKPOINT_ID, register, map);
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this._lineNumber = (Integer)marker.getAttribute("lineNumber");
        this._id = (String)marker.getAttribute(STORAGE_ID);
    }

    protected void setAttribute(String attributeName, boolean value) throws CoreException {
        super.setAttribute(attributeName, value);
        if ("org.eclipse.debug.core.enabled".equals(attributeName)) {
            DebugPlugin.getDefault().getBreakpointManager().fireBreakpointChanged((IBreakpoint)this);
        }
    }

    public String getLabel() {
        try {
            IMarker marker = this.getMarker();
            IResource res = marker.getResource();
            String file = res instanceof IWorkspaceRoot ? this.getID() : marker.getResource().getName();
            String line = Integer.toString(this.getLineNumber());
            return MessageFormat.format(JSDebugCoreMessages.JSDebugCore_5, file, line);
        }
        catch (CoreException ce) {
            MozillaDebugPlugin.log(ce);
            return JSDebugCoreMessages.JSDebugCore_4;
        }
    }

    public String getID() {
        return this._id;
    }

    public int getLineNumber() throws CoreException {
        try {
            this._lineNumber = (Integer)this.getMarker().getAttribute("lineNumber");
        }
        catch (CoreException coreException) {}
        return this._lineNumber;
    }

    public int getCharEnd() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("charEnd", -1);
        }
        return -1;
    }

    public int getCharStart() throws CoreException {
        IMarker m = this.getMarker();
        if (m != null) {
            return m.getAttribute("charStart", -1);
        }
        return -1;
    }
}

