/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.model;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.atf.mozilla.ide.core.util.SourceLocatorUtil;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugStackFrame;
import org.eclipse.atf.mozilla.ide.debug.model.JSLineBreakpoint;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.model.IStackFrame;

public class JSSourceLocator
implements IPersistableSourceLocator {
    private IProject _project;
    private String _appBase;
    protected SourceLocatorUtil locatorUtil = SourceLocatorUtil.getInstance();

    public String getMemento() throws CoreException {
        MozillaDebugPlugin.debug("getMemento");
        return null;
    }

    public void initializeDefaults(ILaunchConfiguration configuration) throws CoreException {
        MozillaDebugPlugin.debug("initializeDefaults");
    }

    public void initializeFromMemento(String memento) throws CoreException {
        MozillaDebugPlugin.debug("initializeFromMemento");
    }

    public IPath getContentRelativePath(String location) {
        if (this._project != null && location.startsWith(this._appBase)) {
            return new Path(location.substring(this._appBase.length()));
        }
        return null;
    }

    public Object getSourceElement(IStackFrame stackFrame) {
        IStorage result = null;
        String location = ((JSDebugStackFrame)stackFrame).getLocation();
        try {
            if (location != null) {
                URL locationURL = new URL(location);
                result = this.locatorUtil.getSourceElement(locationURL, this._appBase, this._project);
            }
        }
        catch (MalformedURLException mue) {
            Status status = new Status(4, "org.eclipse.atf.mozilla.ide.debug", 120, "Invalid URL supplied by Mozilla.  Unable to open source.", (Throwable)mue);
            DebugPlugin.log((IStatus)status);
        }
        return result;
    }

    public boolean matches(IBreakpoint breakpoint, String scriptURI) {
        IResource res = breakpoint.getMarker().getResource();
        boolean match = false;
        JSLineBreakpoint jsBPoint = null;
        if (!(breakpoint instanceof JSLineBreakpoint)) {
            return match;
        }
        jsBPoint = (JSLineBreakpoint)breakpoint;
        if (res instanceof IWorkspaceRoot) {
            try {
                String id = jsBPoint.getID();
                URL url = new URL(scriptURI);
                String path = url.toString();
                match = path.equals(id);
            }
            catch (MalformedURLException malformedURLException) {
                match = false;
            }
        } else {
            try {
                IStorage localResource = SourceLocatorUtil.getInstance().getSourceElement(new URL(scriptURI), this._appBase, this._project);
                match = res.equals((Object)localResource);
            }
            catch (MalformedURLException mue) {
                Status status = new Status(2, "org.eclipse.atf.mozilla.ide.debug", 120, "javascript: URLs are not handled.", (Throwable)mue);
                DebugPlugin.log((IStatus)status);
                match = false;
            }
        }
        return match;
    }

    public void setProject(IProject project) {
        this._project = project;
    }

    public void setAppBase(String appBase) {
        this._appBase = appBase;
    }

    public IProject getProject() {
        return this._project;
    }

    public String getAppBase() {
        return this._appBase;
    }
}

