/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.events;

import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.events.IApplicationEvent;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMMutationEvent;
import org.mozilla.interfaces.nsIDOMNode;

public class DOMMutationEvent
implements IApplicationEvent {
    public static final String NODE_INSERTED = "org.eclipse.atf.mozilla.ide.events.IDOMMutationListener.nodeInserted";
    public static final String NODE_REMOVED = "org.eclipse.atf.mozilla.ide.events.IDOMMutationListener.nodeRemoved";
    public static final String ATTRIBUTE_ADDED = "org.eclipse.atf.mozilla.ide.events.IDOMMutationListener.attributeAdded";
    public static final String ATTRIBUTE_REMOVED = "org.eclipse.atf.mozilla.ide.events.IDOMMutationListener.addributeRemoved";
    public static final String ATTRIBUTE_MODIFIED = "org.eclipse.atf.mozilla.ide.events.IDOMMutationListener.attributeModified";
    public nsIDOMNode parentNode;
    public nsIDOMNode insertedNode;
    public nsIDOMNode removedNode;
    public nsIDOMElement ownerElement;
    public String attributeName;
    public String newValue;
    public String previousValue;
    private String type;
    private IWebBrowser browser;

    public DOMMutationEvent(IWebBrowser browser, String type) {
        this.browser = browser;
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public static DOMMutationEvent attributeRemoved(IWebBrowser browser, nsIDOMMutationEvent event) {
        DOMMutationEvent newEvent = new DOMMutationEvent(browser, ATTRIBUTE_REMOVED);
        newEvent.ownerElement = (nsIDOMElement)event.getTarget().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        newEvent.attributeName = event.getAttrName();
        return newEvent;
    }

    public static DOMMutationEvent attributeModified(IWebBrowser browser, nsIDOMMutationEvent event) {
        DOMMutationEvent newEvent = new DOMMutationEvent(browser, ATTRIBUTE_MODIFIED);
        newEvent.ownerElement = (nsIDOMElement)event.getTarget().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        newEvent.attributeName = event.getAttrName();
        newEvent.newValue = event.getNewValue();
        newEvent.previousValue = event.getPrevValue();
        return newEvent;
    }

    public static DOMMutationEvent attributeAdded(IWebBrowser browser, nsIDOMMutationEvent event) {
        DOMMutationEvent newEvent = new DOMMutationEvent(browser, ATTRIBUTE_ADDED);
        newEvent.ownerElement = (nsIDOMElement)event.getTarget().queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        newEvent.attributeName = event.getAttrName();
        return newEvent;
    }

    public static DOMMutationEvent nodeRemoved(IWebBrowser browser, nsIDOMMutationEvent event) {
        DOMMutationEvent newEvent = new DOMMutationEvent(browser, NODE_REMOVED);
        newEvent.parentNode = event.getRelatedNode();
        newEvent.removedNode = (nsIDOMNode)event.getTarget().queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}");
        return newEvent;
    }

    public static DOMMutationEvent nodeInserted(IWebBrowser browser, nsIDOMMutationEvent event) {
        DOMMutationEvent newEvent = new DOMMutationEvent(browser, NODE_INSERTED);
        newEvent.parentNode = event.getRelatedNode();
        newEvent.insertedNode = (nsIDOMNode)event.getTarget().queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}");
        return newEvent;
    }

    public IWebBrowser getBrowser() {
        return this.browser;
    }
}

