/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.internal.debug;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.core.MozideCorePlugin;
import org.eclipse.atf.mozilla.ide.events.IApplicationEvent;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventAdmin;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;

public class ApplicationEventAdmin
implements IApplicationEventAdmin {
    private Map<IWebBrowser, List<IApplicationEventListener>> listeners = new HashMap<IWebBrowser, List<IApplicationEventListener>>();
    private List<IApplicationEventListener> unboundListeners = new ArrayList<IApplicationEventListener>();
    private List eventsQueue = new ArrayList();
    private boolean isTerminated = false;
    private Thread t;

    public ApplicationEventAdmin() {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                List list = ApplicationEventAdmin.this.eventsQueue;
                synchronized (list) {
                    while (!ApplicationEventAdmin.this.isTerminated) {
                        try {
                            ApplicationEventAdmin.this.eventsQueue.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                        ApplicationEventAdmin.this.notifyListeners();
                    }
                }
            }
        };
        this.t = new Thread(runnable);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners() {
        IApplicationEvent[] events = null;
        List list = this.eventsQueue;
        synchronized (list) {
            if (this.eventsQueue.size() == 0) {
                return;
            }
            events = this.eventsQueue.toArray(new IApplicationEvent[this.eventsQueue.size()]);
            this.eventsQueue.clear();
        }
        int i = 0;
        while (i < events.length) {
            IApplicationEvent event = events[i];
            try {
                this.sendEvent(event);
            }
            catch (RuntimeException e) {
                MozideCorePlugin.log(e);
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postEvent(IApplicationEvent event) {
        List list = this.eventsQueue;
        synchronized (list) {
            this.eventsQueue.add(event);
            this.eventsQueue.notify();
        }
    }

    public synchronized void sendEvent(IApplicationEvent event) {
        List<IApplicationEventListener> bListeners = this.listeners.get(event.getBrowser());
        if (bListeners != null) {
            for (IApplicationEventListener listener : bListeners) {
                try {
                    listener.onEvent(event);
                }
                catch (RuntimeException e) {
                    MozideCorePlugin.log(e);
                }
            }
        }
        for (IApplicationEventListener listener : this.unboundListeners) {
            try {
                listener.onEvent(event);
            }
            catch (RuntimeException e) {
                MozideCorePlugin.log(e);
            }
        }
    }

    public void addEventListener(IWebBrowser browser, IApplicationEventListener listener) {
        List<IApplicationEventListener> list = this.listeners.get(browser);
        if (list == null) {
            list = new ArrayList<IApplicationEventListener>();
            this.listeners.put(browser, list);
        }
        list.add(listener);
    }

    public void removeEventListener(IWebBrowser browser, IApplicationEventListener listener) {
        List<IApplicationEventListener> list = this.listeners.get(browser);
        if (list != null) {
            list.remove(listener);
        }
    }

    public void terminate() {
        this.isTerminated = true;
        this.t.interrupt();
    }

    public void dispose(IWebBrowser browser) {
        List<IApplicationEventListener> list = this.listeners.remove(browser);
        if (list != null) {
            list.clear();
        }
    }

    public void addEventListener(IApplicationEventListener listener) {
        this.unboundListeners.add(listener);
    }

    public void removeEventListener(IApplicationEventListener listener) {
        this.unboundListeners.remove(listener);
    }
}

