/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugElement;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugTarget;
import org.eclipse.atf.mozilla.ide.debug.model.JSBreakpoint;
import org.eclipse.atf.mozilla.ide.debug.ui.MozillaDebugUIMessages;
import org.eclipse.atf.mozilla.ide.debug.ui.internal.adapter.JSBreakpointTypeAdapterFactory;
import org.eclipse.atf.mozilla.ide.ui.browser.MozBrowserProcess;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class MozillaDebugUIPlugin
extends AbstractUIPlugin
implements IStartup,
IDebugEventSetListener,
IPerspectiveListener {
    private static MozillaDebugUIPlugin _plugin;
    private ResourceBundle _resourceBundle;
    public static final String PLUGIN_ID = "org.eclipse.atf.mozilla.ide.debug.ui";
    private EventListener eventListener;
    protected static String[] JSDEBUGVIEWS;

    static {
        JSDEBUGVIEWS = new String[]{"org.eclipse.atf.mozilla.ide.debug.ui.scriptview"};
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        _plugin = this;
        try {
            this._resourceBundle = ResourceBundle.getBundle("org.eclipse.atf.mozilla.ide.debug.launch.internal.MozillaDebugUIResources");
        }
        catch (MissingResourceException missingResourceException) {
            this._resourceBundle = null;
        }
        IWorkbenchWindow w = MozillaDebugUIPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            w.addPerspectiveListener((IPerspectiveListener)this);
        } else {
            this.getWorkbench().addWindowListener(new IWindowListener(){

                public void windowActivated(IWorkbenchWindow window) {
                    if (window == MozillaDebugUIPlugin.getActiveWorkbenchWindow()) {
                        window.addPerspectiveListener((IPerspectiveListener)MozillaDebugUIPlugin.this);
                        MozillaDebugUIPlugin.this.getWorkbench().removeWindowListener((IWindowListener)this);
                    }
                }

                public void windowClosed(IWorkbenchWindow window) {
                }

                public void windowDeactivated(IWorkbenchWindow window) {
                }

                public void windowOpened(IWorkbenchWindow window) {
                }
            });
        }
        this.eventListener = new EventListener();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this.eventListener);
        IAdapterManager manager = Platform.getAdapterManager();
        JSBreakpointTypeAdapterFactory typeFactory = new JSBreakpointTypeAdapterFactory();
        manager.registerAdapters((IAdapterFactory)typeFactory, JSBreakpoint.class);
    }

    public void stop(BundleContext context) throws Exception {
        IWorkbenchWindow w;
        super.stop(context);
        if (this.eventListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this.eventListener);
        }
        if ((w = MozillaDebugUIPlugin.getActiveWorkbenchWindow()) != null) {
            w.removePerspectiveListener((IPerspectiveListener)this);
        }
        _plugin = null;
        this._resourceBundle = null;
    }

    public static MozillaDebugUIPlugin getDefault() {
        return _plugin;
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = MozillaDebugUIPlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this._resourceBundle;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        IWorkbenchWindow win = null;
        IWorkbench w = MozillaDebugUIPlugin.getDefault().getWorkbench();
        if (w != null) {
            win = w.getActiveWorkbenchWindow();
        }
        return win;
    }

    public static Shell getActiveWorkbenchShell() {
        Shell s = null;
        IWorkbenchWindow win = MozillaDebugUIPlugin.getActiveWorkbenchWindow();
        if (win != null) {
            s = win.getShell();
        }
        return s;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        if (events != null) {
            int size = events.length;
            int i = 0;
            while (i < size) {
                IWorkbenchWindow window;
                Object obj;
                DebugEvent event = events[i];
                if (event.getKind() == 4 && (obj = events[i].getSource()) instanceof JSDebugElement && (window = MozillaDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow()) != null) {
                    final IWorkbenchPage page = window.getActivePage();
                    UIJob job = new UIJob("debug output"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            MozillaDebugUIPlugin.this.openJSDebugViews(page);
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                }
                ++i;
            }
        }
    }

    protected void openJSDebugViews(IWorkbenchPage page) {
        int i = 0;
        while (i < JSDEBUGVIEWS.length) {
            String viewID = JSDEBUGVIEWS[i];
            IViewPart part = page.findView(viewID);
            if (part == null) {
                try {
                    page.showView(viewID);
                }
                catch (PartInitException e) {
                    ErrorDialog.openError((Shell)page.getWorkbenchWindow().getShell(), (String)("Error Opening View <" + viewID + ">!"), (String)e.getMessage(), (IStatus)e.getStatus());
                }
            }
            ++i;
        }
    }

    public void perspectiveActivated(final IWorkbenchPage page, IPerspectiveDescriptor perspective) {
        if ("org.eclipse.debug.ui.DebugPerspective".equals(perspective.getId())) {
            IDebugTarget[] targets = DebugPlugin.getDefault().getLaunchManager().getDebugTargets();
            boolean openedViews = false;
            int i = 0;
            while (i < targets.length && !openedViews) {
                if (targets[i] instanceof JSDebugTarget) {
                    if (targets[i].isTerminated() || targets[i].isDisconnected()) break;
                    UIJob job = new UIJob("debug output"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            MozillaDebugUIPlugin.this.openJSDebugViews(page);
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                    openedViews = true;
                    break;
                }
                ++i;
            }
            DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
        } else {
            DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
        }
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
    }

    public void earlyStartup() {
    }

    public static void log(Throwable t) {
        MozillaDebugUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void log(String message) {
        MozillaDebugUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, message, (Throwable)new Exception()));
    }

    public static void log(IStatus status) {
        MozillaDebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void debug(String message) {
        if (MozillaDebugUIPlugin.getDefault().isDebugging()) {
            MozillaDebugUIPlugin.log(message);
        }
    }

    private class EventListener
    implements IDebugEventSetListener {
        private EventListener() {
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (events != null) {
                int size = events.length;
                int i = 0;
                while (i < size) {
                    UIJob job;
                    Object data;
                    Object obj;
                    DebugEvent event = events[i];
                    event.getKind();
                    if (event.getKind() == 32) {
                        obj = events[i].getSource();
                        if (obj instanceof JSDebugTarget && (data = events[i].getData()) instanceof IStatus) {
                            IStatus cfr_ignored_0 = (IStatus)data;
                            job = new UIJob("debug output"){

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    Shell shell;
                                    MessageDialog dialog;
                                    int button;
                                    IStatus status = (IStatus)data;
                                    JSDebugTarget target = (JSDebugTarget)obj;
                                    String title = MozillaDebugUIMessages.MozillaDebugUI_3;
                                    int severity = 4;
                                    String[] buttons = new String[]{MozillaDebugUIMessages.MozillaDebugUI_4, MozillaDebugUIMessages.MozillaDebugUI_5};
                                    if (status.getSeverity() == 4) {
                                        title = MozillaDebugUIMessages.MozillaDebugUI_6;
                                        severity = 1;
                                        buttons = new String[]{MozillaDebugUIMessages.MozillaDebugUI_7};
                                    }
                                    if ((button = (dialog = new MessageDialog(shell = MozillaDebugUIPlugin.getActiveWorkbenchShell(), title, null, status.getMessage(), severity, buttons, 0)).open()) == 1) {
                                        try {
                                            target.terminate();
                                        }
                                        catch (DebugException e) {
                                            String errorMessage = MozillaDebugUIMessages.MozillaDebugUI_9;
                                            status = new Status(4, "org.eclipse.atf.mozilla.ide.debug", 120, errorMessage, (Throwable)e);
                                            ErrorDialog.openError((Shell)shell, null, null, (IStatus)status);
                                        }
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            job.schedule();
                        }
                    } else if (event.getKind() == 8 && (obj = events[i].getSource()) instanceof MozBrowserProcess) {
                        data = events[i].getData();
                        job = new UIJob("debug output"){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                IWorkbenchPage activePage;
                                IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                                if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
                                    IEditorReference[] references = activePage.getEditorReferences();
                                    int j = 0;
                                    while (j < references.length) {
                                        Object browser;
                                        IEditorPart part = references[j].getEditor(false);
                                        if (part != null && (browser = part.getAdapter(Browser.class)) != null && browser == (Browser)data) {
                                            activePage.closeEditor(part, false);
                                        }
                                        ++j;
                                    }
                                }
                                return Status.OK_STATUS;
                            }
                        };
                        job.schedule();
                    }
                    ++i;
                }
            }
        }
    }
}

