/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.debug.ui.internal.adapter;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.atf.mozilla.ide.debug.MozillaDebugPlugin;
import org.eclipse.atf.mozilla.ide.debug.internal.model.JSDebugThread;
import org.eclipse.atf.mozilla.ide.debug.model.IJSDebugScriptElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.internal.ui.model.elements.ThreadContentProvider;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IPresentationContext;
import org.eclipse.debug.internal.ui.viewers.model.provisional.IViewerUpdate;

public class JSDebugThreadContentAdapter
extends ThreadContentProvider {
    protected int getChildCount(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        String id = context.getId();
        if ("org.eclipse.atf.mozilla.ide.debug.ui.scriptview".equals(id)) {
            JSDebugThread thread = (JSDebugThread)element;
            IJSDebugScriptElement[] topScripts = thread.getTopScriptElements();
            return topScripts.length;
        }
        return super.getChildCount(element, context, monitor);
    }

    protected boolean supportsContextId(String id) {
        return "org.eclipse.atf.mozilla.ide.debug.ui.scriptview".equals(id) || super.supportsContextId(id);
    }

    protected Object[] getChildren(Object parent, int index, int length, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        String id = context.getId();
        if ("org.eclipse.atf.mozilla.ide.debug.ui.scriptview".equals(id)) {
            JSDebugThread thread = (JSDebugThread)parent;
            Object[] topScripts = thread.getTopScriptElements();
            Arrays.sort(topScripts, 0, topScripts.length, new Comparator(){

                public int compare(Object val1, Object val2) {
                    try {
                        String name1 = ((IJSDebugScriptElement)val1).getName();
                        String name2 = ((IJSDebugScriptElement)val2).getName();
                        return name1.compareTo(name2);
                    }
                    catch (Exception e) {
                        MozillaDebugPlugin.log((Throwable)e);
                        return 0;
                    }
                }
            });
            return this.getElements(topScripts, index, length);
        }
        return super.getChildren(parent, index, length, context, monitor);
    }

    protected boolean hasChildren(Object element, IPresentationContext context, IViewerUpdate monitor) throws CoreException {
        String id = context.getId();
        if ("org.eclipse.atf.mozilla.ide.debug.ui.scriptview".equals(id)) {
            JSDebugThread thread = (JSDebugThread)element;
            IJSDebugScriptElement[] topScripts = thread.getTopScriptElements();
            return topScripts.length > 0;
        }
        return super.hasChildren(element, context, monitor);
    }
}

