/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventAdmin;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;
import org.eclipse.atf.mozilla.ide.ui.netmon.CallListsManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class MozIDEUIPlugin
extends AbstractUIPlugin {
    private static MozIDEUIPlugin plugin;
    public static final String PLUGIN_ID = "org.eclipse.atf.mozilla.ide.ui";
    public static final String ATF_INTERNAL = "___ATF_INTERNAL";
    public static final String DEFAULT_IMAGE_ID = "__DEFAULT";
    public static final String E_BACK_IMG_ID = "E_BACK_IMG_ID";
    public static final String D_BACK_IMG_ID = "D_BACK_IMG_ID";
    public static final String E_FORWARD_IMG_ID = "E_FORWARD_IMG_ID";
    public static final String D_FORWARD_IMG_ID = "D_FORWARD_IMG_ID";
    public static final String E_REFRESH_IMG_ID = "E_REFRESH_IMG_ID";
    public static final String D_REFRESH_IMG_ID = "D_REFRESH_IMG_ID";
    public static final String E_STOP_IMG_ID = "E_STOP_IMG_ID";
    public static final String D_STOP_IMG_ID = "D_STOP_IMG_ID";
    public static final String E_GO_IMG_ID = "E_GO_IMG_ID";
    public static final String D_GO_IMG_ID = "D_GO_IMG_ID";
    public static final String SHOWMENU_IMG_ID = "SHOWMENU_IMG_ID";
    public static final String INFO_IMG_ID = "INFO_IMG_ID";
    public static final String ERROR_IMG_ID = "ERROR_IMG_ID";
    public static final String WARNING_IMG_ID = "WARNING_IMG_ID";
    public static final String EXCEPTION_IMG_ID = "EXCEPTION_IMG_ID";
    public static final String CLEAR_IMG_ID = "CLEAR_IMG_ID";
    public static final String DOCUMENT_IMG_ID = "DOCUMENT_IMG_ID";
    public static final String ELEMENT_IMG_ID = "ELEMENT_IMG_ID";
    public static final String TEXT_IMG_ID = "TEXT_IMG_ID";
    public static final String COMMENT_IMG_ID = "COMMENT_IMG_ID";
    public static final String WAITING_IMG_ID = "WAITING_IMG_ID";
    public static final String FILTERBYNAME_IMG_ID = "FILTERBYNAME_IMG_ID";
    public static final String FILTERBYCLASS_IMG_ID = "FILTERBYCLASS_IMG_ID";
    public static final String FILTERBYID_IMG_ID = "FILTERBYID_IMG_ID";
    public static final String E_UPDATE_ID = "E_UPDATE_ID";
    public static final String E_REFRESH_ID = "E_REFRESH_ID";
    public static final String VALIDATE_ID = "VALIDATE_ID";
    public static final String HIGHLIGHT_ID = "HIGHLIGHT_ID";
    public static final String ADDPROPERTY_ID = "ADDPROPERTY_ID";
    public static final String EDITPROPERTY_ID = "EDITPROPERTY_ID";
    public static final String OPENFILE_ID = "OPENFILE_ID";
    public static final String COPYRESPONSE_ID = "COPYRESPONSE_ID";
    public static final String FILTERHTTP_ID = "FILTERHTTP_ID";
    public static final String FILTERXHR_ID = "FILTERXHR_ID";
    public static final String CSSFILTER_ID = "CSSFILTER_ID";
    public static final String HTMLFILTER_ID = "HTMLFILTER_ID";
    public static final String JSFILTER_ID = "JSFILTER_ID";
    public static final String IMGFILTER_ID = "IMGFILTER_ID";
    public static final String DONE_IMAGE = "done";
    public static final String ERROR_IMAGE = "error";
    public static final String WARNING_IMAGE = "warning";
    public static final String RUNNING_IMAGE = "waiting";
    public static final String CLOSE_TB_ID = "CLOSE_TB_ID";
    public static final String E_STARTWATCHER_ID = "E_STARTWATCHER_ID";
    public static final String D_STARTWATCHER_ID = "D_STARTWATCHER_ID";
    public static final String E_STOPWATCHER_ID = "E_STOPWATCHER_ID";
    public static final String D_STOPWATCHER_ID = "D_STOPWATCHER_ID";
    public static final String CSS_VIEWER_FONT = "CSS_VIEWER_FONT";
    private Map swtResources = new HashMap();
    private ServiceTracker appEventAdmTracker;
    private CallListsManager callListManager;

    public MozIDEUIPlugin() {
        plugin = this;
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put(DEFAULT_IMAGE_ID, MozIDEUIPlugin.getImageDescriptor("icons/sample.gif").createImage());
        reg.put(CLEAR_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/common/clear.gif"));
        reg.put(E_BACK_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/e_back.gif"));
        reg.put(D_BACK_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/d_back.gif"));
        reg.put(E_FORWARD_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/e_forward.gif"));
        reg.put(D_FORWARD_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/d_forward.gif"));
        reg.put(E_REFRESH_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/e_refresh.gif"));
        reg.put(D_REFRESH_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/d_refresh.gif"));
        reg.put(E_STOP_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/e_stop.gif"));
        reg.put(D_STOP_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/d_stop.gif"));
        reg.put(E_GO_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/e_go.gif"));
        reg.put(D_GO_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/d_go.gif"));
        reg.put(SHOWMENU_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/browser/showMenu.gif"));
        reg.put(ERROR_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/console/error.gif"));
        reg.put(EXCEPTION_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/console/exception.gif"));
        reg.put(INFO_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/console/info.gif"));
        reg.put(WARNING_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/console/warning.gif"));
        reg.put(DOCUMENT_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/inspector/document.gif"));
        reg.put(ELEMENT_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/inspector/element.gif"));
        reg.put(TEXT_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/inspector/text.gif"));
        reg.put(WAITING_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/inspector/waiting.gif"));
        reg.put(COMMENT_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/inspector/comment.gif"));
        reg.put(FILTERBYNAME_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/inspector/filterByName.gif"));
        reg.put(FILTERBYCLASS_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/inspector/filterByClass.gif"));
        reg.put(FILTERBYID_IMG_ID, MozIDEUIPlugin.getImageDescriptor("icons/inspector/filterById.gif"));
        reg.put(HIGHLIGHT_ID, MozIDEUIPlugin.getImageDescriptor("icons/css/highlight.gif"));
        reg.put(ADDPROPERTY_ID, MozIDEUIPlugin.getImageDescriptor("icons/css/add_correction.gif"));
        reg.put(EDITPROPERTY_ID, MozIDEUIPlugin.getImageDescriptor("icons/css/write_obj.gif"));
        reg.put(OPENFILE_ID, MozIDEUIPlugin.getImageDescriptor("icons/css/goto_input.gif"));
        reg.put(E_UPDATE_ID, MozIDEUIPlugin.getImageDescriptor("icons/source/e_prev_nav.gif"));
        reg.put(E_REFRESH_ID, MozIDEUIPlugin.getImageDescriptor("icons/source/e_next_nav.gif"));
        reg.put(VALIDATE_ID, MozIDEUIPlugin.getImageDescriptor("icons/source/testok.gif"));
        reg.put(COPYRESPONSE_ID, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/copy_edit.gif"));
        reg.put(FILTERHTTP_ID, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/synced.gif"));
        reg.put(FILTERXHR_ID, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/cfilter.gif"));
        reg.put(CSSFILTER_ID, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/css_filter.gif"));
        reg.put(HTMLFILTER_ID, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/html_filter.gif"));
        reg.put(JSFILTER_ID, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/js_filter.gif"));
        reg.put(IMGFILTER_ID, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/image_filter.gif"));
        reg.put(DONE_IMAGE, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/done.gif"));
        reg.put(ERROR_IMAGE, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/error.gif"));
        reg.put(WARNING_IMAGE, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/warning.gif"));
        reg.put(RUNNING_IMAGE, MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/waiting.gif"));
        reg.put(CLOSE_TB_ID, MozIDEUIPlugin.getImageDescriptor("icons/toolbar/close_toolbar.gif"));
        reg.put(E_STARTWATCHER_ID, MozIDEUIPlugin.getImageDescriptor("icons/watcher/startWatcher.gif"));
        reg.put(D_STARTWATCHER_ID, MozIDEUIPlugin.getImageDescriptor("icons/watcher/startWatcher_d.gif"));
        reg.put(E_STOPWATCHER_ID, MozIDEUIPlugin.getImageDescriptor("icons/watcher/stopWatcher.gif"));
        reg.put(D_STOPWATCHER_ID, MozIDEUIPlugin.getImageDescriptor("icons/watcher/stopWatcher_d.gif"));
    }

    public Image getImage(String imageID) {
        return this.getImageRegistry().get(imageID);
    }

    public ImageDescriptor getImageDescriptorFromRegistry(String imageID) {
        return this.getImageRegistry().getDescriptor(imageID);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initializePreferences();
        ServiceReference reference = context.getServiceReference(IApplicationEventAdmin.class.getName());
        this.appEventAdmTracker = new ServiceTracker(context, reference, null);
        this.appEventAdmTracker.open();
        this.callListManager = new CallListsManager();
        this.getApplicationEventAdmin().addEventListener((IApplicationEventListener)this.callListManager);
    }

    public void stop(BundleContext context) throws Exception {
        this.getApplicationEventAdmin().removeEventListener((IApplicationEventListener)this.callListManager);
        this.callListManager = null;
        this.appEventAdmTracker.close();
        this.disposeSWTResources();
        super.stop(context);
        plugin = null;
    }

    public CallListsManager getCallListsManager() {
        return this.callListManager;
    }

    public static MozIDEUIPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    protected void initializePreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        if (!store.contains("org.eclipse.atf.mozilla.ide.uipopupHandling")) {
            store.setDefault("org.eclipse.atf.mozilla.ide.uipopupHandling", "prompt");
        }
    }

    public static void log(Throwable t) {
        MozIDEUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, t.getMessage(), t));
    }

    public static void log(String message) {
        MozIDEUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, message, (Throwable)new Exception()));
    }

    public static void log(IStatus status) {
        MozIDEUIPlugin.getDefault().getLog().log(status);
    }

    public static void debug(String message) {
        if (MozIDEUIPlugin.getDefault().isDebugging()) {
            MozIDEUIPlugin.log(message);
        }
    }

    public static void debug(Throwable e) {
        if (MozIDEUIPlugin.getDefault().isDebugging()) {
            MozIDEUIPlugin.log(e);
        }
    }

    private Resource createSWTResource(String key) {
        if (CSS_VIEWER_FONT.equals(key)) {
            FontData fontData = new FontData("Courier New", 9, 0);
            return new Font((Device)Display.getCurrent(), fontData);
        }
        throw new IllegalArgumentException();
    }

    public Resource getSWTResource(String key) {
        Resource resource = (Resource)this.swtResources.get(key);
        if (resource == null) {
            resource = this.createSWTResource(key);
            this.swtResources.put(key, resource);
        }
        return resource;
    }

    private void disposeSWTResources() {
        for (Resource resource : this.swtResources.values()) {
            if (resource.isDisposed()) continue;
            resource.dispose();
        }
        this.swtResources.clear();
    }

    public IApplicationEventAdmin getApplicationEventAdmin() {
        return (IApplicationEventAdmin)this.appEventAdmTracker.getService();
    }
}

