/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.actions;

import org.eclipse.atf.mozilla.ide.common.IDOMNodeSelection;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;

public abstract class DOMSelectionAction
extends Action
implements IMenuListener {
    public static final String[] DOM_TYPES = new String[]{"ALL", "ELEMENT_NODE", "ATTRIBUTE_NODE", "TEXT_NODE", "CDATA_SECTION_NODE", "ENTITY_REFERENCE_NODE", "ENTITY_NODE", "PROCESSING_INSTRUCTION_NODE", "COMMENT_NODE", "DOCUMENT_NODE", "DOCUMENT_TYPE_NODE", "DOCUMENT_FRAGMENT_NODE", "NOTATION_NODE"};
    protected IDOMNodeSelection selection = null;
    protected String types = DOM_TYPES[0];
    protected String path = "";

    public void setSelection(IDOMNodeSelection selection) {
        this.selection = selection;
    }

    public IDOMNodeSelection getSelection() {
        return this.selection;
    }

    public void setTypes(String types) {
        this.types = types;
    }

    public void menuAboutToShow(IMenuManager manager) {
        if (this.selection != null && !this.selection.isEmpty()) {
            String domType = DOM_TYPES[this.selection.getSelectedNode().getNodeType()];
            boolean enabled = this.types.equals(DOM_TYPES[0]) || this.types.indexOf(domType) != -1;
            this.setEnabled(enabled);
        } else {
            this.setEnabled(false);
        }
    }

    public abstract void run();

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }
}

