/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser;

import org.eclipse.atf.mozilla.ide.core.IXPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.core.XPCOMThreadProxy;
import org.eclipse.atf.mozilla.ide.ui.XPCOMThreadProxyHelper;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMClientRect;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMElementCSSInlineStyle;
import org.mozilla.interfaces.nsIDOMNSElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsISupports;

public class SelectionBox {
    static final String DIV_NS = "http://www.w3.org/1999/xhtml";
    protected static int TOTAL_FLASH_COUNT = 3;
    protected static String FLASH_COLOR = "#FF0000";
    protected static String HOVER_COLOR = "#0000FF";
    protected static int BOX_WIDTH = 2;
    protected static int DELAY = 250;
    protected static int BOX_ZINDEX = Integer.MAX_VALUE;
    protected nsIDOMElement mainDiv = null;
    protected nsIDOMCSSStyleDeclaration mainDivStyleDecl = null;
    protected nsIDOMElement northDiv;
    protected nsIDOMElement eastDiv;
    protected nsIDOMElement southDiv;
    protected nsIDOMElement westDiv = null;
    protected nsIDOMCSSStyleDeclaration northDivStyleDecl;
    protected nsIDOMCSSStyleDeclaration eastDivStyleDecl;
    protected nsIDOMCSSStyleDeclaration southDivStyleDecl;
    protected nsIDOMCSSStyleDeclaration westDivStyleDecl = null;
    protected Object _lock = new Object();
    protected FlasherJob currentFlashJob = null;
    protected ISchedulingRule mutexRule = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public SelectionBox(nsIDOMDocument document) {
        this.mainDiv = document.createElementNS(DIV_NS, "DIV");
        this.mainDiv.setAttribute("id", "___ATF_INTERNAL_SelectionBox");
        this.mainDiv.setAttribute("class", "___ATF_INTERNAL");
        document.getDocumentElement().appendChild((nsIDOMNode)this.mainDiv);
        this.northDiv = document.createElementNS(DIV_NS, "DIV");
        this.northDiv.setAttribute("class", "___ATF_INTERNAL");
        this.mainDiv.appendChild((nsIDOMNode)this.northDiv);
        this.eastDiv = document.createElementNS(DIV_NS, "DIV");
        this.eastDiv.setAttribute("class", "___ATF_INTERNAL");
        this.mainDiv.appendChild((nsIDOMNode)this.eastDiv);
        this.southDiv = document.createElementNS(DIV_NS, "DIV");
        this.southDiv.setAttribute("class", "___ATF_INTERNAL");
        this.mainDiv.appendChild((nsIDOMNode)this.southDiv);
        this.westDiv = document.createElementNS(DIV_NS, "DIV");
        this.westDiv.setAttribute("class", "___ATF_INTERNAL");
        this.mainDiv.appendChild((nsIDOMNode)this.westDiv);
        this.mainDivStyleDecl = ((nsIDOMElementCSSInlineStyle)this.mainDiv.queryInterface("{99715845-95fc-4a56-aa53-214b65c26e22}")).getStyle();
        this.northDivStyleDecl = ((nsIDOMElementCSSInlineStyle)this.northDiv.queryInterface("{99715845-95fc-4a56-aa53-214b65c26e22}")).getStyle();
        this.eastDivStyleDecl = ((nsIDOMElementCSSInlineStyle)this.eastDiv.queryInterface("{99715845-95fc-4a56-aa53-214b65c26e22}")).getStyle();
        this.southDivStyleDecl = ((nsIDOMElementCSSInlineStyle)this.southDiv.queryInterface("{99715845-95fc-4a56-aa53-214b65c26e22}")).getStyle();
        this.westDivStyleDecl = ((nsIDOMElementCSSInlineStyle)this.westDiv.queryInterface("{99715845-95fc-4a56-aa53-214b65c26e22}")).getStyle();
        this.initDIV();
    }

    protected void initDIV() {
        this.mainDivStyleDecl.setProperty("position", "absolute", "");
        this.mainDivStyleDecl.setProperty("z-index", String.valueOf(BOX_ZINDEX), "");
        this.mainDivStyleDecl.setProperty("visibility", "hidden", "");
        this.mainDivStyleDecl.setProperty("width", "0px", "");
        this.mainDivStyleDecl.setProperty("height", "0px", "");
        this.mainDivStyleDecl.setProperty("overflow", "visible", "");
        this.northDivStyleDecl.setProperty("position", "absolute", "");
        this.eastDivStyleDecl.setProperty("position", "absolute", "");
        this.southDivStyleDecl.setProperty("position", "absolute", "");
        this.westDivStyleDecl.setProperty("position", "absolute", "");
        this.northDivStyleDecl.setProperty("left", "0px", "");
        this.northDivStyleDecl.setProperty("top", "0px", "");
        this.northDivStyleDecl.setProperty("height", String.valueOf(BOX_WIDTH) + "px", "");
        this.eastDivStyleDecl.setProperty("top", "0px", "");
        this.eastDivStyleDecl.setProperty("width", String.valueOf(BOX_WIDTH) + "px", "");
        this.southDivStyleDecl.setProperty("left", String.valueOf(BOX_WIDTH) + "px", "");
        this.southDivStyleDecl.setProperty("height", String.valueOf(BOX_WIDTH) + "px", "");
        this.westDivStyleDecl.setProperty("left", "0px", "");
        this.westDivStyleDecl.setProperty("top", String.valueOf(BOX_WIDTH) + "px", "");
        this.westDivStyleDecl.setProperty("width", String.valueOf(BOX_WIDTH) + "px", "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highlight(nsIDOMElement element, String color) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isFlashing()) {
                Rectangle bounds = this.getElementBounds(element);
                this.positionDiv(bounds.x, bounds.y, bounds.width, bounds.height);
                this.colorDiv(color);
                this.showDiv();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void highlight(nsIDOMElement element) {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isFlashing()) {
                Rectangle bounds = this.getElementBounds(element);
                this.positionDiv(bounds.x, bounds.y, bounds.width, bounds.height);
                this.colorDiv(HOVER_COLOR);
                this.showDiv();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        Object object = this._lock;
        synchronized (object) {
            if (!this.isFlashing()) {
                this.hideDiv();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flash(nsIDOMElement element) {
        Object object = this._lock;
        synchronized (object) {
            if (this.isFlashing()) {
                this.currentFlashJob.cancel();
            }
            this.currentFlashJob = new FlasherJob("FLASHING DIV", this.mainDiv);
            Rectangle bounds = this.getElementBounds(element);
            this.positionDiv(bounds.x, bounds.y, bounds.width, bounds.height);
            this.colorDiv(FLASH_COLOR);
            this.currentFlashJob.setRule(this.mutexRule);
            this.currentFlashJob.setPriority(10);
            this.currentFlashJob.schedule();
        }
    }

    protected boolean isFlashing() {
        if (this.currentFlashJob == null) {
            return false;
        }
        return this.currentFlashJob.getState() == 2 | this.currentFlashJob.getState() == 1 | this.currentFlashJob.getState() == 4;
    }

    protected void showDiv() {
        this.mainDivStyleDecl.setProperty("visibility", "visible", "");
    }

    protected void hideDiv() {
        this.mainDivStyleDecl.setProperty("visibility", "hidden", "");
    }

    protected void positionDiv(int x, int y, int width, int height) {
        height -= BOX_WIDTH;
        if ((width -= BOX_WIDTH) < 0) {
            width = 0;
        }
        if (height < 0) {
            height = 0;
        }
        this.mainDivStyleDecl.setProperty("left", String.valueOf(x) + "px", "important");
        this.mainDivStyleDecl.setProperty("top", String.valueOf(y) + "px", "important");
        this.northDivStyleDecl.setProperty("width", String.valueOf(width) + "px", "");
        this.eastDivStyleDecl.setProperty("left", String.valueOf(width) + "px", "");
        this.eastDivStyleDecl.setProperty("height", String.valueOf(height) + "px", "");
        this.southDivStyleDecl.setProperty("top", String.valueOf(height) + "px", "");
        this.southDivStyleDecl.setProperty("width", String.valueOf(width) + "px", "");
        this.westDivStyleDecl.setProperty("height", String.valueOf(height) + "px", "");
    }

    protected void colorDiv(String color) {
        this.northDivStyleDecl.setProperty("background-color", color, "");
        this.eastDivStyleDecl.setProperty("background-color", color, "");
        this.southDivStyleDecl.setProperty("background-color", color, "");
        this.westDivStyleDecl.setProperty("background-color", color, "");
    }

    protected Rectangle getElementBounds(nsIDOMElement element) {
        nsIDOMNSElement nselement = (nsIDOMNSElement)element.queryInterface("{c9da11bc-32d4-425e-a91f-7e0939c39251}");
        nsIDOMClientRect rect = nselement.getBoundingClientRect();
        nsIDOMDocument rootdocument = this.mainDiv.getOwnerDocument();
        nsIDOMElement rootElement = rootdocument.getDocumentElement();
        nsIDOMNSElement rootnsdocument = (nsIDOMNSElement)rootElement.queryInterface("{c9da11bc-32d4-425e-a91f-7e0939c39251}");
        nsIDOMClientRect rootBox = rootnsdocument.getBoundingClientRect();
        int originX = (int)rootBox.getLeft();
        int originY = (int)rootBox.getTop();
        return new Rectangle((int)rect.getLeft() - originX, (int)rect.getTop() - originY, (int)rect.getWidth(), (int)rect.getHeight());
    }

    class FlasherJob
    extends Job {
        protected nsIDOMElement flashingDIV;
        protected nsIDOMCSSStyleDeclaration styleDecl;
        protected XPCOMThreadProxyHelper proxyHelper;
        protected int flashCount;
        public boolean isOn;

        public FlasherJob(String name, nsIDOMElement flashingDIV) {
            super(name);
            this.flashingDIV = null;
            this.styleDecl = null;
            this.proxyHelper = new XPCOMThreadProxyHelper(Display.getDefault());
            this.flashCount = TOTAL_FLASH_COUNT;
            this.isOn = false;
            this.flashingDIV = (nsIDOMElement)XPCOMThreadProxy.createProxy((nsISupports)SelectionBox.this.mainDiv, (IXPCOMThreadProxyHelper)this.proxyHelper);
            nsIDOMElementCSSInlineStyle flasherElementStyles = (nsIDOMElementCSSInlineStyle)this.flashingDIV.queryInterface("{99715845-95fc-4a56-aa53-214b65c26e22}");
            this.styleDecl = flasherElementStyles.getStyle();
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.isOn) {
                this.flashOff();
                --this.flashCount;
            } else {
                this.flashOn();
            }
            if (this.flashCount > 0) {
                this.schedule(DELAY);
            }
            return Status.OK_STATUS;
        }

        private void flashOn() {
            this.styleDecl.setProperty("visibility", "visible", "");
            this.isOn = true;
        }

        private void flashOff() {
            this.styleDecl.setProperty("visibility", "hidden", "");
            this.isOn = false;
        }
    }
}

