/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.browser.views;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.views.IBrowserView;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;

public class BrowserViewExtensionManager {
    public static final String VIEW_NODE = "view";
    public static final String CLASS_ATTR = "class";
    public static final String ADAPTER_ATTR = "type";
    public static final String PRIORITY_ATTR = "priority";
    public static final String BROWSER_ATTR = "browser";
    public static final String VIEW_POINT = "org.eclipse.atf.mozilla.ide.ui.view";
    private static BrowserViewExtensionManager manager = null;
    private Map views = new HashMap();

    private BrowserViewExtensionManager() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IExtensionPoint ep = reg.getExtensionPoint(VIEW_POINT);
        IExtension[] extensions = ep.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] ce = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < ce.length) {
                if (ce[j].getName().equals(VIEW_NODE)) {
                    String view = ce[j].getAttribute(CLASS_ATTR);
                    String adapter = ce[j].getAttribute(ADAPTER_ATTR);
                    String browser = ce[j].getAttribute(BROWSER_ATTR);
                    String priority = ce[j].getAttribute(PRIORITY_ATTR);
                    if (view != null && adapter != null && browser != null) {
                        try {
                            String currentPriority;
                            Map<String, IConfigurationElement> browserViews;
                            if (this.views.containsKey(browser)) {
                                browserViews = (Map)this.views.get(browser);
                            } else {
                                browserViews = new HashMap();
                                this.views.put(browser, browserViews);
                            }
                            IConfigurationElement current = (IConfigurationElement)browserViews.get(adapter);
                            if (current == null) {
                                browserViews.put(adapter, ce[j]);
                            } else if (priority != null && ((currentPriority = current.getAttribute(PRIORITY_ATTR)) == null || priority.compareTo(currentPriority) > 0)) {
                                browserViews.put(adapter, ce[j]);
                            }
                        }
                        catch (Exception e) {
                            MozIDEUIPlugin.log(e);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static BrowserViewExtensionManager getInstance() {
        if (manager == null) {
            manager = new BrowserViewExtensionManager();
        }
        return manager;
    }

    public Object getAdapter(IWebBrowser browser, Class c) {
        IConfigurationElement element;
        Object ret = null;
        Map browserViews = null;
        if (this.views.containsKey(browser.getType().getType()) && (element = (IConfigurationElement)(browserViews = (Map)this.views.get(browser.getType().getType())).get(c.getName())) != null) {
            try {
                ret = element.createExecutableExtension(CLASS_ATTR);
                if (ret instanceof IBrowserView) {
                    ((IBrowserView)ret).setWebBrowser(browser);
                }
            }
            catch (Exception exception) {}
        }
        return ret;
    }
}

