/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.console;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.atf.mozilla.ide.core.util.SourceLocatorUtil;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.console.ConsoleCategoryFilter;
import org.eclipse.atf.mozilla.ide.ui.console.ConsoleMessageFilter;
import org.eclipse.atf.mozilla.ide.ui.console.ConsoleMessageLabelProvider;
import org.eclipse.atf.mozilla.ide.ui.console.IJavaScriptConsole;
import org.eclipse.atf.mozilla.ide.ui.util.SourceDisplayUtil;
import org.eclipse.core.resources.IStorage;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.Page;
import org.mozilla.interfaces.nsIConsoleMessage;

public class JavaScriptConsolePage
extends Page
implements IJavaScriptConsole {
    protected TableViewer tableViewer = null;
    protected Action showErrorsAction = null;
    protected Action showWarningsAction = null;
    protected Action showMessagesAction = null;
    protected Action clearConsoleAction = null;
    protected Action showCSSMessages = null;
    protected Action showJSMessages = null;
    protected Action showXMLMessages = null;
    protected ConsoleMessageFilter filter = null;
    protected ConsoleCategoryFilter catFilter = null;
    protected List messages = new ArrayList();
    protected SourceLocatorUtil locatorUtil = SourceLocatorUtil.getInstance();
    protected SourceDisplayUtil sourceDisplayUtil = new SourceDisplayUtil();
    private ConsoleMessageLabelProvider labelProvider;

    public void createControl(Composite parent) {
        this.tableViewer = new TableViewer(parent, 66308);
        this.styleTable(this.tableViewer.getTable());
        this.createColumns(this.tableViewer.getTable());
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.labelProvider = new ConsoleMessageLabelProvider();
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.tableViewer.setInput((Object)this.messages);
        this.filter = new ConsoleMessageFilter();
        this.filter.setShowMode(0);
        this.tableViewer.addFilter((ViewerFilter)this.filter);
        this.catFilter = new ConsoleCategoryFilter();
        this.catFilter.displayCSS(true);
        this.catFilter.displayJavascript(true);
        this.catFilter.displayXML(true);
        this.tableViewer.addFilter((ViewerFilter)this.catFilter);
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                if (selection instanceof IStructuredSelection) {
                    nsIConsoleMessage selectedMessage = (nsIConsoleMessage)((IStructuredSelection)selection).getFirstElement();
                    String sourceName = ConsoleMessageLabelProvider.getSourceName(selectedMessage);
                    int line = ConsoleMessageLabelProvider.getLineNum(selectedMessage);
                    if (sourceName != null) {
                        try {
                            JavaScriptConsolePage.this.openInEditor(new URL(sourceName), line);
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
        });
        this.createActions();
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.showErrorsAction);
        toolBarManager.add((IAction)this.showWarningsAction);
        toolBarManager.add((IAction)this.showMessagesAction);
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.clearConsoleAction);
        IMenuManager menuManager = this.getSite().getActionBars().getMenuManager();
        menuManager.add((IAction)this.showCSSMessages);
        menuManager.add((IAction)this.showJSMessages);
        menuManager.add((IAction)this.showXMLMessages);
    }

    public Control getControl() {
        if (this.tableViewer == null) {
            return null;
        }
        return this.tableViewer.getControl();
    }

    public void setFocus() {
        this.tableViewer.getControl().setFocus();
    }

    protected void styleTable(Table table) {
        table.setLinesVisible(true);
        table.setFont(table.getParent().getFont());
    }

    protected void createColumns(Table table) {
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(20));
        TableColumn tc = new TableColumn(table, 0, 0);
        tc.setMoveable(false);
        tc.setResizable(false);
        tc.setAlignment(131072);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, true));
        tc = new TableColumn(table, 0, 1);
        tc.setText("Message");
        tc.setMoveable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(25, true));
        tc = new TableColumn(table, 0, 2);
        tc.setText("File");
        tc.setMoveable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, true));
        tc = new TableColumn(table, 0, 3);
        tc.setText("Line Number");
        tc.setMoveable(true);
    }

    protected void createActions() {
        this.showCSSMessages = new Action("Show CSS messages", 2){

            public void run() {
                JavaScriptConsolePage.this.catFilter.displayCSS(this.isChecked());
                if (JavaScriptConsolePage.this.tableViewer != null && !JavaScriptConsolePage.this.tableViewer.getControl().isDisposed()) {
                    JavaScriptConsolePage.this.tableViewer.refresh();
                }
            }
        };
        this.showCSSMessages.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("CSSFILTER_ID"));
        this.showCSSMessages.setChecked(true);
        this.showJSMessages = new Action("Show Javascript messages", 2){

            public void run() {
                JavaScriptConsolePage.this.catFilter.displayJavascript(this.isChecked());
                if (JavaScriptConsolePage.this.tableViewer != null && !JavaScriptConsolePage.this.tableViewer.getControl().isDisposed()) {
                    JavaScriptConsolePage.this.tableViewer.refresh();
                }
            }
        };
        this.showJSMessages.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("JSFILTER_ID"));
        this.showJSMessages.setChecked(true);
        this.showXMLMessages = new Action("Show XML messages", 2){

            public void run() {
                JavaScriptConsolePage.this.catFilter.displayXML(this.isChecked());
                if (JavaScriptConsolePage.this.tableViewer != null && !JavaScriptConsolePage.this.tableViewer.getControl().isDisposed()) {
                    JavaScriptConsolePage.this.tableViewer.refresh();
                }
            }
        };
        this.showXMLMessages.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("HTMLFILTER_ID"));
        this.showXMLMessages.setChecked(true);
        this.showErrorsAction = new Action("Errors", 2){

            public void run() {
                if (this.isChecked()) {
                    JavaScriptConsolePage.this.setShowMode(1);
                    if (JavaScriptConsolePage.this.showWarningsAction.isChecked()) {
                        JavaScriptConsolePage.this.showWarningsAction.setChecked(false);
                    } else if (JavaScriptConsolePage.this.showMessagesAction.isChecked()) {
                        JavaScriptConsolePage.this.showMessagesAction.setChecked(false);
                    }
                } else {
                    JavaScriptConsolePage.this.setShowMode(0);
                }
            }
        };
        this.showErrorsAction.setText("Errors");
        this.showErrorsAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("ERROR_IMG_ID"));
        this.showErrorsAction.setToolTipText("Show only errors.");
        this.showErrorsAction.setChecked(false);
        this.showWarningsAction = new Action("Warnings", 2){

            public void run() {
                if (this.isChecked()) {
                    JavaScriptConsolePage.this.setShowMode(2);
                    if (JavaScriptConsolePage.this.showErrorsAction.isChecked()) {
                        JavaScriptConsolePage.this.showErrorsAction.setChecked(false);
                    } else if (JavaScriptConsolePage.this.showMessagesAction.isChecked()) {
                        JavaScriptConsolePage.this.showMessagesAction.setChecked(false);
                    }
                } else {
                    JavaScriptConsolePage.this.setShowMode(0);
                }
            }
        };
        this.showWarningsAction.setText("Warnings");
        this.showWarningsAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("WARNING_IMG_ID"));
        this.showWarningsAction.setToolTipText("Show only warnings.");
        this.showWarningsAction.setChecked(false);
        this.showMessagesAction = new Action("Info", 2){

            public void run() {
                if (this.isChecked()) {
                    JavaScriptConsolePage.this.setShowMode(3);
                    if (JavaScriptConsolePage.this.showErrorsAction.isChecked()) {
                        JavaScriptConsolePage.this.showErrorsAction.setChecked(false);
                    } else if (JavaScriptConsolePage.this.showWarningsAction.isChecked()) {
                        JavaScriptConsolePage.this.showWarningsAction.setChecked(false);
                    }
                } else {
                    JavaScriptConsolePage.this.setShowMode(0);
                }
            }
        };
        this.showMessagesAction.setText("Info");
        this.showMessagesAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("INFO_IMG_ID"));
        this.showMessagesAction.setToolTipText("Show only info messages.");
        this.showMessagesAction.setChecked(false);
        this.clearConsoleAction = new Action(){

            public void run() {
                JavaScriptConsolePage.this.clearMessages();
            }
        };
        this.clearConsoleAction.setText("Clear");
        this.clearConsoleAction.setImageDescriptor(MozIDEUIPlugin.getDefault().getImageDescriptorFromRegistry("CLEAR_IMG_ID"));
        this.clearConsoleAction.setToolTipText("Clear all messages.");
    }

    public void logConsoleMessage(String message) {
        Object messageToRemove = null;
        if (this.messages.size() == 250) {
            messageToRemove = this.messages.remove(0);
        }
        this.messages.add(message);
        if (this.tableViewer != null && !this.tableViewer.getControl().isDisposed()) {
            if (messageToRemove != null) {
                this.tableViewer.remove(messageToRemove);
            }
            this.tableViewer.add((Object)message);
            this.tableViewer.reveal((Object)message);
        }
    }

    public void logConsoleMessage(nsIConsoleMessage message) {
        Object messageToRemove = null;
        if (this.messages.size() == 250) {
            messageToRemove = this.messages.remove(0);
        }
        this.messages.add(message);
        if (this.tableViewer != null && !this.tableViewer.getControl().isDisposed()) {
            if (messageToRemove != null) {
                this.tableViewer.remove(messageToRemove);
            }
            this.tableViewer.add((Object)message);
            this.tableViewer.reveal((Object)message);
        }
    }

    public void clearMessages() {
        this.messages.clear();
        if (this.tableViewer != null && !this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    public void setShowMode(int mode) {
        this.filter.setShowMode(mode);
        if (this.tableViewer != null && !this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.refresh();
        }
    }

    private void openInEditor(URL sourceURL, int lineNumber) {
        IStorage source = this.locatorUtil.getSourceElement(sourceURL);
        if (source != null) {
            try {
                this.sourceDisplayUtil.openInEditor(this.sourceDisplayUtil.getEditorInput(source), lineNumber);
            }
            catch (PartInitException e) {
                MozIDEUIPlugin.log(e);
            }
        }
    }

    static /* synthetic */ ConsoleMessageLabelProvider access$0(JavaScriptConsolePage javaScriptConsolePage) {
        return javaScriptConsolePage.labelProvider;
    }
}

