/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.css;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.core.IXPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.core.XPCOMThreadProxy;
import org.eclipse.atf.mozilla.ide.events.DOMMutationListener;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.XPCOMThreadProxyHelper;
import org.eclipse.atf.mozilla.ide.ui.browser.SelectionBox;
import org.eclipse.atf.mozilla.ide.ui.css.CSSProperty;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Display;
import org.mozilla.interfaces.inIDOMUtils;
import org.mozilla.interfaces.nsIDOMCSSRule;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMCSSStyleRule;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsISupportsArray;
import org.mozilla.xpcom.Mozilla;

public class CSSPropertyLocator {
    private XPCOMThreadProxyHelper proxyHelper = new XPCOMThreadProxyHelper(Display.getDefault());
    private nsIDOMDocument document;
    private boolean on = false;
    private List<SelectionBox> boxes = new ArrayList<SelectionBox>();
    private CSSJobSearch cts = new CSSJobSearch();
    private IWebBrowser container;
    private nsIDOMNode currNode;
    private nsIDOMElement currElement;
    private DOMMutationListener domMutationListener = new DOMMutationListener(){

        public void attributeAdded(nsIDOMElement ownerElement, String attributeName) {
            if (CSSPropertyLocator.this.currElement != null && CSSPropertyLocator.this.currElement.equals(ownerElement) && attributeName.equals("style")) {
                CSSPropertyLocator.this.addAttribute((nsIDOMNode)ownerElement);
            }
        }

        public void attributeModified(nsIDOMElement ownerElement, String attributeName, String newValue, String previousValue) {
            if (CSSPropertyLocator.this.currElement != null && CSSPropertyLocator.this.currElement.equals(ownerElement) && attributeName.equals("style")) {
                CSSPropertyLocator.this.addAttribute((nsIDOMNode)ownerElement);
            }
        }

        public void attributeRemoved(nsIDOMElement ownerElement, String attributeName) {
            if (CSSPropertyLocator.this.currElement != null && CSSPropertyLocator.this.currElement.equals(ownerElement) && attributeName.equals("style")) {
                CSSPropertyLocator.this.removeAttribute(ownerElement);
            }
        }

        public void nodeInserted(nsIDOMNode parentNode, nsIDOMNode insertedNode) {
            CSSPropertyLocator.this.add(insertedNode);
            CSSPropertyLocator.this.addAttribute(insertedNode);
        }

        public void nodeRemoved(nsIDOMNode parentNode, nsIDOMNode removedNode) {
            CSSPropertyLocator.this.remove(removedNode);
        }
    };
    private List<nsIDOMNode> removed = new ArrayList<nsIDOMNode>();

    public void add(nsIDOMNode node) {
        if (node.getNodeType() == 1) {
            try {
                nsIDOMElement e = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                inIDOMUtils service = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}");
                nsISupportsArray rules = service.getCSSStyleRules(e);
                long numRules = rules.count();
                nsIDOMCSSStyleDeclaration styleDec = null;
                long i = 0L;
                while (i < numRules) {
                    nsIDOMCSSRule ret = (nsIDOMCSSRule)rules.getElementAt(i).queryInterface("{a6cf90c1-15b3-11d2-932e-00805f8add32}");
                    nsIDOMCSSStyleRule styleRule = (nsIDOMCSSStyleRule)ret.queryInterface("{a6cf90bf-15b3-11d2-932e-00805f8add32}");
                    styleDec = styleRule.getStyle();
                    String lineNumber = Long.toString(service.getRuleLine(styleRule));
                    String url = styleRule.getParentStyleSheet().getHref();
                    long j = 0L;
                    while (j < styleDec.getLength()) {
                        String name = styleDec.item(j);
                        String value = styleDec.getPropertyValue(name);
                        CSSProperty cssProperty = new CSSProperty(name, value, url, lineNumber, styleRule.getSelectorText());
                        ArrayList<nsIDOMElement> ruleProperties = (ArrayList<nsIDOMElement>)this.cts.rulesToProperties.get(String.valueOf(cssProperty.getURL()) + cssProperty.getRule());
                        if (ruleProperties == null) {
                            ruleProperties = new ArrayList<nsIDOMElement>();
                            this.cts.rulesToProperties.put(String.valueOf(cssProperty.getURL()) + cssProperty.getRule(), ruleProperties);
                        }
                        if (!ruleProperties.contains(e)) {
                            ruleProperties.add(e);
                        }
                        String rulesToElementsKey = String.valueOf(cssProperty.getURL()) + cssProperty.getRule() + cssProperty.getName();
                        ArrayList<nsIDOMElement> elements = (ArrayList<nsIDOMElement>)this.cts.rulesToElements.get(rulesToElementsKey);
                        if (elements == null) {
                            elements = new ArrayList<nsIDOMElement>();
                            this.cts.rulesToElements.put(rulesToElementsKey, elements);
                        }
                        elements.add(e);
                        HashMap<nsIDOMElement, String> elementsToRules = (HashMap<nsIDOMElement, String>)this.cts.cssProperties.get(cssProperty.getName());
                        if (elementsToRules == null) {
                            elementsToRules = new HashMap<nsIDOMElement, String>();
                            this.cts.cssProperties.put(cssProperty.getName(), elementsToRules);
                        }
                        elementsToRules.put(e, rulesToElementsKey);
                        ++j;
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }
    }

    public void remove(nsIDOMNode node) {
        if (node.getNodeType() == 1) {
            this.removed.add(node);
        }
    }

    public void load(IJobChangeListener listener) {
        nsIDOMNode node = this.document.getElementsByTagName("HTML").item(0L);
        if (this.cts.getState() == 4) {
            this.cts.cancel();
            try {
                this.cts.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.cts.setNode(node);
        this.cts.setPriority(40);
        this.cts.addJobChangeListener(listener);
        this.cts.schedule();
    }

    public void disable() {
        for (SelectionBox box : this.boxes) {
            box.hide();
        }
        if (this.cts != null) {
            this.cts.cancel();
        }
        this.boxes.clear();
        this.on = false;
    }

    public void match(CSSProperty property) {
        if (this.on) {
            this.disable();
        } else {
            if (this.cts.getResult() == null) {
                return;
            }
            if (!property.isRule() && !property.isInline()) {
                List elements = (List)this.cts.rulesToElements.get(String.valueOf(property.getURL()) + property.getRule() + property.getName());
                if (elements != null) {
                    for (nsIDOMElement e : elements) {
                        String rule;
                        Map elementsToRules = (Map)this.cts.cssProperties.get(property.getName());
                        if (elementsToRules == null || elementsToRules.get(e) == null || !(rule = String.valueOf(property.getURL()) + property.getRule() + property.getName()).equals((String)elementsToRules.get(e)) || this.removed.contains(e)) continue;
                        SelectionBox box = new SelectionBox(this.document);
                        box.highlight(e, "#00FF00");
                        this.boxes.add(box);
                    }
                }
            } else if (!property.isInline()) {
                List elements = (List)this.cts.rulesToProperties.get(String.valueOf(property.getURL()) + property.getRule());
                if (elements != null) {
                    for (nsIDOMElement e : elements) {
                        if (this.removed.contains(e)) continue;
                        SelectionBox box = new SelectionBox(this.document);
                        box.highlight(e, "#00FF00");
                        this.boxes.add(box);
                    }
                }
            } else if (!this.removed.contains(this.currNode)) {
                SelectionBox box = new SelectionBox(this.document);
                box.highlight((nsIDOMElement)this.currNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}"), "#00FF00");
                this.boxes.add(box);
            }
            this.on = true;
        }
    }

    public void addAttribute(nsIDOMNode node) {
        if (node.getNodeType() == 1) {
            try {
                StringTokenizer token;
                nsIDOMElement e = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                String inlineStyle = e.getAttribute("style");
                if (inlineStyle != null && !inlineStyle.equals("") && (token = new StringTokenizer(inlineStyle, ";")).hasMoreTokens()) {
                    while (token.hasMoreTokens()) {
                        String cssDec = token.nextToken();
                        if (cssDec.indexOf(58) == -1) continue;
                        String name = cssDec.substring(0, cssDec.indexOf(58));
                        name = name.trim();
                        String value = cssDec.substring(cssDec.indexOf(58) + 1, cssDec.length());
                        value = value.trim();
                        CSSProperty cssProperty = new CSSProperty(name, value, "", "", "Inline_Styles");
                        cssProperty.setInline(true);
                        cssProperty.setPresent(true);
                        cssProperty.setProperty(true);
                        HashMap<nsIDOMElement, String> elementsToRules = (HashMap<nsIDOMElement, String>)this.cts.cssProperties.get(cssProperty.getName());
                        if (elementsToRules == null) {
                            elementsToRules = new HashMap<nsIDOMElement, String>();
                            this.cts.cssProperties.put(cssProperty.getName(), elementsToRules);
                        }
                        elementsToRules.put(e, String.valueOf(cssProperty.getURL()) + cssProperty.getRule() + cssProperty.getName());
                    }
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }
    }

    public void removeAttribute(nsIDOMElement domElement) {
        this.add((nsIDOMNode)domElement);
    }

    public void setDocumentContainer(IWebBrowser doc) {
        nsIDOMDocument newDocument = doc.getDocument();
        this.document = (nsIDOMDocument)XPCOMThreadProxy.createProxy((nsISupports)newDocument, (IXPCOMThreadProxyHelper)this.proxyHelper);
        if (this.container != null) {
            MozIDEUIPlugin.getDefault().getApplicationEventAdmin().removeEventListener(this.container, (IApplicationEventListener)this.domMutationListener);
        }
        this.container = doc;
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().addEventListener(this.container, (IApplicationEventListener)this.domMutationListener);
    }

    public void setNode(nsIDOMNode node) {
        this.currNode = node;
        this.currElement = (nsIDOMElement)this.currNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
    }

    public nsIDOMDocument getDocument() {
        return this.document;
    }

    public void dispose() {
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().removeEventListener(this.container, (IApplicationEventListener)this.domMutationListener);
    }

    private class CSSJobSearch
    extends Job {
        private nsIDOMNode node;
        private Map<String, Map<nsIDOMElement, String>> cssProperties;
        private Map<String, List<nsIDOMElement>> rulesToElements;
        private Map<String, List<nsIDOMElement>> rulesToProperties;
        private inIDOMUtils service;

        public CSSJobSearch() {
            super("Indexing CSS for page ");
            this.cssProperties = new HashMap<String, Map<nsIDOMElement, String>>();
            this.rulesToElements = new HashMap<String, List<nsIDOMElement>>();
            this.rulesToProperties = new HashMap<String, List<nsIDOMElement>>();
            this.service = (inIDOMUtils)XPCOMThreadProxy.createProxy((nsISupports)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}"), (IXPCOMThreadProxyHelper)CSSPropertyLocator.this.proxyHelper);
        }

        public void setNode(nsIDOMNode node) {
            this.node = (nsIDOMNode)XPCOMThreadProxy.createProxy((nsISupports)node, (IXPCOMThreadProxyHelper)CSSPropertyLocator.this.proxyHelper);
        }

        public IStatus run(IProgressMonitor monitor) {
            this.reset();
            IStatus result = this.parse(this.node, monitor);
            return result;
        }

        private IStatus parse(nsIDOMNode node, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (node.getNodeType() != 1) {
                return Status.OK_STATUS;
            }
            try {
                nsIDOMElement e = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
                nsISupportsArray rules = null;
                if (e != null && this.service != null) {
                    rules = this.service.getCSSStyleRules(e);
                }
                if (rules != null) {
                    long numRules = rules.count();
                    long i = 0L;
                    while (i < numRules) {
                        if (monitor.isCanceled()) {
                            return Status.CANCEL_STATUS;
                        }
                        nsIDOMCSSRule ret = (nsIDOMCSSRule)rules.getElementAt(i).queryInterface("{a6cf90c1-15b3-11d2-932e-00805f8add32}");
                        this.parseDOMCSSRule(e, ret);
                        ++i;
                    }
                }
                String inlineStyle = e.getAttribute("style");
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (inlineStyle != null && !inlineStyle.equals("")) {
                    this.parseInlineStyle(e, inlineStyle);
                }
                nsIDOMNodeList list = e.getChildNodes();
                int i = 0;
                while ((long)i < list.getLength()) {
                    this.parse(list.item((long)i), monitor);
                    ++i;
                }
            }
            catch (Exception ex) {
                MozIDEUIPlugin.log(ex);
            }
            return Status.OK_STATUS;
        }

        private void parseDOMCSSRule(nsIDOMElement e, nsIDOMCSSRule ret) {
            nsIDOMCSSStyleRule styleRule = (nsIDOMCSSStyleRule)ret.queryInterface("{a6cf90bf-15b3-11d2-932e-00805f8add32}");
            String ruleSelectorText = styleRule.getSelectorText();
            nsIDOMCSSStyleDeclaration styleDec = styleRule.getStyle();
            String lineNumber = Long.toString(this.service.getRuleLine(styleRule));
            String url = styleRule.getParentStyleSheet().getHref();
            long j = 0L;
            while (j < styleDec.getLength()) {
                String rulesToElementsKey;
                List<nsIDOMElement> ruleElements;
                String value;
                String name = styleDec.item(j);
                CSSProperty cssProperty = new CSSProperty(name, value = styleDec.getPropertyValue(name), url, lineNumber, ruleSelectorText);
                List<nsIDOMElement> ruleProperties = this.rulesToProperties.get(String.valueOf(cssProperty.getURL()) + cssProperty.getRule());
                if (ruleProperties == null) {
                    ruleProperties = new ArrayList<nsIDOMElement>();
                    this.rulesToProperties.put(String.valueOf(cssProperty.getURL()) + cssProperty.getRule(), ruleProperties);
                }
                if (!ruleProperties.contains(e)) {
                    ruleProperties.add(e);
                }
                if ((ruleElements = this.rulesToElements.get(rulesToElementsKey = String.valueOf(cssProperty.getURL()) + cssProperty.getRule() + cssProperty.getName())) == null) {
                    ruleElements = new ArrayList<nsIDOMElement>();
                    this.rulesToElements.put(rulesToElementsKey, ruleElements);
                }
                ruleElements.add(e);
                Map<nsIDOMElement, String> elementsToRules = this.cssProperties.get(cssProperty.getName());
                if (elementsToRules == null) {
                    elementsToRules = new HashMap<nsIDOMElement, String>();
                    this.cssProperties.put(cssProperty.getName(), elementsToRules);
                }
                elementsToRules.put(e, rulesToElementsKey);
                ++j;
            }
        }

        private void parseInlineStyle(nsIDOMElement e, String inlineStyle) {
            StringTokenizer token = new StringTokenizer(inlineStyle, ";");
            if (token.hasMoreTokens()) {
                while (token.hasMoreTokens()) {
                    String cssDec = token.nextToken();
                    if (cssDec.indexOf(58) == -1) continue;
                    String name = cssDec.substring(0, cssDec.indexOf(58));
                    name = name.trim();
                    String value = cssDec.substring(cssDec.indexOf(58) + 1, cssDec.length());
                    value = value.trim();
                    CSSProperty cssProperty = new CSSProperty(name, value, "", "", "Inline_Styles");
                    cssProperty.setInline(true);
                    cssProperty.setPresent(true);
                    cssProperty.setProperty(true);
                    Map<nsIDOMElement, String> elementsToRules = this.cssProperties.get(cssProperty.getName());
                    if (elementsToRules == null) {
                        elementsToRules = new HashMap<nsIDOMElement, String>();
                        this.cssProperties.put(cssProperty.getName(), elementsToRules);
                    }
                    elementsToRules.put(e, String.valueOf(cssProperty.getURL()) + cssProperty.getRule() + cssProperty.getName());
                }
            }
        }

        private void reset() {
            this.rulesToElements.clear();
            this.rulesToProperties.clear();
            this.cssProperties.clear();
        }
    }
}

