/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.css;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.css.CSSContentProvider;
import org.eclipse.atf.mozilla.ide.ui.css.CSSProperty;
import org.eclipse.jface.viewers.Viewer;
import org.mozilla.interfaces.inIDOMUtils;
import org.mozilla.interfaces.nsIDOMCSSRule;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMCSSStyleRule;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMViewCSS;
import org.mozilla.interfaces.nsISupportsArray;
import org.mozilla.xpcom.Mozilla;

public class StyleRulesContentProvider
extends CSSContentProvider {
    private Map originals = new TreeMap();
    private Map modifieds = new TreeMap();
    private String original;
    private String modified;
    private Set propertyNamesCache;
    private List modifiedStyleSheets = new ArrayList();

    public boolean isPropertyName(String name) {
        if (this.propertyNamesCache == null) {
            HashSet<String> tmp = new HashSet<String>();
            nsIDOMElement domElement = (nsIDOMElement)this.currentNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocumentView documentView = (nsIDOMDocumentView)domElement.getOwnerDocument().queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
            nsIDOMViewCSS cssView = (nsIDOMViewCSS)documentView.getDefaultView().queryInterface("{0b9341f3-95d4-4fa4-adcd-e119e0db2889}");
            nsIDOMCSSStyleDeclaration computedStyle = cssView.getComputedStyle(domElement, "");
            int i = 0;
            while ((long)i < computedStyle.getLength()) {
                String aName = computedStyle.item((long)i);
                tmp.add(aName);
                while (aName.lastIndexOf(45) > -1) {
                    aName = aName.substring(0, aName.lastIndexOf(45));
                    tmp.add(aName);
                }
                ++i;
            }
            this.propertyNamesCache = tmp;
        }
        return this.propertyNamesCache.contains(name);
    }

    public void updateProperty(CSSProperty newProperty) {
        nsIDOMCSSStyleDeclaration rule = (nsIDOMCSSStyleDeclaration)this.propertiesToRules.get(newProperty.getHash());
        if (rule != null) {
            this.modifiedStyleSheets.add(rule);
            rule.setProperty(newProperty.getName(), newProperty.getValue(), "");
        } else if (newProperty.isInline()) {
            nsIDOMElement domElement = (nsIDOMElement)this.currentNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            List properties = (List)this.nodeMap.get(new CSSProperty("", "", "", "", "Inline_Styles"));
            Iterator iter = properties.iterator();
            String styleAttribute = "";
            if (newProperty.isNewRule()) {
                styleAttribute = String.valueOf(styleAttribute) + newProperty.getName() + ":" + newProperty.getValue() + ";";
            }
            while (iter.hasNext()) {
                CSSProperty prop = (CSSProperty)iter.next();
                styleAttribute = !prop.getName().equals(newProperty.getName()) ? String.valueOf(styleAttribute) + prop.getName() + ":" + prop.getValue() + ";" : String.valueOf(styleAttribute) + newProperty.getName() + ":" + newProperty.getValue() + ";";
            }
            domElement.setAttribute("style", styleAttribute);
        }
        this.saveDiffs(newProperty);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput != null) {
            if (newInput instanceof CSSProperty) {
                this.updateProperty((CSSProperty)newInput);
            } else if (newInput instanceof nsIDOMNode) {
                this.currentNode = (nsIDOMNode)newInput;
                this.parseNodes();
            }
        }
    }

    public void deleteProperty(CSSProperty property) {
        nsIDOMCSSStyleDeclaration rule = (nsIDOMCSSStyleDeclaration)this.propertiesToRules.get(property.getHash());
        if (rule != null) {
            rule.removeProperty(property.getName());
        } else {
            nsIDOMElement domElement = (nsIDOMElement)this.currentNode.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
            List properties = (List)this.nodeMap.get(new CSSProperty("", "", "", "", "Inline_Styles"));
            Iterator iter = properties.iterator();
            String styleAttribute = "";
            while (iter.hasNext()) {
                CSSProperty prop = (CSSProperty)iter.next();
                if (prop.getName().equals(property.getName())) continue;
                styleAttribute = String.valueOf(styleAttribute) + prop.getName() + ":" + prop.getValue() + ";";
            }
            if (styleAttribute.equals("")) {
                domElement.removeAttribute("style");
            } else {
                domElement.setAttribute("style", styleAttribute);
            }
        }
        this.saveDiffs(property);
    }

    private void saveDiffs(CSSProperty newProperty) {
        String value = newProperty.getOriginalValue();
        if (newProperty.isNewRule()) {
            value = "(**Property Added)";
        }
        if (!this.originals.containsKey(String.valueOf(this.formatURL(newProperty.getURL())) + "\n" + newProperty.getRule())) {
            TreeMap<String, String> cssProperties = new TreeMap<String, String>();
            cssProperties.put(newProperty.getOriginalName(), value);
            this.originals.put(String.valueOf(this.formatURL(newProperty.getURL())) + "\n" + newProperty.getRule(), cssProperties);
        } else {
            Map cssProperties = (Map)this.originals.get(String.valueOf(this.formatURL(newProperty.getURL())) + "\n" + newProperty.getRule());
            if (!cssProperties.containsKey(newProperty.getOriginalName())) {
                cssProperties.put(newProperty.getOriginalName(), value);
            }
        }
    }

    public void createDiff() {
        StringTokenizer token;
        this.modifieds.clear();
        nsIDOMNode node = this.currentNode;
        nsIDOMElement domElement = (nsIDOMElement)node.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}");
        try {
            inIDOMUtils service = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}");
            nsISupportsArray rules = service.getCSSStyleRules(domElement);
            long numRules = rules.count();
            long i = 0L;
            while (i < numRules) {
                nsIDOMCSSRule ret = (nsIDOMCSSRule)rules.getElementAt(i).queryInterface("{a6cf90c1-15b3-11d2-932e-00805f8add32}");
                nsIDOMCSSStyleRule styleRule = (nsIDOMCSSStyleRule)ret.queryInterface("{a6cf90bf-15b3-11d2-932e-00805f8add32}");
                nsIDOMCSSStyleDeclaration styleDec = styleRule.getStyle();
                String lineNumber = Long.toString(service.getRuleLine(styleRule));
                String url = styleRule.getParentStyleSheet().getHref();
                long j = 0L;
                while (j < styleDec.getLength()) {
                    Map<String, String> properties;
                    String value;
                    String name = styleDec.item(j);
                    CSSProperty cssProperty = new CSSProperty(name, value = styleDec.getPropertyValue(name), url, lineNumber, styleRule.getSelectorText());
                    if (this.modifieds.containsKey(String.valueOf(this.formatURL(cssProperty.getURL())) + "\n" + cssProperty.getRule())) {
                        properties = (Map)this.modifieds.get(String.valueOf(this.formatURL(cssProperty.getURL())) + "\n" + cssProperty.getRule());
                        properties.put(cssProperty.getName(), cssProperty.getValue());
                    } else {
                        properties = new TreeMap<String, String>();
                        properties.put(cssProperty.getName(), cssProperty.getValue());
                        this.modifieds.put(String.valueOf(this.formatURL(cssProperty.getURL())) + "\n" + cssProperty.getRule(), properties);
                    }
                    ++j;
                }
                ++i;
            }
        }
        catch (Exception e) {
            MozIDEUIPlugin.log(e);
        }
        String inlineStyle = domElement.getAttribute("style");
        if (inlineStyle != null && !inlineStyle.equals("") && (token = new StringTokenizer(inlineStyle, ";")).hasMoreTokens()) {
            while (token.hasMoreTokens()) {
                Map<String, String> properties;
                String cssDec = token.nextToken();
                if (cssDec.indexOf(58) == -1) continue;
                String name = cssDec.substring(0, cssDec.indexOf(58));
                name = name.trim();
                String value = cssDec.substring(cssDec.indexOf(58) + 1, cssDec.length());
                value = value.trim();
                CSSProperty inlineProperty = new CSSProperty(name, value, "", "", "Inline_Styles");
                if (this.modifieds.containsKey(String.valueOf(this.formatURL("")) + "\n" + "Inline_Styles")) {
                    properties = (Map)this.modifieds.get(String.valueOf(this.formatURL("")) + "\n" + "Inline_Styles");
                    properties.put(inlineProperty.getName(), inlineProperty.getValue());
                    continue;
                }
                properties = new TreeMap<String, String>();
                properties.put(inlineProperty.getName(), inlineProperty.getValue());
                this.modifieds.put(String.valueOf(this.formatURL("")) + "\n" + "Inline_Styles", properties);
            }
        }
    }

    public void generateGlobalDiff() {
        this.modifieds.clear();
        Iterator iter = this.modifiedStyleSheets.iterator();
        inIDOMUtils service = (inIDOMUtils)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/inspector/dom-utils;1", "{78fd16c2-bdfb-4b1d-8738-d536d0a8f430}");
        while (iter.hasNext()) {
            try {
                nsIDOMCSSStyleDeclaration styleDec = (nsIDOMCSSStyleDeclaration)iter.next();
                nsIDOMCSSStyleRule styleRule = (nsIDOMCSSStyleRule)styleDec.getParentRule().queryInterface("{a6cf90bf-15b3-11d2-932e-00805f8add32}");
                String lineNumber = Long.toString(service.getRuleLine(styleRule));
                String url = styleRule.getParentStyleSheet().getHref();
                long i = 0L;
                while (i < styleDec.getLength()) {
                    Map<String, String> properties;
                    String value;
                    String name = styleDec.item(i);
                    CSSProperty cssProperty = new CSSProperty(name, value = styleDec.getPropertyValue(name), url, lineNumber, styleRule.getSelectorText());
                    if (this.modifieds.containsKey(String.valueOf(this.formatURL(cssProperty.getURL())) + "\n" + cssProperty.getRule())) {
                        properties = (Map)this.modifieds.get(String.valueOf(this.formatURL(cssProperty.getURL())) + "\n" + cssProperty.getRule());
                        properties.put(cssProperty.getName(), cssProperty.getValue());
                    } else {
                        properties = new TreeMap<String, String>();
                        properties.put(cssProperty.getName(), cssProperty.getValue());
                        this.modifieds.put(String.valueOf(this.formatURL(cssProperty.getURL())) + "\n" + cssProperty.getRule(), properties);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }
        this.generatedDiffStrings();
    }

    private String formatURL(String url) {
        return "/* " + url + " */";
    }

    public void generateSelectionDiff() {
        this.createDiff();
        this.generatedDiffStrings();
    }

    public void generatedDiffStrings() {
        this.modified = "/* Modified Style Rules: */\n\n";
        this.original = "/* Original Style Rules: */\n\n";
        for (String rule : this.originals.keySet()) {
            Map mod_map = (Map)this.modifieds.get(rule);
            Map org_map = (Map)this.originals.get(rule);
            Iterator nameiter = org_map.keySet().iterator();
            boolean diffsFound = false;
            String t_original = String.valueOf(rule) + " {\n";
            String t_modified = String.valueOf(rule) + " {\n";
            while (nameiter.hasNext()) {
                String name = (String)nameiter.next();
                if (mod_map == null) continue;
                if (mod_map.get(name) == null) {
                    t_original = String.valueOf(t_original) + "\t" + name + ":" + org_map.get(name) + "\n";
                    t_modified = String.valueOf(t_modified) + "\t/* " + name + ":" + "(**Property Deleted) */" + "\n";
                    diffsFound = true;
                    continue;
                }
                if (mod_map.get(name).equals(org_map.get(name))) continue;
                t_original = org_map.get(name).equals("(**Property Added)") ? String.valueOf(t_original) + "\t/* " + name + ":" + org_map.get(name) + " */" + "\n" : String.valueOf(t_original) + "\t" + name + ":" + org_map.get(name) + "\n";
                t_modified = String.valueOf(t_modified) + "\t" + name + ":" + mod_map.get(name) + "\n";
                diffsFound = true;
            }
            t_original = String.valueOf(t_original) + "}\n\n";
            t_modified = String.valueOf(t_modified) + "}\n\n";
            if (!diffsFound) continue;
            this.modified = String.valueOf(this.modified) + t_modified;
            this.original = String.valueOf(this.original) + t_original;
        }
    }

    public String getModified() {
        return this.modified;
    }

    public String getOriginal() {
        return this.original;
    }
}

