/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.inspector;

import java.util.HashMap;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.mozilla.interfaces.nsIDOMAbstractView;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMDocumentView;
import org.mozilla.interfaces.nsIDOMHTMLFrameElement;
import org.mozilla.interfaces.nsIDOMHTMLIFrameElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsIDOMWindowInternal;
import org.mozilla.xpcom.XPCOMException;

public class DOMContentProvider
implements ITreeContentProvider {
    protected IWebBrowser input = null;
    protected HashMap documentToFrameMap = new HashMap();

    public Object[] getChildren(Object parentElement) {
        if (parentElement == this.input) {
            if (!this.input.isDocumentLoading()) {
                return new Object[]{((IWebBrowser)parentElement).getDocument()};
            }
            return new Object[]{new MessageNode("Loading...", this.input)};
        }
        if (parentElement instanceof MessageNode) {
            return new Object[0];
        }
        nsIDOMNode node = (nsIDOMNode)parentElement;
        if (node.getNodeType() == 9) {
            return new Object[]{((nsIDOMDocument)node).getDocumentElement()};
        }
        if ("FRAME".equalsIgnoreCase(node.getNodeName())) {
            nsIDOMHTMLFrameElement frame = (nsIDOMHTMLFrameElement)node.queryInterface("{a6cf90b9-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocument frameDoc = frame.getContentDocument();
            if (frameDoc != null) {
                this.documentToFrameMap.put(frameDoc, frame);
                return new Object[]{frameDoc};
            }
            return new Object[0];
        }
        if ("IFRAME".equalsIgnoreCase(node.getNodeName())) {
            nsIDOMHTMLIFrameElement iframe = (nsIDOMHTMLIFrameElement)node.queryInterface("{a6cf90ba-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocument iframeDoc = iframe.getContentDocument();
            if (iframeDoc != null) {
                this.documentToFrameMap.put(iframeDoc, iframe);
                return new Object[]{iframeDoc};
            }
            return new Object[0];
        }
        nsIDOMNodeList childrenList = node.getChildNodes();
        Object[] children = new Object[(int)childrenList.getLength()];
        int i = 0;
        while (i < (int)childrenList.getLength()) {
            children[i] = childrenList.item((long)i);
            ++i;
        }
        return children;
    }

    public Object getParent(Object element) {
        if (element == this.input) {
            return null;
        }
        if (element instanceof MessageNode) {
            return ((MessageNode)element).parent;
        }
        Object parent = null;
        nsIDOMNode node = (nsIDOMNode)element;
        if (node.getNodeType() == 9) {
            nsIDOMDocument doc = (nsIDOMDocument)node.queryInterface("{a6cf9075-15b3-11d2-932e-00805f8add32}");
            if (this.documentToFrameMap.containsKey(doc)) {
                parent = this.documentToFrameMap.get(doc);
            } else {
                try {
                    nsIDOMWindowInternal iWin;
                    nsIDOMDocumentView documentView = (nsIDOMDocumentView)doc.queryInterface("{1acdb2ba-1dd2-11b2-95bc-9542495d2569}");
                    nsIDOMAbstractView defaultDocView = documentView.getDefaultView();
                    if (defaultDocView != null && (parent = (iWin = (nsIDOMWindowInternal)documentView.getDefaultView().queryInterface("{c2f4433a-8b4c-4676-ab30-3bffd26fb29e}")).getFrameElement()) != null) {
                        this.documentToFrameMap.put(doc, parent);
                    }
                }
                catch (XPCOMException xPCOMException) {}
            }
            if (parent == null) {
                parent = this.input;
            }
        } else {
            parent = node.getParentNode();
        }
        return parent;
    }

    public boolean hasChildren(Object element) {
        if (element == this.input) {
            return this.input.getDocument() != null;
        }
        if (element instanceof MessageNode) {
            return false;
        }
        nsIDOMNode node = (nsIDOMNode)element;
        if ("FRAME".equalsIgnoreCase(node.getNodeName())) {
            nsIDOMHTMLFrameElement frame = (nsIDOMHTMLFrameElement)node.queryInterface("{a6cf90b9-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocument frameDoc = frame.getContentDocument();
            this.documentToFrameMap.put(frameDoc, frame);
            return frameDoc != null;
        }
        if ("IFRAME".equalsIgnoreCase(node.getNodeName())) {
            nsIDOMHTMLIFrameElement iframe = (nsIDOMHTMLIFrameElement)node.queryInterface("{a6cf90ba-15b3-11d2-932e-00805f8add32}");
            nsIDOMDocument iframeDoc = iframe.getContentDocument();
            this.documentToFrameMap.put(iframeDoc, iframe);
            return iframeDoc != null;
        }
        return node.hasChildNodes();
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.input = (IWebBrowser)newInput;
        this.documentToFrameMap.clear();
    }

    protected class MessageNode {
        public String message = "";
        public Object parent = null;

        public MessageNode(String message, Object parent) {
            this.message = message;
            this.parent = parent;
        }
    }
}

