/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.inspector;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.atf.mozilla.ide.common.IDOMNodeSelection;
import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentEvent;
import org.eclipse.atf.mozilla.ide.events.DOMDocumentListener;
import org.eclipse.atf.mozilla.ide.events.DOMMutationListener;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.actions.ActionExtensionManager;
import org.eclipse.atf.mozilla.ide.ui.browser.views.IBrowserView;
import org.eclipse.atf.mozilla.ide.ui.inspector.ATFInternalNodeFilter;
import org.eclipse.atf.mozilla.ide.ui.inspector.DOMAttributeViewer;
import org.eclipse.atf.mozilla.ide.ui.inspector.DOMContentProvider;
import org.eclipse.atf.mozilla.ide.ui.inspector.DOMLabelProvider;
import org.eclipse.atf.mozilla.ide.ui.inspector.IDOMInspector;
import org.eclipse.atf.mozilla.ide.ui.inspector.search.DOMTreePatternFilter;
import org.eclipse.atf.mozilla.ide.ui.inspector.search.SearchFilterTypeAction;
import org.eclipse.core.runtime.AssertionFailedException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.progress.WorkbenchJob;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;

public class DOMInspectorPage
extends Page
implements IDOMInspector,
IBrowserView,
ISelectionProvider,
ISelectionListener,
ISelectionChangedListener {
    protected IWebBrowser documentContainer = null;
    protected TreeViewer treeViewer = null;
    protected Composite contentArea = null;
    protected Composite searchArea = null;
    protected SashForm displayArea = null;
    protected DOMAttributeViewer attributesViewer = null;
    protected Menu attributesViewerMenu = null;
    protected Text searchText = null;
    protected ToolBarManager searchFilterToolBar = null;
    protected Action toggleSearchFilter = null;
    protected Action selectSearchFilterType = null;
    protected DOMTreePatternFilter patternFilter = null;
    protected Action collapseToBodyAction = null;
    private DOMDocumentListener domDocumentListener = new DOMDocumentListener(){

        public void documentLoaded(DOMDocumentEvent event) {
            if (event.isTop()) {
                nsIDOMNodeList nodeList;
                if (DOMInspectorPage.this.treeViewer != null) {
                    DOMInspectorPage.this.treeViewer.refresh((Object)DOMInspectorPage.this.documentContainer);
                }
                if ((nodeList = event.getTargetDocument().getElementsByTagName("body")).getLength() > 0L) {
                    DOMInspectorPage.this.treeViewer.expandToLevel((Object)nodeList.item(0L), 1);
                } else {
                    DOMInspectorPage.this.treeViewer.expandToLevel((Object)event.getTargetDocument().getDocumentElement(), 1);
                }
                DOMInspectorPage.this.searchText.setEnabled(true);
            }
        }

        public void documentUnloaded(DOMDocumentEvent event) {
            DOMInspectorPage.this.searchText.setText("");
            DOMInspectorPage.this.searchText.setEnabled(false);
            if (DOMInspectorPage.this.treeViewer != null) {
                DOMInspectorPage.this.treeViewer.refresh((Object)DOMInspectorPage.this.documentContainer);
                DOMInspectorPage.this.treeViewer.setSelection(null);
            }
        }
    };
    private DOMMutationListener domMutationListeer = new DOMMutationListener(){

        public void nodeInserted(nsIDOMNode parentNode, nsIDOMNode insertedNode) {
            if (DOMInspectorPage.this.treeViewer == null) {
                return;
            }
            if (DOMInspectorPage.this.treeViewer.getExpandedState((Object)parentNode)) {
                DOMInspectorPage.this.treeViewer.refresh((Object)parentNode);
            }
        }

        public void nodeRemoved(nsIDOMNode parentNode, nsIDOMNode removedNode) {
            if (DOMInspectorPage.this.treeViewer == null) {
                return;
            }
            if (!DOMInspectorPage.this.selection.isEmpty()) {
                nsIDOMNode node = DOMInspectorPage.this.selection.getSelectedNode();
                while (node != null) {
                    if (node.equals(removedNode)) {
                        DOMInspectorPage.this.changeSelection(parentNode);
                        break;
                    }
                    node = node.getParentNode();
                }
            }
            DOMInspectorPage.this.treeViewer.remove((Object)removedNode);
        }

        public void attributeAdded(nsIDOMElement ownerElement, String attributeName) {
            IStructuredSelection selection;
            Object domObjectSelection;
            if (DOMInspectorPage.this.treeViewer == null) {
                return;
            }
            if ("id".equals(attributeName.toLowerCase())) {
                DOMInspectorPage.this.treeViewer.update((Object)ownerElement.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}"), null);
            }
            if ((domObjectSelection = (selection = (IStructuredSelection)DOMInspectorPage.this.treeViewer.getSelection()).getFirstElement()) instanceof nsIDOMNode && ownerElement.equals((nsIDOMNode)domObjectSelection)) {
                DOMInspectorPage.this.updatePropertyViewers();
            }
        }

        public void attributeRemoved(nsIDOMElement ownerElement, String attributeName) {
            IStructuredSelection selection;
            Object domObjectSelection;
            if (DOMInspectorPage.this.treeViewer == null) {
                return;
            }
            if ("id".equals(attributeName.toLowerCase())) {
                final nsIDOMNode ownerNode = (nsIDOMNode)ownerElement.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}");
                UIJob refreshJob = new UIJob("Node ID removed refresh"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        (this).DOMInspectorPage.this.treeViewer.update((Object)ownerNode, null);
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                refreshJob.schedule(500L);
            }
            if ((domObjectSelection = (selection = (IStructuredSelection)DOMInspectorPage.this.treeViewer.getSelection()).getFirstElement()) instanceof nsIDOMNode && ownerElement.equals((nsIDOMNode)domObjectSelection)) {
                PropertiesRefreshJob refreshJob = new PropertiesRefreshJob();
                refreshJob.schedule(500L);
            }
        }

        public void attributeModified(nsIDOMElement ownerElement, String attributeName, String newValue, String previousValue) {
            IStructuredSelection selection;
            Object domObjectSelection;
            if (DOMInspectorPage.this.treeViewer == null) {
                return;
            }
            if ("id".equals(attributeName.toLowerCase())) {
                DOMInspectorPage.this.treeViewer.update((Object)ownerElement.queryInterface("{a6cf907c-15b3-11d2-932e-00805f8add32}"), null);
            }
            if ((domObjectSelection = (selection = (IStructuredSelection)DOMInspectorPage.this.treeViewer.getSelection()).getFirstElement()) instanceof nsIDOMNode && ownerElement.equals((nsIDOMNode)domObjectSelection)) {
                DOMInspectorPage.this.updatePropertyViewers();
            }
        }
    };
    private Job refreshJob;
    protected IDOMNodeSelection selection = new IDOMNodeSelection(){

        public nsIDOMNode getSelectedNode() {
            if (DOMInspectorPage.this.treeViewer == null) {
                return null;
            }
            IStructuredSelection selection = (IStructuredSelection)DOMInspectorPage.this.treeViewer.getSelection();
            Object selectedNode = selection.getFirstElement();
            if (selectedNode instanceof nsIDOMNode) {
                return (nsIDOMNode)selectedNode;
            }
            return null;
        }

        public boolean isEmpty() {
            if (DOMInspectorPage.this.treeViewer == null) {
                return true;
            }
            return this.getSelectedNode() == null;
        }
    };
    protected ListenerList selectionListeners = new ListenerList();

    public void createControl(Composite parent) {
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        this.contentArea = new Composite(parent, 0);
        this.contentArea.setLayout((Layout)contentAreaLayout);
        this.contentArea.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createSearchArea();
        this.createRefreshJob();
        this.configureSearchArea();
        this.displayArea = new SashForm(this.contentArea, 512);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.verticalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = true;
        this.displayArea.setLayoutData((Object)data);
        this.treeViewer = new TreeViewer((Composite)this.displayArea, 2820);
        Menu nodeMenu = ActionExtensionManager.configure((Control)this.treeViewer.getTree(), this.selection);
        this.treeViewer.getTree().setMenu(nodeMenu);
        this.styleTree(this.treeViewer.getTree());
        this.treeViewer.setContentProvider((IContentProvider)new DOMContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new DOMLabelProvider());
        if (this.documentContainer != null) {
            this.treeViewer.setInput((Object)this.documentContainer);
        }
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        int ops = 3;
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance()};
        this.treeViewer.addDragSupport(ops, transfers, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                nsIDOMNode nodeToMove = (nsIDOMNode)((ITreeSelection)DOMInspectorPage.this.treeViewer.getSelection()).getFirstElement();
                String name = nodeToMove.getNodeName();
                if (name.equalsIgnoreCase("BODY") || name.equalsIgnoreCase("HEAD") || name.equalsIgnoreCase("HTML") || name.equalsIgnoreCase("#document")) {
                    event.doit = false;
                }
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = ((ITreeSelection)DOMInspectorPage.this.treeViewer.getSelection()).getFirstElement().toString();
            }
        });
        this.treeViewer.addDropSupport(ops, transfers, (DropTargetListener)new DropTargetAdapter(){

            public void dropAccept(DropTargetEvent event) {
                if (event.item instanceof TreeItem) {
                    if (DOMInspectorPage.this.treeViewer.getTree().equals(((TreeItem)event.item).getParent())) {
                        nsIDOMNode node = (nsIDOMNode)event.item.getData();
                        if (node.getNodeName().equalsIgnoreCase("HTML") || node.getNodeName().equalsIgnoreCase("#document") || node.getNodeName().equalsIgnoreCase("BODY") || node.getNodeName().equalsIgnoreCase("HEAD")) {
                            event.detail = 0;
                        } else {
                            TreeItem item = (TreeItem)event.item;
                            TreeItem initial = DOMInspectorPage.this.treeViewer.getTree().getSelection()[0];
                            while (item.getParentItem() != null) {
                                if (initial.equals(item.getParentItem())) {
                                    event.detail = 0;
                                }
                                item = item.getParentItem();
                            }
                        }
                    }
                } else {
                    event.detail = 0;
                }
            }

            public void drop(DropTargetEvent event) {
                try {
                    if (event.item != null) {
                        Object data = event.item.getData();
                        nsIDOMNode node = null;
                        if (data instanceof nsIDOMNode) {
                            node = (nsIDOMNode)data;
                            ISelection selection = DOMInspectorPage.this.treeViewer.getSelection();
                            nsIDOMNode nodeToMove = (nsIDOMNode)((ITreeSelection)selection).getFirstElement();
                            nsIDOMNode nodeAfter = node.getNextSibling();
                            if (!node.equals(nodeToMove) && !nodeToMove.equals(nodeAfter)) {
                                nsIDOMNode parent = node.getParentNode();
                                nodeToMove = nodeToMove.getParentNode().removeChild(nodeToMove);
                                if (nodeAfter != null) {
                                    parent.insertBefore(nodeToMove, nodeAfter);
                                } else {
                                    parent.appendChild(nodeToMove);
                                }
                            }
                            DOMInspectorPage.this.treeViewer.setSelection(selection);
                        }
                    }
                }
                catch (Exception exception) {}
            }

            public void dragOver(DropTargetEvent event) {
                nsIDOMNode node;
                TreeItem item;
                if (event.item instanceof TreeItem && (item = (TreeItem)event.item) != null && item.getParent().equals(DOMInspectorPage.this.treeViewer.getTree()) && item.getItemCount() > 0 && !(node = (nsIDOMNode)item.getData()).equals(((ITreeSelection)DOMInspectorPage.this.treeViewer.getSelection()).getFirstElement())) {
                    event.feedback = 16;
                }
            }
        });
        this.patternFilter = new DOMTreePatternFilter();
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
        this.treeViewer.addFilter((ViewerFilter)new ATFInternalNodeFilter());
        this.attributesViewer = new DOMAttributeViewer((Composite)this.displayArea, 99076);
        this.displayArea.setWeights(new int[]{60, 40});
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.createToolbarMenu();
    }

    protected void createSearchArea() {
        GridLayout searcAreaLayout = new GridLayout();
        searcAreaLayout.numColumns = 3;
        searcAreaLayout.makeColumnsEqualWidth = false;
        searcAreaLayout.marginHeight = 0;
        searcAreaLayout.marginWidth = 3;
        searcAreaLayout.verticalSpacing = 0;
        searcAreaLayout.horizontalSpacing = 0;
        this.searchArea = new Composite(this.contentArea, 0);
        this.searchArea.setLayout((Layout)searcAreaLayout);
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        data.grabExcessVerticalSpace = false;
        this.searchArea.setLayoutData((Object)data);
        Label searchLabel = new Label(this.searchArea, 0);
        searchLabel.setText("Search:");
        this.searchText = new Text(this.searchArea, 2052);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = true;
        this.searchText.setLayoutData((Object)data);
        ToolBar toolBar = new ToolBar(this.searchArea, 0x800100);
        data = new GridData();
        data.horizontalAlignment = 4;
        data.horizontalSpan = 1;
        data.grabExcessHorizontalSpace = false;
        toolBar.setLayoutData((Object)data);
        this.searchFilterToolBar = new ToolBarManager(toolBar);
        this.createSearchFilterToolBar();
        this.searchFilterToolBar.update(false);
    }

    protected void createSearchFilterToolBar() {
        SearchFilterTypeAction selectFilterTypeAction = new SearchFilterTypeAction();
        selectFilterTypeAction.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("filterType".equals(event.getProperty())) {
                    DOMInspectorPage.this.patternFilter.setFilterType((Integer)event.getNewValue());
                    DOMInspectorPage.this.textChanged();
                }
            }
        });
        this.searchFilterToolBar.add((IAction)selectFilterTypeAction);
    }

    protected void configureSearchArea() {
        this.searchText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                boolean hasItems;
                boolean bl = hasItems = DOMInspectorPage.this.treeViewer.getTree().getItemCount() > 0;
                if (hasItems && e.keyCode == 0x1000002) {
                    DOMInspectorPage.this.treeViewer.getTree().setFocus();
                } else if (e.character == '\r') {
                    return;
                }
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DOMInspectorPage.this.textChanged();
            }
        });
    }

    protected void textChanged() {
        this.refreshJob.cancel();
        this.refreshJob.schedule(200L);
    }

    private void createRefreshJob() {
        this.refreshJob = new WorkbenchJob("Refresh Filter"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (DOMInspectorPage.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = DOMInspectorPage.this.searchText.getText();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                DOMInspectorPage.this.patternFilter.setPattern(text);
                try {
                    DOMInspectorPage.this.treeViewer.getControl().setRedraw(false);
                    DOMInspectorPage.this.treeViewer.refresh(true);
                    if (text.length() > 0) {
                        IStructuredContentProvider provider = (IStructuredContentProvider)DOMInspectorPage.this.treeViewer.getContentProvider();
                        Object[] elements = provider.getElements(DOMInspectorPage.this.treeViewer.getInput());
                        int i = 0;
                        while (i < elements.length) {
                            if (monitor.isCanceled()) {
                                IStatus iStatus = Status.CANCEL_STATUS;
                                return iStatus;
                            }
                            DOMInspectorPage.this.treeViewer.expandToLevel(elements[i], -1);
                            ++i;
                        }
                        TreeItem[] items = DOMInspectorPage.this.treeViewer.getTree().getItems();
                        if (items.length > 0) {
                            DOMInspectorPage.this.treeViewer.getTree().showItem(items[0]);
                        }
                    }
                }
                finally {
                    DOMInspectorPage.this.treeViewer.getControl().setRedraw(true);
                }
                return Status.OK_STATUS;
            }
        };
        this.refreshJob.setSystem(true);
    }

    public Control getControl() {
        return this.contentArea;
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    protected void styleTree(Tree tree) {
        tree.setFont(tree.getParent().getFont());
    }

    protected void updatePropertyViewers() {
        this.updatePropertyViewer((Viewer)this.attributesViewer);
    }

    protected void updatePropertyViewer(Viewer viewer) {
        Object viewerInput = viewer.getInput();
        try {
            if (this.selection.isEmpty()) {
                if (viewerInput != null) {
                    viewer.setInput(null);
                }
            } else if (viewerInput == null) {
                viewer.setInput((Object)this.selection.getSelectedNode());
            } else if (this.selection.getSelectedNode().equals(viewerInput)) {
                viewer.refresh();
            } else {
                viewer.setInput((Object)this.selection.getSelectedNode());
            }
        }
        catch (RuntimeException re) {
            MozIDEUIPlugin.log(re);
        }
    }

    protected void createToolbarMenu() {
        this.collapseToBodyAction = new Action(null, 1){

            public void run() {
                nsIDOMDocument doc = DOMInspectorPage.this.documentContainer.getDocument();
                if (doc != null) {
                    nsIDOMNodeList nodeList = doc.getElementsByTagName("body");
                    if (nodeList.getLength() > 0L) {
                        DOMInspectorPage.this.treeViewer.collapseToLevel((Object)nodeList.item(0L), 1);
                    } else {
                        DOMInspectorPage.this.treeViewer.collapseToLevel((Object)doc.getDocumentElement(), 1);
                    }
                }
            }
        };
        this.collapseToBodyAction.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/inspector/collapse.gif"));
        this.collapseToBodyAction.setToolTipText("Collapse the DOM tree to the Body element.");
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        toolBarManager.add((IAction)this.collapseToBodyAction);
    }

    public void dispose() {
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().removeEventListener(this.documentContainer, (IApplicationEventListener)this.domDocumentListener);
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().removeEventListener(this.documentContainer, (IApplicationEventListener)this.domMutationListeer);
        this.refreshJob.cancel();
        super.dispose();
    }

    public void setWebBrowser(IWebBrowser documentContainer) {
        if (this.documentContainer != null) {
            throw new AssertionFailedException("DOMInspectorPage already initialized, cannot call setDOMDocumentContainer() more than once.");
        }
        this.documentContainer = documentContainer;
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().addEventListener(documentContainer, (IApplicationEventListener)this.domDocumentListener);
        MozIDEUIPlugin.getDefault().getApplicationEventAdmin().addEventListener(documentContainer, (IApplicationEventListener)this.domMutationListeer);
    }

    protected void clearSelection() {
        if (!this.selection.isEmpty()) {
            this.treeViewer.setSelection(null);
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
        }
    }

    protected void changeSelection(final nsIDOMNode selectedNode) {
        if (selectedNode == null) {
            this.clearSelection();
        } else if (this.selection.isEmpty()) {
            this.treeViewer.setSelection((ISelection)new IStructuredSelection(){

                public boolean isEmpty() {
                    return false;
                }

                public Object getFirstElement() {
                    return selectedNode;
                }

                public Iterator iterator() {
                    return this.toList().iterator();
                }

                public int size() {
                    return 1;
                }

                public Object[] toArray() {
                    return this.toList().toArray();
                }

                public List toList() {
                    ArrayList<Object> list = new ArrayList<Object>(1);
                    list.add(this.getFirstElement());
                    return list;
                }
            }, true);
            this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
        } else {
            nsIDOMNode currentSelection = this.selection.getSelectedNode();
            if (!currentSelection.equals(selectedNode)) {
                this.treeViewer.setSelection((ISelection)new IStructuredSelection(){

                    public boolean isEmpty() {
                        return false;
                    }

                    public Object getFirstElement() {
                        return selectedNode;
                    }

                    public Iterator iterator() {
                        return this.toList().iterator();
                    }

                    public int size() {
                        return 1;
                    }

                    public Object[] toArray() {
                        return this.toList().toArray();
                    }

                    public List toList() {
                        ArrayList<Object> list = new ArrayList<Object>(1);
                        list.add(this.getFirstElement());
                        return list;
                    }
                }, true);
                this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
            } else {
                this.treeViewer.getTree().showSelection();
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent e) {
        IStructuredSelection selection;
        Object selectedObj;
        if (e.getSelection().isEmpty()) {
            this.updatePropertyViewers();
        }
        if ((selectedObj = (selection = (IStructuredSelection)e.getSelection()).getFirstElement()) instanceof nsIDOMNode) {
            this.updatePropertyViewers();
        }
        this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.selection));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (this.treeViewer == null) {
            return;
        }
        if (selection instanceof IDOMNodeSelection) {
            nsIDOMNode selectedNode = ((IDOMNodeSelection)selection).getSelectedNode();
            this.changeSelection(selectedNode);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove((Object)listener);
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            this.clearSelection();
        } else if (selection instanceof IDOMNodeSelection) {
            nsIDOMNode externalSelection = ((IDOMNodeSelection)selection).getSelectedNode();
            this.changeSelection(externalSelection);
        }
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.selectionListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected class PropertiesRefreshJob
    extends UIJob {
        public PropertiesRefreshJob() {
            super("ATF_DOMInspector_PropertiesRefresh");
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            DOMInspectorPage.this.updatePropertyViewers();
            return Status.OK_STATUS;
        }
    }
}

