/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.jseval;

import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.actions.DOMSelectionAction;
import org.eclipse.atf.mozilla.ide.ui.jseval.IJSEvalPage;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.progress.UIJob;
import org.mozilla.interfaces.nsIDOMNode;

public class EvalDomSelectionAction
extends DOMSelectionAction {
    private static ISchedulingRule mutexRule = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public void run() {
        try {
            if (this.getSelection() != null && !this.getSelection().isEmpty()) {
                IWorkbenchPage page = MozIDEUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
                page.showView("org.eclipse.atf.mozilla.ide.ui.views.jseval");
                IEditorPart editor = page.getActiveEditor();
                IJSEvalPage evalPage = (IJSEvalPage)editor.getAdapter(IJSEvalPage.class);
                if (evalPage != null) {
                    EvalNodeJob evalNodeJob = new EvalNodeJob(evalPage, this.getSelection().getSelectedNode());
                    evalNodeJob.schedule();
                }
            }
        }
        catch (Exception e) {
            MozIDEUIPlugin.log(e);
        }
    }

    protected class EvalNodeJob
    extends UIJob {
        private static final int MAX_RESHEDULE = 3;
        private static final long DELAY = 500L;
        private IJSEvalPage evalPage;
        private nsIDOMNode evalNode;
        private int rescheduleCount;

        public EvalNodeJob(IJSEvalPage evalPage, nsIDOMNode evalNode) {
            super("Eval Node Job");
            this.rescheduleCount = 0;
            this.evalPage = evalPage;
            this.evalNode = evalNode;
            this.setRule(mutexRule);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.evalPage.isReady()) {
                this.evalPage.evalElement(this.evalNode);
                return Status.OK_STATUS;
            }
            if (this.rescheduleCount < 3) {
                ++this.rescheduleCount;
                this.schedule(500L);
                return Status.OK_STATUS;
            }
            return new Status(4, "org.eclipse.atf.mozilla.ide.ui", 4, "JavaScript eval not available.", null);
        }
    }
}

