/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.jseval;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.IJSValue;
import org.eclipse.atf.mozilla.ide.ui.jseval.model.JSTypeFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMDocumentEvent;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMEventListener;
import org.mozilla.interfaces.nsIDOMEventTarget;
import org.mozilla.interfaces.nsIDOMHTMLInputElement;
import org.mozilla.interfaces.nsIDOMHTMLScriptElement;
import org.mozilla.interfaces.nsIDOMHTMLTextAreaElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.Mozilla;
import org.osgi.framework.Bundle;

public class Evaluator {
    protected static final String EVAL_READY = "ATF_EVAL_READY";
    protected static final String EVAL_RECONNECT = "ATF_EVAL_RECONNECT";
    protected static final String EVAL_SET = "ATF_EVAL_SET";
    protected static final String EVAL_DONE = "ATF_EVAL_DONE";
    protected static final String EVAL_ERROR = "ATF_EVAL_ERROR";
    protected static final String PAGE_SCRIPT_URL = "/js/ATF_Eval.js";
    protected nsIDOMEventListener listener = new nsIDOMEventListener(){

        public void handleEvent(nsIDOMEvent event) {
            if (Evaluator.EVAL_READY.equals(event.getType())) {
                Evaluator.this.handleEvalReady(event);
            } else if (Evaluator.EVAL_DONE.equals(event.getType())) {
                Evaluator.this.handleEvalDone(event);
            } else if (Evaluator.EVAL_ERROR.equals(event.getType())) {
                Evaluator.this.handleEvalError(event);
            }
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }
    };
    protected nsIDOMDocument document = null;
    protected nsIDOMHTMLInputElement evalIn = null;
    private IJSValue evalRet = null;

    public void init(nsIDOMDocument document) {
        block29: {
            if (this.document == document) {
                return;
            }
            this.document = document;
            nsIDOMEventTarget docTarget = (nsIDOMEventTarget)document.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
            docTarget.addEventListener(EVAL_READY, this.listener, true);
            docTarget.addEventListener(EVAL_DONE, this.listener, true);
            docTarget.addEventListener(EVAL_ERROR, this.listener, true);
            try {
                nsIDOMElement evalContainer = document.getElementById("___ATF_INTERNAL_EVAL");
                if (evalContainer == null) {
                    StringBuffer buffer;
                    nsIDOMHTMLScriptElement script;
                    nsIDOMNode head;
                    block28: {
                        head = document.getElementsByTagName("HEAD").item(0L);
                        script = (nsIDOMHTMLScriptElement)document.createElement("SCRIPT").queryInterface("{a6cf90b1-15b3-11d2-932e-00805f8add32}");
                        script.setAttribute("class", "___ATF_INTERNAL");
                        buffer = new StringBuffer();
                        Reader reader = null;
                        InputStream io = null;
                        try {
                            try {
                                int readCount;
                                io = FileLocator.openStream((Bundle)MozIDEUIPlugin.getDefault().getBundle(), (IPath)new Path(PAGE_SCRIPT_URL), (boolean)false);
                                reader = new InputStreamReader(io);
                                char[] readbuff = new char[1000];
                                while ((readCount = reader.read(readbuff)) != -1) {
                                    buffer.append(readbuff, 0, readCount);
                                }
                            }
                            catch (Exception e) {
                                MozIDEUIPlugin.log(e);
                                if (reader != null) {
                                    try {
                                        reader.close();
                                    }
                                    catch (Exception e2) {
                                        MozIDEUIPlugin.log(e2);
                                    }
                                }
                                if (io != null) {
                                    try {
                                        io.close();
                                    }
                                    catch (Exception e3) {
                                        MozIDEUIPlugin.log(e3);
                                    }
                                }
                                break block28;
                            }
                        }
                        catch (Throwable throwable) {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Exception e) {
                                    MozIDEUIPlugin.log(e);
                                }
                            }
                            if (io != null) {
                                try {
                                    io.close();
                                }
                                catch (Exception e) {
                                    MozIDEUIPlugin.log(e);
                                }
                            }
                            throw throwable;
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Exception e) {
                                MozIDEUIPlugin.log(e);
                            }
                        }
                        if (io != null) {
                            try {
                                io.close();
                            }
                            catch (Exception e) {
                                MozIDEUIPlugin.log(e);
                            }
                        }
                    }
                    nsIDOMText scriptContent = document.createTextNode(buffer.toString());
                    script.appendChild((nsIDOMNode)scriptContent);
                    head.appendChild((nsIDOMNode)script);
                    break block29;
                }
                nsIDOMDocumentEvent docEvent = (nsIDOMDocumentEvent)document.queryInterface("{46b91d66-28e2-11d4-ab1e-0010830123b4}");
                nsIDOMEvent event = docEvent.createEvent("Event");
                event.initEvent(EVAL_RECONNECT, false, false);
                nsIDOMEventTarget target = (nsIDOMEventTarget)evalContainer.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
                target.dispatchEvent(event);
            }
            catch (Exception e) {
                MozIDEUIPlugin.log(e);
            }
        }
    }

    public IJSValue evaluate(String expression) {
        this.evalRet = null;
        this.evalIn.setValue(expression);
        nsIDOMDocumentEvent docEvent = (nsIDOMDocumentEvent)this.document.queryInterface("{46b91d66-28e2-11d4-ab1e-0010830123b4}");
        nsIDOMEvent event = docEvent.createEvent("Event");
        event.initEvent(EVAL_SET, false, false);
        nsIDOMEventTarget target = (nsIDOMEventTarget)this.evalIn.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
        target.dispatchEvent(event);
        return this.evalRet;
    }

    public IJSValue evaluate(nsIDOMNode node, String expression) {
        this.evalRet = null;
        this.evalIn.setValue(expression);
        nsIDOMDocumentEvent docEvent = (nsIDOMDocumentEvent)this.document.queryInterface("{46b91d66-28e2-11d4-ab1e-0010830123b4}");
        nsIDOMEvent event = docEvent.createEvent("Event");
        event.initEvent(EVAL_SET, false, false);
        nsIDOMEventTarget target = (nsIDOMEventTarget)node.queryInterface("{1c773b30-d1cf-11d2-bd95-00805f8ae3f4}");
        target.dispatchEvent(event);
        return this.evalRet;
    }

    public boolean isReady() {
        return this.evalIn != null;
    }

    protected void handleEvalReady(nsIDOMEvent event) {
        this.evalIn = (nsIDOMHTMLInputElement)event.getTarget().queryInterface("{a6cf9093-15b3-11d2-932e-00805f8add32}");
        event.getCurrentTarget().removeEventListener(EVAL_READY, this.listener, true);
    }

    protected void handleEvalDone(nsIDOMEvent event) {
        nsIDOMHTMLTextAreaElement evalOut = (nsIDOMHTMLTextAreaElement)event.getTarget().queryInterface("{a6cf9094-15b3-11d2-932e-00805f8add32}");
        this.evalRet = JSTypeFactory.getInstance().create(evalOut.getValue());
    }

    protected void handleEvalError(nsIDOMEvent event) {
        nsIDOMHTMLTextAreaElement evalOut = (nsIDOMHTMLTextAreaElement)event.getTarget().queryInterface("{a6cf9094-15b3-11d2-932e-00805f8add32}");
        this.evalRet = JSTypeFactory.getInstance().create(evalOut.getValue());
    }
}

