/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.atf.mozilla.ide.events.IApplicationEvent;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;

public class EventRecorder
implements IApplicationEventListener {
    protected Set<IApplicationEventListener> listeners = new HashSet<IApplicationEventListener>();
    protected List<IApplicationEvent> calls = new ArrayList<IApplicationEvent>();

    public void clear() {
        this.calls.clear();
    }

    public IApplicationEvent[] getAll() {
        IApplicationEvent[] callsArray = new IApplicationEvent[this.calls.size()];
        return this.calls.toArray(callsArray);
    }

    public void addListener(IApplicationEventListener netMonitor) {
        this.listeners.add(netMonitor);
    }

    public void removeListener(IApplicationEventListener netMonitor) {
        this.listeners.remove(netMonitor);
    }

    private void fireCallAddedNotification(IApplicationEvent call) {
        Iterator<IApplicationEventListener> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().onEvent(call);
        }
    }

    public void onEvent(IApplicationEvent event) {
        this.calls.add(event);
        this.fireCallAddedNotification(event);
    }
}

