/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon;

import org.eclipse.atf.mozilla.ide.common.IWebBrowser;
import org.eclipse.atf.mozilla.ide.events.IApplicationEvent;
import org.eclipse.atf.mozilla.ide.events.IApplicationEventListener;
import org.eclipse.atf.mozilla.ide.events.ITimedEvent;
import org.eclipse.atf.mozilla.ide.network.INetworkCall;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.browser.views.IBrowserView;
import org.eclipse.atf.mozilla.ide.ui.netmon.EventRecorder;
import org.eclipse.atf.mozilla.ide.ui.netmon.INetworkMonitor;
import org.eclipse.atf.mozilla.ide.ui.netmon.NetworkMonitorPageFilters;
import org.eclipse.atf.mozilla.ide.ui.netmon.NetworkMonitorTable;
import org.eclipse.atf.mozilla.ide.ui.netmon.RequestResponsePanel;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.Page;

public class NetworkMonitorPage
extends Page
implements IBrowserView,
INetworkMonitor,
IApplicationEventListener {
    protected IWebBrowser webBrowser;
    protected RequestResponsePanel requestResponsePanel;
    private NetworkMonitorPageFilters filtersMenu;
    private NetworkMonitorTable table;
    protected SashForm displayArea = null;
    protected Action collapseAction = null;

    public void createControl(Composite parent) {
        EventRecorder callList = MozIDEUIPlugin.getDefault().getCallListsManager().getCallList(this.webBrowser);
        callList.addListener(this);
        this.displayArea = new SashForm(parent, 512);
        this.table = new NetworkMonitorTable(this.displayArea);
        this.table.setCallList(callList);
        this.requestResponsePanel = new RequestResponsePanel((Composite)this.displayArea);
        this.table.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                NetworkMonitorPage.this.requestResponsePanel.setSelection((IStructuredSelection)event.getSelection());
            }
        });
        this.table.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (NetworkMonitorPage.this.displayArea.getMaximizedControl() != null) {
                    NetworkMonitorPage.this.displayArea.setMaximizedControl(null);
                    NetworkMonitorPage.this.collapseAction.setChecked(false);
                }
            }
        });
        this.filtersMenu = new NetworkMonitorPageFilters(this.getSite().getActionBars().getToolBarManager()){

            protected void clear() {
                NetworkMonitorPage.this.doClear();
            }

            protected void setFilters(ViewerFilter[] filters) {
                NetworkMonitorPage.this.table.setFilters(filters);
            }
        };
        this.displayArea.setMaximizedControl((Control)this.table.getControl());
        this.createActions();
    }

    public void setFilters(ViewerFilter[] filters) {
        this.table.setFilters(filters);
    }

    protected void createActions() {
        this.collapseAction = new Action(null, 2){

            public void run() {
                if (this.isChecked()) {
                    NetworkMonitorPage.this.displayArea.setMaximizedControl((Control)NetworkMonitorPage.this.table.getControl());
                } else {
                    NetworkMonitorPage.this.displayArea.setMaximizedControl(null);
                    NetworkMonitorPage.this.requestResponsePanel.setSelection((IStructuredSelection)NetworkMonitorPage.this.table.getViewer().getSelection());
                }
            }
        };
        this.collapseAction.setImageDescriptor(MozIDEUIPlugin.getImageDescriptor("icons/xhrmon/collapse.gif"));
        this.collapseAction.setToolTipText("Hide the request/response content panel");
        this.collapseAction.setChecked(true);
        IToolBarManager toolBarManager = this.getSite().getActionBars().getToolBarManager();
        toolBarManager.add((IContributionItem)new Separator());
        toolBarManager.add((IAction)this.collapseAction);
    }

    public Control getControl() {
        return this.displayArea;
    }

    public void setFocus() {
        this.table.getControl().setFocus();
    }

    public void dispose() {
        EventRecorder callList = MozIDEUIPlugin.getDefault().getCallListsManager().getCallList(this.webBrowser);
        callList.removeListener(this);
        this.requestResponsePanel.dispose();
        this.requestResponsePanel = null;
        super.dispose();
    }

    public void setWebBrowser(IWebBrowser documentContainer) {
        this.webBrowser = documentContainer;
    }

    private void doClear() {
        EventRecorder callList = MozIDEUIPlugin.getDefault().getCallListsManager().getCallList(this.webBrowser);
        callList.clear();
        this.table.getViewer().refresh();
        this.requestResponsePanel.clear();
    }

    private static INetworkCall eventToCall(IApplicationEvent event) {
        ITimedEvent tevent;
        if (event instanceof ITimedEvent && (tevent = (ITimedEvent)event).getData() instanceof INetworkCall) {
            return (INetworkCall)tevent.getData();
        }
        return null;
    }

    public void onEvent(IApplicationEvent event) {
        final INetworkCall call = NetworkMonitorPage.eventToCall(event);
        if (call == null) {
            return;
        }
        this.table.notifyCallAdded(call);
        if (!this.filtersMenu.getScrollLock()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    NetworkMonitorPage.this.table.getViewer().setSelection((ISelection)new StructuredSelection((Object)call));
                    NetworkMonitorPage.this.table.getViewer().reveal((Object)call);
                }
            });
        }
    }
}

