/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon;

import java.net.URL;
import org.eclipse.atf.mozilla.ide.network.IHTTPRequest;
import org.eclipse.atf.mozilla.ide.network.IHTTPResponse;
import org.eclipse.atf.mozilla.ide.network.IHeaderContainer;
import org.eclipse.atf.mozilla.ide.network.INetworkCall;
import org.eclipse.atf.mozilla.ide.network.IRequest;
import org.eclipse.atf.mozilla.ide.network.IResponse;
import org.eclipse.atf.mozilla.ide.network.IStatusChange;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.netmon.HeaderContentProvider;
import org.eclipse.atf.mozilla.ide.ui.netmon.HeaderLabelProvider;
import org.eclipse.atf.mozilla.ide.ui.netmon.payload.IPayloadRenderStrategy;
import org.eclipse.atf.mozilla.ide.ui.netmon.payload.ITextPayloadRenderStrategy;
import org.eclipse.atf.mozilla.ide.ui.netmon.payload.PayloadRenderStrategyFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.progress.UIJob;

public class RequestResponsePanel {
    protected Label requestLabel = null;
    protected Label responseLabel = null;
    protected SourceViewer requestText = null;
    protected SourceViewer responseText = null;
    protected TableViewer requestHeadersViewer = null;
    protected TableViewer responseHeadersViewer = null;
    protected Composite responseUnsupported;
    protected Composite responseImage;
    protected Label imageLabel;
    protected CTabItem responseBodyItem;
    protected Menu menu;
    protected MenuItem copy;
    protected Clipboard clipboard;
    protected Button formatButton;
    private IStructuredSelection selection;
    protected ResponseBodyGetterJob responseBodyGetterJob = null;

    public RequestResponsePanel(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.verticalSpacing = 1;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.requestLabel = new Label(composite, 0);
        this.requestLabel.setText("Request:");
        this.requestLabel.setLayoutData((Object)new GridData(1, 1, true, false));
        Composite comp2 = new Composite(composite, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        layout.verticalSpacing = 1;
        layout.makeColumnsEqualWidth = false;
        comp2.setLayout((Layout)layout);
        comp2.setLayoutData((Object)new GridData(4, 4, false, false));
        this.responseLabel = new Label(comp2, 0);
        this.responseLabel.setText("Response:");
        this.responseLabel.setLayoutData((Object)new GridData(1, 1, true, false));
        this.formatButton = new Button(comp2, 32);
        this.formatButton.setText("Format");
        this.formatButton.setVisible(false);
        this.formatButton.setSelection(false);
        this.formatButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (RequestResponsePanel.this.selection == null) {
                    return;
                }
                INetworkCall call = (INetworkCall)RequestResponsePanel.this.selection.getFirstElement();
                IResponse res = call.getResponse();
                if (res instanceof IHTTPResponse) {
                    PayloadRenderStrategyFactory strategyFactory = PayloadRenderStrategyFactory.getInstance();
                    ITextPayloadRenderStrategy strategy = (ITextPayloadRenderStrategy)strategyFactory.getStrategy((IHeaderContainer)((IHTTPResponse)res));
                    SourceViewerConfiguration viewerConf = strategy.getConfiguration();
                    RequestResponsePanel.this.responseText.unconfigure();
                    if (viewerConf != null && RequestResponsePanel.this.formatButton.getSelection()) {
                        RequestResponsePanel.this.responseText.configure(viewerConf);
                    }
                    RequestResponsePanel.this.responseText.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        CTabFolder requestTabFolder = new CTabFolder(composite, 0x800C00);
        requestTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem requestHeaderItem = new CTabItem(requestTabFolder, 0);
        requestHeaderItem.setText("Headers");
        CTabItem requestBodyItem = new CTabItem(requestTabFolder, 0);
        requestBodyItem.setText("Body");
        this.requestHeadersViewer = this.createHeadersViewer((Composite)requestTabFolder, new HeaderContentProvider());
        this.requestText = this.createBodyText((Composite)requestTabFolder);
        requestHeaderItem.setControl(this.requestHeadersViewer.getControl());
        requestBodyItem.setControl(this.requestText.getControl());
        requestTabFolder.setSelection(requestHeaderItem);
        CTabFolder responseTabFolder = new CTabFolder(composite, 0x800C00);
        responseTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        CTabItem responseHeaderItem = new CTabItem(responseTabFolder, 0);
        responseHeaderItem.setText("Headers");
        this.responseBodyItem = new CTabItem(responseTabFolder, 0);
        this.responseBodyItem.setText("Body");
        this.responseHeadersViewer = this.createHeadersViewer((Composite)responseTabFolder, new HeaderContentProvider());
        this.responseText = this.createBodyText((Composite)responseTabFolder);
        this.responseImage = new ScrolledComposite((Composite)responseTabFolder, 768);
        Color white = parent.getDisplay().getSystemColor(1);
        this.responseImage.setBackground(white);
        this.imageLabel = new Label(this.responseImage, 0);
        ((ScrolledComposite)this.responseImage).setContent((Control)this.imageLabel);
        this.imageLabel.setText("Image Here");
        this.imageLabel.setSize(100, 50);
        this.responseUnsupported = new Composite((Composite)responseTabFolder, 0);
        this.responseUnsupported.setLayout((Layout)new FillLayout());
        this.responseImage.setBackground(white);
        Label unsupportedLabel = new Label(this.responseUnsupported, 0);
        unsupportedLabel.setText("Cannot display... Unsupported MIME type!");
        responseHeaderItem.setControl(this.responseHeadersViewer.getControl());
        this.responseBodyItem.setControl(this.responseText.getControl());
        responseTabFolder.setSelection(responseHeaderItem);
        this.createCopyMenu();
    }

    private void createCopyMenu() {
        this.menu = new Menu(this.responseText.getControl());
        this.clipboard = new Clipboard(this.menu.getDisplay());
        this.responseText.getControl().setMenu(this.menu);
        this.menu.setEnabled(true);
        this.copy = new MenuItem(this.menu, 8);
        this.copy.setText("Copy");
        this.copy.setImage(MozIDEUIPlugin.getDefault().getImage("COPYRESPONSE_ID"));
        this.copy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Point p = RequestResponsePanel.this.responseText.getSelectedRange();
                    int offset = p.x;
                    int length = p.y;
                    String content = RequestResponsePanel.this.responseText.getDocument().get(offset, length);
                    if (content != null && content.length() > 0) {
                        RequestResponsePanel.this.clipboard.setContents((Object[])new String[]{content}, new Transfer[]{TextTransfer.getInstance()});
                    }
                }
                catch (BadLocationException badLocationException) {}
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.menu = new Menu(this.requestText.getControl());
        this.requestText.getControl().setMenu(this.menu);
        this.menu.setEnabled(true);
        this.copy = new MenuItem(this.menu, 8);
        this.copy.setText("Copy");
        this.copy.setImage(MozIDEUIPlugin.getDefault().getImage("COPYRESPONSE_ID"));
        this.copy.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    Point p = RequestResponsePanel.this.requestText.getSelectedRange();
                    int offset = p.x;
                    int length = p.y;
                    String content = RequestResponsePanel.this.requestText.getDocument().get(offset, length);
                    if (content != null && content.length() > 0) {
                        RequestResponsePanel.this.clipboard.setContents((Object[])new String[]{content}, new Transfer[]{TextTransfer.getInstance()});
                    }
                }
                catch (BadLocationException badLocationException) {}
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected TableViewer createHeadersViewer(Composite parent, HeaderContentProvider provider) {
        TableViewer headerViewer = new TableViewer(parent, 99076);
        Table t = headerViewer.getTable();
        t.setLinesVisible(true);
        t.setHeaderVisible(false);
        TableColumn column = new TableColumn(t, 16388, 0);
        column.setText("Name");
        column = new TableColumn(t, 16388, 1);
        column.setText("Value");
        t.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                try {
                    Table resizedTable = (Table)e.getSource();
                    int w = resizedTable.getClientArea().width;
                    resizedTable.getColumn(0).setWidth(w / 2);
                    resizedTable.getColumn(1).setWidth(w / 2);
                    resizedTable.removeControlListener((ControlListener)this);
                }
                catch (Exception exception) {}
            }
        });
        headerViewer.setLabelProvider((IBaseLabelProvider)new HeaderLabelProvider());
        headerViewer.setContentProvider((IContentProvider)provider);
        return headerViewer;
    }

    protected SourceViewer createBodyText(Composite parent) {
        SourceViewer bodyText = new SourceViewer(parent, null, 768);
        bodyText.setEditable(false);
        bodyText.setDocument((IDocument)new Document(""));
        return bodyText;
    }

    public void clear() {
        this.clearRequestArea();
        this.clearResponseArea();
    }

    protected void clearResponseArea() {
        this.responseText.getDocument().set("");
        this.responseBodyItem.setControl(this.responseText.getControl());
        this.formatButton.setVisible(false);
        this.responseHeadersViewer.setInput(null);
        if (this.responseBodyGetterJob != null) {
            this.responseBodyGetterJob.cancel();
        }
    }

    protected void clearRequestArea() {
        this.requestText.getDocument().set("");
        this.requestHeadersViewer.setInput(null);
    }

    public void setSelection(IStructuredSelection selection) {
        this.selection = selection;
        if (selection.isEmpty()) {
            this.clear();
        } else {
            Object element;
            if (this.responseBodyGetterJob != null) {
                this.responseBodyGetterJob.cancel();
            }
            if ((element = selection.getFirstElement()) instanceof IStatusChange) {
                element = ((IStatusChange)element).getCall();
            }
            if (!(element instanceof INetworkCall)) {
                return;
            }
            INetworkCall call = (INetworkCall)element;
            IRequest req = call.getRequest();
            this.requestHeadersViewer.setInput((Object)req);
            if (req instanceof IHTTPRequest) {
                this.requestText.getDocument().set(((IHTTPRequest)req).getBody());
            } else {
                this.requestText.getDocument().set("");
            }
            IResponse res = call.getResponse();
            if (res != null) {
                this.responseHeadersViewer.setInput((Object)res);
                if (res instanceof IHTTPResponse) {
                    PayloadRenderStrategyFactory strategyFactory = PayloadRenderStrategyFactory.getInstance();
                    IPayloadRenderStrategy strategy = strategyFactory.getStrategy((IHeaderContainer)((IHTTPResponse)res));
                    if (strategy.getRenderType() == "TEXT") {
                        Object responseBody = ((IHTTPResponse)res).getBody();
                        if (responseBody != null) {
                            this.responseText.getDocument().set(responseBody.toString());
                        } else {
                            this.responseText.getDocument().set("Loading...");
                            this.responseBodyGetterJob = new ResponseBodyGetterJob((IHTTPResponse)res);
                            this.responseBodyGetterJob.setUser(false);
                            this.responseBodyGetterJob.setPriority(10);
                            this.responseBodyGetterJob.schedule();
                        }
                        this.responseBodyItem.setControl(this.responseText.getControl());
                        ITextPayloadRenderStrategy textStrategy = (ITextPayloadRenderStrategy)strategy;
                        SourceViewerConfiguration sourceConfig = textStrategy.getConfiguration();
                        if (sourceConfig == null) {
                            this.formatButton.setVisible(false);
                            this.responseText.unconfigure();
                        } else {
                            this.formatButton.setVisible(true);
                            if (this.formatButton.getSelection()) {
                                this.responseText.unconfigure();
                                this.responseText.configure(textStrategy.getConfiguration());
                            } else {
                                this.responseText.unconfigure();
                            }
                        }
                        this.responseText.refresh();
                    } else if (strategy.getRenderType() == "IMAGE") {
                        this.responseBodyItem.setControl((Control)this.responseImage);
                        if (this.imageLabel.getImage() != null) {
                            this.imageLabel.getImage().dispose();
                        }
                        Image image = ImageDescriptor.createFromURL((URL)call.getRequest().getURL()).createImage();
                        this.imageLabel.setImage(image);
                        this.imageLabel.setSize(image.getBounds().width, image.getBounds().height);
                        this.formatButton.setVisible(false);
                    } else if (strategy.getRenderType() == "UNSUPPORTED") {
                        this.responseBodyItem.setControl((Control)this.responseUnsupported);
                        this.formatButton.setVisible(false);
                    } else {
                        this.clearResponseArea();
                    }
                } else {
                    this.responseText.getDocument().set("");
                    this.responseBodyItem.setControl(this.responseText.getControl());
                    this.responseText.refresh();
                }
            } else {
                this.clearResponseArea();
            }
        }
    }

    public void dispose() {
        this.clipboard.dispose();
        if (this.imageLabel != null && !this.imageLabel.isDisposed()) {
            this.imageLabel.dispose();
            this.imageLabel = null;
        }
    }

    protected class ResponseBodyGetterJob
    extends UIJob {
        protected int triesLeft;
        protected static final int DELAY = 250;
        protected IHTTPResponse response;

        public ResponseBodyGetterJob(IHTTPResponse response) {
            super("Response Body Getter");
            this.triesLeft = 5;
            this.response = null;
            this.response = response;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            --this.triesLeft;
            Object body = this.response.getBody();
            if (!monitor.isCanceled()) {
                if (body != null) {
                    RequestResponsePanel.this.responseText.getDocument().set(body.toString());
                } else if (this.triesLeft > 0) {
                    this.schedule(250L);
                } else {
                    RequestResponsePanel.this.responseText.getDocument().set("Cache not responding!");
                }
            }
            return Status.OK_STATUS;
        }
    }
}

