/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon.model.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.atf.mozilla.ide.network.IHTTPRequest;
import org.eclipse.atf.mozilla.ide.network.IHTTPResponse;
import org.eclipse.atf.mozilla.ide.network.INetworkCall;
import org.eclipse.atf.mozilla.ide.network.IRequest;
import org.eclipse.atf.mozilla.ide.network.IResponse;
import org.eclipse.atf.mozilla.ide.network.IStatusChange;

public class BaseNetworkCall
implements INetworkCall {
    public static final long STOP = -2L;
    public static final long START = 0L;
    protected IHTTPRequest request;
    protected IHTTPResponse response;
    private List statusChanges = new ArrayList();
    private long startTime = -1L;
    private long endTime = -1L;
    protected String state;

    public IRequest getRequest() {
        return this.request;
    }

    public IResponse getResponse() {
        return this.response;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public int getTotalTime() {
        if (this.endTime == -1L || this.startTime == -1L) {
            return -1;
        }
        return (int)(this.endTime - this.startTime);
    }

    public String getState() {
        return this.state;
    }

    public String toString() {
        return "BaseNetworkCall [startTime=" + this.startTime + ", state=" + this.state + ", endTime=" + this.endTime + ", request=" + this.request + ", response=" + this.response + "]";
    }

    public void addStatusChange(long status, long timestamp) {
        if (this.startTime == -1L) {
            this.startTime = timestamp;
        }
        this.endTime = timestamp;
        if (this.statusChanges.size() > 0) {
            StatusChange last = (StatusChange)this.statusChanges.get(this.statusChanges.size() - 1);
            if (last.status != status) {
                this.statusChanges.add(new StatusChange(status, timestamp));
            }
        } else {
            this.statusChanges.add(new StatusChange(status, timestamp));
        }
    }

    public IStatusChange[] getStatusChanges() {
        return this.statusChanges.toArray(new IStatusChange[this.statusChanges.size()]);
    }

    private class StatusChange
    implements IStatusChange {
        private long status;
        private long timestamp;

        public StatusChange(long status, long timestamp) {
            this.status = status;
            this.timestamp = timestamp;
        }

        public String getStatus() {
            if (this.status == 0L) {
                return "ACTIVE";
            }
            if (this.status == -2L) {
                return "DONE";
            }
            if (this.status == 2152398856L) {
                return "RECEIVING";
            }
            if (this.status == 2152398857L) {
                return "SENDING";
            }
            if (this.status == 2152398851L) {
                return "RESOLVING";
            }
            if (this.status == 2152398855L) {
                return "CONNECTING";
            }
            if (this.status == 2152398852L) {
                return "CONNECTING";
            }
            if (this.status == 2152398853L) {
                return "SENDING";
            }
            if (this.status == 2152398858L) {
                return "WAITING";
            }
            if (this.status == 2152398854L) {
                return "RECEIVING";
            }
            throw new IllegalStateException("Invalid status " + this.status);
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public BaseNetworkCall getCall() {
            return BaseNetworkCall.this;
        }
    }
}

