/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.atf.mozilla.ide.ui.netmon.model.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.atf.mozilla.ide.network.IHTTPRequest;
import org.eclipse.atf.mozilla.ide.ui.MozIDEUIPlugin;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.impl.BaseNetworkCall;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.impl.HTTPRequest;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.impl.HTTPResponse;
import org.eclipse.atf.mozilla.ide.ui.netmon.model.impl.MozHTTPResponse;
import org.mozilla.interfaces.nsIHttpChannel;
import org.mozilla.interfaces.nsIHttpHeaderVisitor;
import org.mozilla.interfaces.nsIInputStream;
import org.mozilla.interfaces.nsIScriptableInputStream;
import org.mozilla.interfaces.nsISeekableStream;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIUploadChannel;
import org.mozilla.interfaces.nsIXMLHttpRequest;
import org.mozilla.xpcom.Mozilla;

public class NetworkFactory {
    private static NetworkFactory _instance = new NetworkFactory();

    public static NetworkFactory getInstance() {
        return _instance;
    }

    private NetworkFactory() {
    }

    public IHTTPRequest createHTTPRequest(nsIHttpChannel httpChannel, boolean xhr) {
        String urlStr = httpChannel.getURI().getAsciiSpec();
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            MozIDEUIPlugin.log(e);
        }
        String method = httpChannel.getRequestMethod();
        String body = NetworkFactory.extractBody(httpChannel);
        MozHeadersVisitor visitor = new MozHeadersVisitor();
        httpChannel.visitRequestHeaders((nsIHttpHeaderVisitor)visitor);
        Map headers = visitor.getHeaders();
        return new HTTPRequest(url, method, body, headers, xhr);
    }

    public IHTTPRequest createHTTPRequest(nsIHttpChannel httpChannel) {
        return this.createHTTPRequest(httpChannel, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String extractBody(nsIHttpChannel httpChannel) {
        String method = httpChannel.getRequestMethod();
        if (!"POST".equals(method) && !"PUT".equals(method)) return httpChannel.getURI().getPath();
        nsIScriptableInputStream scriptableIS = null;
        nsISeekableStream seekableStream = null;
        nsIInputStream is = null;
        try {
            long count;
            nsIUploadChannel upChannel = (nsIUploadChannel)httpChannel.queryInterface("{ddf633d8-e9a4-439d-ad88-de636fd9bb75}");
            is = upChannel.getUploadStream();
            if (is == null) return null;
            seekableStream = (nsISeekableStream)is.queryInterface("{8429d350-1040-4661-8b71-f2a6ba455980}");
            scriptableIS = (nsIScriptableInputStream)Mozilla.getInstance().getComponentManager().createInstanceByContractID("@mozilla.org/scriptableinputstream;1", null, "{a2a32f90-9b90-11d3-a189-0050041caf44}");
            scriptableIS.init(is);
            StringBuffer postBuf = new StringBuffer();
            while ((count = scriptableIS.available()) > 0L) {
                postBuf.append(scriptableIS.read(count));
            }
            String string = postBuf.toString();
            return string;
        }
        catch (Exception e) {
            MozIDEUIPlugin.log(e);
            return null;
        }
        finally {
            if (seekableStream != null) {
                seekableStream.seek(0, 0L);
            }
        }
    }

    public HTTPResponse createHTTPResponse(nsIHttpChannel httpChannel) {
        String urlStr = httpChannel.getURI().getAsciiSpec();
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            MozIDEUIPlugin.log(e);
        }
        String status = String.valueOf(httpChannel.getResponseStatus()) + " " + httpChannel.getResponseStatusText();
        MozHeadersVisitor visitor = new MozHeadersVisitor();
        httpChannel.visitResponseHeaders((nsIHttpHeaderVisitor)visitor);
        Map headers = visitor.getHeaders();
        return new MozHTTPResponse(url, status, null, headers);
    }

    public static void captureResponse(BaseNetworkCall call, nsIXMLHttpRequest xhr, boolean error) {
        try {
            if (!error) {
                nsIHttpChannel httpChannel = (nsIHttpChannel)xhr.getChannel().queryInterface("{9277fe09-f0cc-4cd9-bbce-581dd94b0260}");
                NetworkFactory.captureResponse(call, httpChannel, -2L);
                ((HTTPResponse)call.response).setBody(xhr.getResponseText());
            } else {
                call.state = "ERROR";
            }
        }
        catch (Exception exception) {
            call.state = "ERROR";
        }
        call.addStatusChange(-2L, System.currentTimeMillis());
    }

    public static void captureRequest(BaseNetworkCall call, nsIHttpChannel httpChannel, boolean xhr) {
        call.addStatusChange(0L, System.currentTimeMillis());
        call.state = "ACTIVE";
        call.request = NetworkFactory.getInstance().createHTTPRequest(httpChannel, xhr);
    }

    public static void captureResponse(BaseNetworkCall call, nsIHttpChannel httpChannel, long stateFlag) {
        long endTime = System.currentTimeMillis();
        try {
            call.response = NetworkFactory.getInstance().createHTTPResponse(httpChannel);
            call.state = httpChannel.getResponseStatus() == 200L ? "SUCCESS" : "WARNING";
        }
        catch (Exception exception) {
            call.state = "ERROR";
        }
        call.addStatusChange(stateFlag, endTime);
    }

    private static class MozHeadersVisitor
    implements nsIHttpHeaderVisitor {
        private Map result = new HashMap();

        private MozHeadersVisitor() {
        }

        public void visitHeader(String headerName, String headerValue) {
            this.result.put(headerName, headerValue);
        }

        public nsISupports queryInterface(String id) {
            return Mozilla.queryInterface((nsISupports)this, (String)id);
        }

        public Map getHeaders() {
            return this.result;
        }
    }
}

